/*
 * Decompiled with CFR 0.152.
 */
package oracle.xmlc.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.transform.Source;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.javatools.buffer.TextBuffer;
import oracle.xmlc.engine.ContributorSequence;
import oracle.xmlc.model.XMLDocumentRoot;
import oracle.xmlc.model.XMLResourceElement;
import oracle.xmlc.parser.SourceParserException;

public abstract class SourceParser {
    public void setTextDelimiter(String textDelimiter) {
    }

    public void setGrammarProvider(GrammarProvider grammarProvider) {
    }

    public abstract XMLResourceElement parseSource(Source var1) throws SourceParserException;

    public abstract String getElementValue(XMLResourceElement var1, ContributorSequence var2, boolean var3) throws SourceParserException;

    public boolean isOffsetCapable() {
        return false;
    }

    public int[] getElementOffsets(XMLResourceElement element) {
        return null;
    }

    public abstract String convertInternalModelToString(XMLDocumentRoot var1) throws SourceParserException;

    public void cleanup() {
    }

    protected final String readProlog(Reader reader) throws IOException {
        return SourceParser._readProlog(reader);
    }

    protected final XMLDocumentRoot createDocumentRoot(String prolog) {
        return SourceParser._createDocumentRoot(prolog);
    }

    protected final String getXMLEncoding(InputStream inStream) throws IOException {
        char[] array = new char[512];
        InputStreamReader reader = new InputStreamReader(inStream);
        reader.read(array, 0, array.length);
        boolean LESS = true;
        int IN_PI = 2;
        int IN_XML = 5;
        int ENCODING_START = 6;
        int ENCODING_EQ = 7;
        int IN_ENCODING = 8;
        int state = 0;
        StringBuffer encoding = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            switch (state) {
                case 0: {
                    if (c != '<') break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c != '?') break;
                    state = 2;
                    break;
                }
                case 2: {
                    if (c != 'x' || array.length <= i + 2 || array[i + 1] != 'm' || array[i + 2] != 'l') break;
                    i += 2;
                    state = 5;
                    break;
                }
                case 5: {
                    String attrib;
                    if (c != 'e' || array.length <= i + 7 || !"encoding".equals(attrib = new String(array, i, 8))) break;
                    i += 7;
                    state = 6;
                    break;
                }
                case 6: {
                    if (c != '=') break;
                    state = 7;
                    break;
                }
                case 7: {
                    if (Character.isWhitespace(c)) break;
                    state = 8;
                    if (c == '\'' || c == '\"') break;
                    encoding.append(c);
                    break;
                }
                case 8: {
                    if (Character.isWhitespace(c) || c == '\'' || c == '\"') {
                        return encoding.toString();
                    }
                    encoding.append(c);
                }
            }
            ++i;
        }
        return null;
    }

    static final String _readProlog(Reader reader) throws IOException {
        StringBuffer prolog = new StringBuffer();
        int character = -1;
        while ((character = reader.read()) != -1) {
            int previousCharacter = prolog.length() == 0 ? 32 : (int)prolog.charAt(prolog.length() - 1);
            prolog.append((char)character);
            if (previousCharacter == 60 && Character.isLetter((char)character)) break;
        }
        return prolog.toString().trim();
    }

    static final XMLDocumentRoot _createDocumentRoot(String prolog) {
        if (prolog != null && prolog.trim().toLowerCase().startsWith("<?xml")) {
            int i = prolog.indexOf(62);
            String XMLDecl = i >= 0 ? prolog.substring("<?xml".length(), i) : null;
            return new XMLDocumentRoot(XMLDecl);
        }
        return new XMLDocumentRoot();
    }

    public void reformat(TextBuffer textBuffer) throws IOException {
    }
}

