/*
 * Decompiled with CFR 0.152.
 */
package oracle.xmlc.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.xmlc.engine.ComparableElement;
import oracle.xmlc.engine.ContributorSequence;
import oracle.xmlc.model.XMLAttribute;
import oracle.xmlc.model.XMLDocumentRoot;
import oracle.xmlc.model.XMLResourceElement;
import oracle.xmlc.parser.SourceParser;
import oracle.xmlc.parser.SourceParserException;
import oracle.xmlc.parser.XMLResourceParser;

public class SourceParserImplV1
extends SourceParser {
    public XMLResourceElement parseSource(Source source) throws SourceParserException {
        XMLResourceParser parser = new XMLResourceParser();
        ComparableElement[] contents = parser.parse(source.getSystemId(), this.createReader(source));
        if (contents.length != 0 && (contents.length != 1 || contents[0] != null)) {
            return (XMLResourceElement)contents[0];
        }
        SourceParserException spe = new SourceParserException("Illegal XML document: " + source.getSystemId());
        spe.setSeverity(0);
        throw spe;
    }

    private Reader createReader(Source source) throws SourceParserException {
        if (source instanceof StreamSource) {
            Reader reader = ((StreamSource)source).getReader();
            if (reader != null) {
                return reader;
            }
            InputStream inputStream = ((StreamSource)source).getInputStream();
            if (inputStream != null) {
                return new InputStreamReader(inputStream);
            }
            throw new IllegalArgumentException();
        }
        if (source instanceof DOMSource) {
            StringWriter stringWriter = new StringWriter();
            try {
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                transformer.transform(source, new StreamResult(stringWriter));
            }
            catch (TransformerConfigurationException tce) {
                throw new SourceParserException(tce);
            }
            catch (TransformerException te) {
                throw new SourceParserException(te);
            }
            return new StringReader(stringWriter.getBuffer().toString());
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getElementValue(XMLResourceElement element, ContributorSequence contributor, boolean format) throws SourceParserException {
        if (element instanceof XMLAttribute) {
            XMLResourceElement contributorElement = (XMLResourceElement)element.getComparableElement(contributor);
            if (contributorElement == null) return "";
            String string = contributorElement.getValue(format ^ true);
            return string;
        }
        ContributorSequence selectedContributor = element.getSelectedContributor();
        BufferedReader br = null;
        try {
            if (contributor != null) {
                element.select(contributor);
            }
            br = new BufferedReader(new XMLResourceParser().save(new ComparableElement[]{element}, 0, 2));
            StringBuffer valueBuffer = new StringBuffer();
            while (true) {
                String line;
                if ((line = br.readLine()) == null) {
                    String string = valueBuffer.toString();
                    return string;
                }
                if (format && valueBuffer.length() > 0) {
                    valueBuffer.append('\n');
                }
                valueBuffer.append(format ? line : line.trim());
            }
        }
        catch (IOException ioe) {
            throw new SourceParserException(ioe);
        }
        finally {
            if (contributor != null) {
                element.select(selectedContributor);
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String convertInternalModelToString(XMLDocumentRoot documentRoot) throws SourceParserException {
        return this.getElementValue(documentRoot, null, true);
    }
}

