/*
 * Decompiled with CFR 0.152.
 */
package oracle.xmlc.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.buffer.BufferDomModelPluginFactory;
import oracle.bali.xml.dom.buffer.DefaultDocumentScannerFactory;
import oracle.bali.xml.dom.buffer.DefaultParserConfiguration;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.impl.DomModelFactory;
import oracle.bali.xml.dom.impl.DomModelPluginFactory;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xmlc.engine.ContributorSequence;
import oracle.xmlc.model.XMLAttribute;
import oracle.xmlc.model.XMLCDATA;
import oracle.xmlc.model.XMLCharacterBlock;
import oracle.xmlc.model.XMLCharacterBlockLine;
import oracle.xmlc.model.XMLComment;
import oracle.xmlc.model.XMLDoctype;
import oracle.xmlc.model.XMLDocumentRoot;
import oracle.xmlc.model.XMLElement;
import oracle.xmlc.model.XMLProcessingInstruction;
import oracle.xmlc.model.XMLResourceElement;
import oracle.xmlc.parser.SourceParser;
import oracle.xmlc.parser.SourceParserException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceParserImplV2
extends SourceParser {
    private String _textDelimiter;
    private GrammarProvider _grammarProvider;
    private Map<Document, TextBuffer> _textBufferMap;
    private Map<Document, XmlContext> _xmlContextMap;
    private Map<XMLResourceElement, Node> _nodeMap;

    private void $init$() {
        this._textDelimiter = null;
        this._grammarProvider = null;
        this._textBufferMap = new HashMap<Document, TextBuffer>();
        this._xmlContextMap = new HashMap<Document, XmlContext>();
        this._nodeMap = new HashMap<XMLResourceElement, Node>();
    }

    @Override
    public void setTextDelimiter(String textDelimiter) {
        this._textDelimiter = textDelimiter;
    }

    @Override
    public void setGrammarProvider(GrammarProvider grammarProvider) {
        this._grammarProvider = grammarProvider;
    }

    @Override
    public XMLResourceElement parseSource(Source source) throws SourceParserException {
        Prolog prolog = new Prolog(null);
        return this.convertDOMToInternalModel(this.createDocument(source, prolog), prolog);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document createDocument(Source source, Prolog prolog) throws SourceParserException {
        TextBuffer textBuffer = null;
        if (source instanceof StreamSource) {
            try {
                textBuffer = this.createTextBuffer(source, prolog);
            }
            catch (IOException ioe) {
                throw new SourceParserException(ioe);
            }
        }
        if (source instanceof DOMSource) {
            try {
                DOMSource domSource = (DOMSource)source;
                if (!(domSource.getNode() instanceof Document)) {
                    throw new IllegalArgumentException();
                }
                Document document = (Document)domSource.getNode();
                textBuffer = this.createTextBuffer(new StringReader(this.transformToString(document, true)));
                document = (Document)document.cloneNode(false);
                while (true) {
                    if (document.getChildNodes().getLength() <= 0) {
                        prolog.setSource(this.transformToString(document, false));
                        break;
                    }
                    document.removeChild(document.getChildNodes().item(0));
                }
            }
            catch (IOException ioe) {
                throw new SourceParserException(ioe);
            }
        }
        if (textBuffer == null) {
            throw new IllegalArgumentException();
        }
        Reader reader = this.createReader(textBuffer);
        try {
            ParserXmlContext xmlContext = new ParserXmlContext(textBuffer, this._grammarProvider);
            xmlContext.getModel().acquireReadLock();
            Document document = xmlContext.getModel().getDocument();
            xmlContext.getModel().releaseReadLock();
            xmlContext.getModel().getDomModel().acquireWriteLock();
            prolog.setSource(this.readProlog(reader));
            this._textBufferMap.put(document, textBuffer);
            this._xmlContextMap.put(document, xmlContext);
            Document document2 = document;
            return document2;
        }
        catch (IOException ioe) {
            throw new SourceParserException(ioe);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private TextBuffer createTextBuffer(Source source, Prolog prolog) throws IOException {
        Reader reader = ((StreamSource)source).getReader();
        if (reader != null) {
            return this.createTextBuffer(reader);
        }
        InputStream inputStream = ((StreamSource)source).getInputStream();
        if (inputStream != null) {
            byte[] bytes = new byte[1024];
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, bytes.length);
            int n = pushbackInputStream.read(bytes, 0, bytes.length);
            if (n >= 0) {
                pushbackInputStream.unread(bytes, 0, n);
                inputStream = pushbackInputStream;
            }
            String charsetName = this.getXMLEncoding(new ByteArrayInputStream(bytes, 0, n));
            prolog.setEncoding(charsetName);
            return this.createTextBuffer(charsetName != null ? new InputStreamReader(inputStream, charsetName) : new InputStreamReader(inputStream));
        }
        throw new IllegalArgumentException();
    }

    private TextBuffer createTextBuffer(Reader reader) throws IOException {
        TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
        textBuffer.read(reader);
        textBuffer.writeLock();
        return textBuffer;
    }

    private Reader createReader(TextBuffer textBuffer) {
        return new StringReader(textBuffer.getString(0, textBuffer.getLength()));
    }

    private XMLResourceElement convertDOMToInternalModel(Node node, Prolog prolog) throws SourceParserException {
        XMLResourceElement element = this._convertDOMToInternalModel(node, prolog);
        this._nodeMap.put(element, node);
        if (!(node instanceof Attr) && !(node instanceof EntityReference)) {
            NamedNodeMap attributes = node.getAttributes();
            int i = 0;
            while (attributes != null && i < attributes.getLength()) {
                element.addDiffChild(this.convertDOMToInternalModel(attributes.item(i), prolog));
                ++i;
            }
            NodeList childNodes = node.getChildNodes();
            int i2 = 0;
            while (childNodes != null && i2 < childNodes.getLength()) {
                element.addDiffChild(this.convertDOMToInternalModel(childNodes.item(i2), prolog));
                ++i2;
            }
        }
        return element;
    }

    private XMLResourceElement _convertDOMToInternalModel(Node node, Prolog prolog) throws SourceParserException {
        if (node instanceof Document) {
            return this.createDocumentRoot(prolog.getSource());
        }
        if (node instanceof Attr) {
            Attr attr = (Attr)node;
            return new XMLAttribute(attr.getName(), attr.getValue());
        }
        if (node instanceof CDATASection) {
            XMLCDATA element = new XMLCDATA();
            element.addDiffChild(this.createCharacterBlock(((CDATASection)node).getData()));
            return element;
        }
        if (node instanceof Comment) {
            return new XMLComment(((Comment)node).getData());
        }
        if (node instanceof Text) {
            return this.createCharacterBlock(this.getNodeValue(node));
        }
        if (node instanceof Element) {
            return new XMLElement(((Element)node).getTagName());
        }
        if (node instanceof DocumentType) {
            DocumentType documentType = (DocumentType)node;
            String nodeValue = this.getNodeValue(node);
            XMLDoctype element = new XMLDoctype(documentType.getName() + " [" + (nodeValue != null ? this.extractDTDInternalSubset(nodeValue) : "") + "]");
            return element;
        }
        if (node instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
            return new XMLProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
        }
        return this.createCharacterBlock(this.transformToString(node, false));
    }

    private XMLCharacterBlock createCharacterBlock(String lines) {
        XMLCharacterBlock characterBlock = new XMLCharacterBlock();
        if (this._textDelimiter == null) {
            characterBlock.addChildElement(new XMLCharacterBlockLine(lines));
            return characterBlock;
        }
        String[] stringArray = lines.split(Pattern.quote(this._textDelimiter));
        int n = 0;
        while (n < stringArray.length) {
            String line = stringArray[n];
            characterBlock.addChildElement(new XMLCharacterBlockLine(line));
            ++n;
        }
        return characterBlock;
    }

    private String extractDTDInternalSubset(String documentTypeValue) {
        int i = documentTypeValue.indexOf(91);
        if (i >= 0) {
            documentTypeValue = documentTypeValue.substring(i + 1);
        }
        if ((i = documentTypeValue.indexOf(93)) >= 0) {
            documentTypeValue = documentTypeValue.substring(0, i);
        }
        return documentTypeValue;
    }

    @Override
    public String getElementValue(XMLResourceElement element, ContributorSequence contributor, boolean format) throws SourceParserException {
        XMLResourceElement contributorElement;
        XMLResourceElement xMLResourceElement = contributorElement = contributor != null ? (XMLResourceElement)element.getComparableElement(contributor) : element;
        if (contributorElement == null) {
            return "";
        }
        if (this._nodeMap.get(contributorElement) == null) {
            return contributorElement.getValue();
        }
        if (contributorElement instanceof XMLAttribute) {
            return ((Attr)this._nodeMap.get(contributorElement)).getValue();
        }
        String nodeValue = this.getNodeValue(this._nodeMap.get(contributorElement));
        return nodeValue != null ? nodeValue : this.transformToString(this._nodeMap.get(contributorElement), format);
    }

    private String getNodeValue(Node node) {
        int[] offsets = this.getNodeOffsets(node);
        TextBuffer textBuffer = this._textBufferMap.get(node.getOwnerDocument());
        if (offsets != null && textBuffer != null) {
            return textBuffer.getString(offsets[0], offsets[1] - offsets[0]);
        }
        return null;
    }

    private String transformToString(Node node, boolean format) throws SourceParserException {
        return this.transformToString(node, format, null);
    }

    private String transformToString(Node node, boolean format, Map<String, String> outputProperties) throws SourceParserException {
        try {
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (format) {
                try {
                    transformerFactory.setAttribute("indent-number", 2);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
            Transformer transformer = transformerFactory.newTransformer();
            if (format) {
                transformer.setOutputProperty("indent", "yes");
            }
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("media-type", "text/xml");
            if (outputProperties != null) {
                for (String key : outputProperties.keySet()) {
                    transformer.setOutputProperty(key, outputProperties.get(key));
                }
            }
            transformer.transform(new DOMSource(node), streamResult);
            TextBuffer textBuffer = this.createTextBuffer(new StringReader(stringWriter.getBuffer().toString()));
            stringWriter = new StringWriter();
            textBuffer.setEOLType("\n");
            textBuffer.write((Writer)stringWriter);
            String string = stringWriter.getBuffer().toString();
            return string;
        }
        catch (TransformerConfigurationException tce) {
            throw new SourceParserException(tce);
        }
        catch (TransformerException te) {
            throw new SourceParserException(te);
        }
        catch (IOException ioe) {
            throw new SourceParserException(ioe);
        }
    }

    @Override
    public boolean isOffsetCapable() {
        return true;
    }

    @Override
    public int[] getElementOffsets(XMLResourceElement element) {
        if (element.getXMLParent() instanceof XMLCharacterBlock) {
            element = element.getXMLParent();
        }
        if (element.getXMLParent() instanceof XMLCDATA) {
            element = element.getXMLParent();
        }
        return this._nodeMap.get(element) != null ? this.getNodeOffsets(this._nodeMap.get(element)) : null;
    }

    private int[] getNodeOffsets(Node node) {
        Document ownerDocument = node.getOwnerDocument();
        XmlContext xmlContext = this._xmlContextMap.get(ownerDocument);
        if (xmlContext == null) {
            return null;
        }
        int[] offsets = new int[2];
        xmlContext.getModel().acquireReadLock();
        xmlContext.getModel().getDomModel().getTextOffsets(node, offsets);
        xmlContext.getModel().releaseReadLock();
        return offsets;
    }

    @Override
    public void cleanup() {
        this._textBufferMap.clear();
        this._xmlContextMap.clear();
        this._nodeMap.clear();
    }

    @Override
    public String convertInternalModelToString(XMLDocumentRoot documentRoot) throws SourceParserException {
        XMLResourceElement contributorElement = (XMLResourceElement)documentRoot.getComparableElement(documentRoot.getSelectedContributor());
        StringBuffer documentBuffer = new StringBuffer();
        String xmlDeclaration = contributorElement.getValue();
        if (xmlDeclaration != null) {
            documentBuffer.append("<?xml");
            documentBuffer.append(xmlDeclaration);
            documentBuffer.append(">\n");
        }
        XMLResourceElement documentElement = null;
        int documentElementIndex = 0;
        Iterator itr = documentRoot.getChildElements();
        while (itr.hasNext()) {
            XMLResourceElement childElement = (XMLResourceElement)itr.next();
            if (childElement instanceof XMLElement) {
                documentElement = childElement;
                documentElementIndex = documentBuffer.length();
                continue;
            }
            documentBuffer.append(this.getElementValue(childElement, childElement.getSelectedContributor(), true));
            documentBuffer.append('\n');
        }
        try {
            if (documentElement != null) {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                this._convertInternalModelToDOM(document, (Node)document, Collections.singleton(documentElement).iterator());
                HashMap<String, String> outputKeys = new HashMap<String, String>();
                outputKeys.put("omit-xml-declaration", "yes");
                documentBuffer.insert(documentElementIndex, this.transformToString(document, true, outputKeys));
            }
            String string = documentBuffer.toString();
            return string;
        }
        catch (ParserConfigurationException pce) {
            throw new SourceParserException(pce);
        }
    }

    private void _convertInternalModelToDOM(Document document, Node contextNode, Iterator itr) {
        while (contextNode != null && itr != null && itr.hasNext()) {
            Node importNode;
            XMLResourceElement element = (XMLResourceElement)itr.next();
            if (element instanceof XMLDoctype) continue;
            boolean cdata = element instanceof XMLCDATA;
            if (cdata || element instanceof XMLCharacterBlock) {
                contextNode.appendChild(this._convertInternalModelToDOM(document, element, cdata));
                continue;
            }
            XMLResourceElement contributorElement = (XMLResourceElement)element.getComparableElement(element.getSelectedContributor());
            if (contributorElement == null || (importNode = this._convertInternalModelToDOM(document, contextNode, contributorElement)) instanceof Attr || importNode instanceof EntityReference) continue;
            this._convertInternalModelToDOM(document, importNode, element.getDiffChildren());
        }
    }

    private Node _convertInternalModelToDOM(Document document, XMLResourceElement element, boolean cdata) {
        XMLCharacterBlock characterBlock = (XMLCharacterBlock)(cdata ? element.getDiffChildren().next() : element);
        StringBuffer textBuffer = new StringBuffer();
        Iterator itr2 = characterBlock.getChildElements();
        while (itr2.hasNext()) {
            XMLCharacterBlockLine characterBlockLine = (XMLCharacterBlockLine)itr2.next();
            XMLCharacterBlockLine contributorCharacterBlockLine = (XMLCharacterBlockLine)characterBlockLine.getComparableElement(characterBlockLine.getSelectedContributor());
            if (contributorCharacterBlockLine == null) continue;
            if (textBuffer.length() > 0 && this._textDelimiter != null) {
                textBuffer.append(this._textDelimiter);
            }
            textBuffer.append(contributorCharacterBlockLine.getCompareDisplayString());
        }
        return document.createTextNode(textBuffer.toString());
    }

    private Node _convertInternalModelToDOM(Document document, Node contextNode, XMLResourceElement element) {
        if (this._nodeMap.get(element) == null) {
            return null;
        }
        if (this._nodeMap.get(element) instanceof DocumentType) {
            throw new IllegalStateException();
        }
        if (this._nodeMap.get(element) instanceof Attr) {
            Node importNode = document.importNode(this._nodeMap.get(element), true);
            if (!(contextNode instanceof Element)) {
                throw new IllegalStateException();
            }
            ((Element)contextNode).setAttributeNode((Attr)importNode);
            return importNode;
        }
        Node importNode = document.importNode(this._nodeMap.get(element), false);
        if (importNode instanceof Element) {
            Element elem = (Element)importNode;
            NamedNodeMap attributes = elem.getAttributes();
            while (elem.hasAttributes()) {
                elem.removeAttributeNode((Attr)attributes.item(0));
            }
        }
        while (importNode.getChildNodes().getLength() > 0) {
            importNode.removeChild(importNode.getChildNodes().item(0));
        }
        contextNode.appendChild(importNode);
        return importNode;
    }

    @Override
    public void reformat(TextBuffer textBuffer) throws IOException {
        ParserXmlContext xmlContext = new ParserXmlContext(textBuffer, this._grammarProvider);
        DomModel domModel = xmlContext.getModel().getDomModel();
        domModel.acquireWriteLock();
        try {
            domModel.reformatSubtree(null, (Node)domModel.getDocument());
        }
        finally {
            domModel.releaseWriteLock();
        }
    }

    public SourceParserImplV2() {
        this.$init$();
    }

    private static class Prolog {
        private String _source;
        private String _encoding;

        String getSource() {
            return this._source;
        }

        void setSource(String source) {
            this._source = source;
        }

        String getEncoding() {
            return this._encoding;
        }

        void setEncoding(String encoding) {
            this._encoding = encoding;
        }

        private Prolog() {
        }

        Prolog(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ParserXmlContext
    extends XmlContext {
        private final TextBuffer _textBuffer;
        private final URL _url;
        private final GrammarProvider _grammarProvider;

        ParserXmlContext(TextBuffer textBuffer, GrammarProvider grammarProvider) throws IOException {
            this._textBuffer = textBuffer;
            this._url = new URL(null, "ide.xmlc://" + String.valueOf(this.hashCode()), new URLStreamHandlerImpl());
            this._grammarProvider = grammarProvider;
            this.finishInitialization();
            this.setModel(this.createXmlModel());
        }

        protected XmlModel createXmlModel() {
            return new XmlModel();
        }

        protected GrammarProvider createGrammarProvider() {
            return this._grammarProvider != null ? this._grammarProvider : super.createGrammarProvider();
        }

        protected DomModel createSourceDomModel(XmlModel xmlModel) {
            BufferDomModelPluginFactory pluginFactory = new BufferDomModelPluginFactory(this._textBuffer, (DOMImplementation)new XMLDOMImplementation(), (ParserConfiguration)new DefaultParserConfiguration(), (DocumentScannerFactory)new DefaultDocumentScannerFactory());
            DomModel dom = DomModelFactory.createDomModel((DomModelContext)this, (DomModelPluginFactory)pluginFactory, (WhitespaceHandler)xmlModel.getWhitespaceHandler());
            return dom;
        }

        public URL getURLForRelativePath(String relativePath) {
            return null;
        }

        public URL getURL() {
            return this._url;
        }

        public String getRelativePathForURL(URL absoluteURL) {
            throw new UnsupportedOperationException("not implemented");
        }

        static class URLStreamHandlerImpl
        extends URLStreamHandler {
            protected URLConnection openConnection(URL url) throws IOException {
                return new 1(url);
            }

            URLStreamHandlerImpl() {
            }

            final class 1
            extends URLConnection {
                public void connect() {
                }

                public 1(URL uRL) {
                    super(uRL);
                }
            }
        }
    }
}

