/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.createRepository;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.createRepository.RunRepositoryScripts;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class CallRunScripts
extends AbstractMigrationProgressRunnable {
    public static final int REPOSITORY_BYTE_SIZE = 20000;
    private RunRepositoryScripts m_worker;
    private int m_mode = 5;
    private JPanel m_downJpanel = null;
    private JLabel m_downJlabel = null;
    private String m_text = "";

    public CallRunScripts(RunRepositoryScripts worker, int mode) {
        this.m_worker = worker;
        this.m_mode = mode;
        worker.setMode(mode);
        worker.setProgressBar(this);
        String title = "";
        String message = "";
        if (this.m_mode == 1) {
            title = MigrationAddinArb.getString(197);
            message = MigrationAddinArb.getString(196);
            this.setUseBuzyBar(false);
        } else if (this.m_mode == 2) {
            title = MigrationAddinArb.getString(199);
            message = MigrationAddinArb.getString(198);
        } else {
            title = MigrationAddinArb.getString(201);
            message = MigrationAddinArb.getString(200);
        }
        this.setTitle(title);
        this.setMessage(message);
        this.m_downJpanel = new JPanel();
        BorderLayout secondLayout = new BorderLayout();
        this.m_downJpanel.setLayout(secondLayout);
        this.m_downJlabel = new JLabel();
        this.m_downJpanel.add((Component)this.m_downJlabel, "West");
        if (this.m_mode == 2) {
            this.m_downJlabel.setText(MigrationAddinArb.getString(209));
        }
    }

    public void setScript(String script) {
        this.m_worker.setScript(script);
    }

    public void doCancel() {
        super.doCancel();
        this.m_worker.signalCancel();
    }

    protected Object doWork() throws Exception {
        this.m_worker.run();
        return this.m_worker.getSuccess();
    }

    protected void finish(Object result) {
        Boolean success = (Boolean)result;
        if (success == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(202), null, null);
        } else if (success.equals(Boolean.FALSE) && this.m_worker.wasCancelled()) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(216), null, null);
        } else if (success.equals(Boolean.FALSE)) {
            if (this.m_mode == 5) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(203), null, null);
            } else {
                String msg = MigrationAddinArb.getString(204);
                if (this.m_mode == 1) {
                    msg = msg + "\n" + MigrationAddinArb.getString(205);
                }
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)msg, null, null);
            }
        }
    }

    public JPanel getDownPanel() {
        return this.m_downJpanel;
    }

    public JPanel getTopPanel() {
        return null;
    }

    public void updateAbovePanel(Object object) {
    }

    public void updateBelowPanel(Object text) {
        if (text instanceof String) {
            this.setText((String)text);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        CallRunScripts.this.m_downJlabel.setText(CallRunScripts.this.getText());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int mode) {
        this.m_mode = mode;
    }

    public synchronized String getText() {
        return this.m_text;
    }

    public synchronized void setText(String text) {
        this.m_text = text;
    }
}

