/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.createRepository;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;

public final class RepositoryRegistry {
    private static final String KEY_PACKAGE = "PACKAGE";
    private static final String KEY_TYPE = "TYPE";
    private static final String KEY_SEQUENCE = "SEQUENCE";
    private static final String KEY_VIEW = "VIEW";
    private static final String KEY_TABLE = "TABLE";
    private static List<RegistryData> s_repoEntityList = new ArrayList<RegistryData>();

    private RepositoryRegistry() {
    }

    public static boolean dropRepository(Connection conn, AbstractMigrationProgressRunnable runnable) {
        boolean ret = true;
        try {
            Statement statement = conn.createStatement();
            for (int i = 0; i < s_repoEntityList.size(); ++i) {
                RegistryData key = s_repoEntityList.get(i);
                try {
                    String query = "DROP " + key.getId() + " " + key.getValue();
                    if (KEY_TABLE.equals(key.getId())) {
                        query = query + " CASCADE CONSTRAINTS";
                    }
                    runnable.updateProgress(i * 100 / s_repoEntityList.size(), "", "Deleting " + key.getId() + " " + key.getValue());
                    statement.executeUpdate(query);
                    continue;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 942 || e.getErrorCode() == 4043 || e.getErrorCode() == 2289) continue;
                    ret = false;
                    MigrationLogUtil.logThrowable(e.getMessage(), MigrationAddinArb.getString(199), (Throwable)e);
                }
            }
        }
        catch (SQLException e) {
            MigrationLogUtil.logThrowable(e.getMessage(), new Object[0], (Throwable)e);
            ret = false;
        }
        if (ret) {
            runnable.updateProgress(100, "", MigrationAddinArb.getString(210));
        }
        return ret;
    }

    static {
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "MD_META"));
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "MIGRATION_TRANSFORMER"));
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "MIGRATION"));
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "MIGRATIONTEST"));
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "MIGRATION_REPORT"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_TABLES"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_SCHEMA"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_CATALOGS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_CONNECTIONS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_VIEWS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_STORED_PROGRAMS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_VIEW_TRIGGERS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_TABLE_TRIGGERS"));
        s_repoEntityList.add(new RegistryData(KEY_SEQUENCE, "DBOBJECTID_SEQUENCE"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_PROJECTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_CONNECTIONS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_USERS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_SCHEMAS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_TABLES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_VIEWS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_INDEXES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_COLUMNS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_INDEX_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_GROUPS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_GROUP_MEMBERS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_PRIVILEGES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_USER_DEFINED_DATA_TYPES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_TRIGGERS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_STORED_PROGRAMS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_TABLESPACES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_ADDITIONAL_PROPERTIES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_DERIVATIVES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_SEQUENCES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_PACKAGES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_OTHER_OBJECTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_SYNONYMS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_REPOVERSIONS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_CONSTRAINTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_CONSTRAINT_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_CATALOGS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MIGRLOG"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_GROUP_PRIVILEGES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_USER_PRIVILEGES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MIGR_DATATYPE_TRANSFORM_MAP"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MIGR_DATATYPE_TRANSFORM_RULE"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_MIGR_PARAMETER"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_MIGR_DEPENDENCY"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MIGR_GENERATION_ORDER"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_REGISTRY"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_MIGR_WEAKDEP"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MIGRATION_RESERVED_WORDS"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_FILTER_SET"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_FILTER"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "NAMELIST"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "NAME_AND_COUNT_ARRAY"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "NAME_AND_COUNT_T"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "OBJECTIDLIST"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_REPORT_DETAIL_TABLE"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_REPORT_DETAIL_ROW"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_REPORT_SUM_TABLE"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_REPORT_SUM_ROW"));
    }

    private static final class RegistryData {
        private final String _id;
        private final String _value;

        public RegistryData(String id, String value) {
            this._id = id;
            this._value = value;
        }

        public String getId() {
            return this._id;
        }

        public String getValue() {
            return this._value;
        }
    }
}

