/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.createRepository;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;

public class RunRepositoryScripts {
    public static final int CREATE_REPOSITORY = 1;
    public static final int DROP_REPOSITORY = 2;
    public static final int UPGRADE_REPOSITORY = 3;
    public static final int PURGE_REPOSITORY = 4;
    public static final int GENERIC = 5;
    private boolean m_first = true;
    private String m_firstVsn;
    private Connection m_conn = null;
    private Boolean m_success = null;
    private String m_script = "";
    private AbstractMigrationProgressRunnable m_progressBar = null;
    private int m_mode = 5;
    private ScriptRunnerContext m_context;
    private ScriptRunner runner;
    private boolean m_cancelled = false;

    public RunRepositoryScripts(Connection conn) {
        this.setConnection(conn);
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public void setConnection(Connection conn) {
        this.m_conn = conn;
    }

    public void close() throws SQLException {
        if (this.m_conn != null) {
            this.m_conn.close();
        }
    }

    public void run(Connection inconn) throws SQLException {
        this.close();
        this.setConnection(inconn);
        this.run();
    }

    public void run() {
        URL topScript = this.getClass().getResource(this.m_script);
        this.m_context = new ScriptRunnerContext();
        this.m_context.setTopLevel(true);
        this.m_context.setLastUrl(topScript);
        this.m_context.setSqlError(5);
        this.m_context.setOsError(5);
        BufferedOutputStream out = null;
        ByteArrayOutputStream bout = null;
        if (this.m_mode == 1) {
            MaskByteArrayOutputStream mbout = new MaskByteArrayOutputStream();
            out = new BufferedOutputStream(mbout);
            this.m_progressBar.getProgBar().setExitOnDone(true);
            mbout.setCallRunScripts(this.m_progressBar);
        } else {
            bout = new ByteArrayOutputStream();
            out = new BufferedOutputStream(bout);
        }
        this.runner = new ScriptRunner(topScript, this.getConnection());
        this.runner.setScriptRunnerContext(this.m_context);
        this.runner.setOut(out);
        this.runner.setName("Migration Execution Thread");
        this.runner.run();
        if (this.m_context.getReturnExited()) {
            this.setSuccess(Boolean.FALSE);
            this.m_progressBar.updateProgress(100, null, MigrationAddinArb.getString(208));
        } else {
            this.setSuccess(Boolean.TRUE);
            if (this.m_mode == 2) {
                this.m_progressBar.updateProgress(100, null, MigrationAddinArb.getString(210));
            } else if (this.m_mode == 1) {
                this.m_progressBar.updateProgress(100, null, MigrationAddinArb.getString(207));
            } else if (this.m_mode == 3) {
                String toVsn;
                StringTokenizer st = new StringTokenizer(this.m_script, "_");
                st.nextToken();
                String fromVsn = st.nextToken();
                if (this.m_first) {
                    this.m_firstVsn = fromVsn;
                    this.m_first = false;
                }
                if (Integer.parseInt(toVsn = st.nextToken()) == 19) {
                    fromVsn = this.m_firstVsn;
                }
                String message = MigrationAddinArb.getString(61) + " " + fromVsn + " " + MigrationAddinArb.getString(62) + " " + toVsn + " " + MigrationAddinArb.getString(63);
                this.m_progressBar.updateProgress(100, null, message);
            } else if (this.m_mode == 4) {
                String message = MigrationAddinArb.getString(426);
                this.m_progressBar.updateProgress(100, null, message);
            } else {
                this.m_progressBar.updateProgress(100, null, MigrationAddinArb.getString(206));
            }
        }
    }

    public Boolean getSuccess() {
        return this.m_success;
    }

    public void setSuccess(Boolean success) {
        this.m_success = success;
    }

    public void setScript(String script) {
        this.m_script = script;
    }

    public AbstractMigrationProgressRunnable getProgressBar() {
        return this.m_progressBar;
    }

    public void setProgressBar(AbstractMigrationProgressRunnable callRunScripts) {
        this.m_progressBar = callRunScripts;
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int modeIn) {
        this.m_mode = modeIn;
    }

    public void signalCancel() {
        this.runner.interrupt();
        this.m_cancelled = true;
        if (this.m_mode == 1 || this.m_mode == 2) {
            this.cleanupCreated();
        }
    }

    private void cleanupCreated() {
        Runnable r = new Runnable(){

            public void run() {
                URL topScript = this.getClass().getResource("nukeRepository.sql");
                RunRepositoryScripts.this.m_context = new ScriptRunnerContext();
                RunRepositoryScripts.this.m_context.setTopLevel(true);
                RunRepositoryScripts.this.m_context.setLastUrl(topScript);
                RunRepositoryScripts.this.m_context.setSqlError(5);
                RunRepositoryScripts.this.m_context.setOsError(5);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                BufferedOutputStream out = new BufferedOutputStream(bout);
                RunRepositoryScripts.this.runner = new ScriptRunner(topScript, RunRepositoryScripts.this.getConnection());
                RunRepositoryScripts.this.runner.setScriptRunnerContext(RunRepositoryScripts.this.m_context);
                RunRepositoryScripts.this.runner.run();
            }
        };
        r.run();
    }

    public boolean wasCancelled() {
        return this.m_cancelled;
    }

    public class MaskByteArrayOutputStream
    extends ByteArrayOutputStream {
        int m_bytesSoFar = 0;
        int m_lastEpoch = -1;
        int m_maxBytes = 20000;
        int m_chunks = 100;
        int m_message = 0;
        AbstractMigrationProgressRunnable m_callRunScripts;

        public void updateBytesSoFar(int i) {
            this.m_bytesSoFar += i;
            int stagePercent = this.m_bytesSoFar * 100 / this.m_maxBytes;
            if (stagePercent / (100 / this.m_chunks) != this.m_lastEpoch) {
                this.m_lastEpoch = stagePercent / (100 / this.m_chunks);
                int message = this.m_lastEpoch * (100 / this.m_chunks);
                if (message >= 99) {
                    message = 100;
                } else if (message < 0) {
                    message = 0;
                }
                String messageText = this.getNextMessageText(message);
                this.m_callRunScripts.updateProgress(message, null, messageText);
            }
        }

        String getNextMessageText(int message) {
            ++this.m_message;
            switch (this.m_message / (this.m_chunks / 5)) {
                case 0: {
                    return MigrationAddinArb.getString(211);
                }
                case 1: {
                    return MigrationAddinArb.getString(212);
                }
                case 2: {
                    return MigrationAddinArb.getString(213);
                }
                case 3: {
                    return MigrationAddinArb.getString(214);
                }
                case 4: {
                    return MigrationAddinArb.getString(215);
                }
            }
            return MigrationAddinArb.getString(215);
        }

        public void write(byte[] b, int off, int len) {
            this.updateBytesSoFar(len);
        }

        public void write(int b) {
            this.updateBytesSoFar(1);
        }

        public void write(byte[] b) {
            this.updateBytesSoFar(b.length);
        }

        public AbstractMigrationProgressRunnable getCallRunScripts() {
            return this.m_callRunScripts;
        }

        public void setCallRunScripts(AbstractMigrationProgressRunnable callRunScripts) {
            this.m_callRunScripts = callRunScripts;
        }
    }
}

