/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.createRepository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.createRepository.RunRepositoryScripts;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeRunner
extends AbstractMigrationProgressRunnable {
    private int m_currentRepoVsn;
    private int m_firstVsn;
    private int m_lastVsn;
    private ArrayList<String> m_scripts;
    private RunRepositoryScripts m_worker;
    private JPanel m_downPanel;
    private JLabel m_downLabel;
    private int m_softwareVsn;

    public UpgradeRunner(int currentRepoVersion, int softwareVsn, ArrayList<String> upgradeScripts, RunRepositoryScripts worker) {
        this.m_currentRepoVsn = currentRepoVersion;
        this.m_softwareVsn = softwareVsn;
        this.m_scripts = upgradeScripts;
        this.m_worker = worker;
        this.m_worker.setProgressBar(this);
        this.m_worker.setMode(3);
        this.setUseBuzyBar(true);
        this.setTitle(MigrationAddinArb.getString(60));
        this.m_downPanel = new JPanel();
        BorderLayout secondLayout = new BorderLayout();
        this.m_downPanel.setLayout(secondLayout);
        this.m_downLabel = new JLabel();
        this.m_downPanel.add((Component)this.m_downLabel, "West");
    }

    @Override
    protected Object doWork() throws Exception {
        String script;
        int tmpVsn = this.m_currentRepoVsn;
        boolean success = true;
        this.setVersionNumbers(this.m_scripts);
        while (tmpVsn < this.m_softwareVsn && (script = RepositoryManager.findNextUpgradeScript(tmpVsn, this.m_scripts)) != null) {
            this.m_worker.setScript(script);
            this.setMessage(this.getUpgradeMessage(script));
            this.m_worker.run();
            try {
                tmpVsn = RepositoryManager.getCurentRepoVersion(this.m_worker.getConnection());
            }
            catch (Exception e) {
                success = false;
                break;
            }
        }
        if (success) {
            this.setMessage(this.getFinalMessage());
        } else {
            this.setMessage(MigrationAddinArb.getString(425));
        }
        return this.m_worker.getSuccess();
    }

    private String getFinalMessage() {
        String message = MigrationAddinArb.getString(61) + " " + this.m_firstVsn + " " + this.m_lastVsn + MigrationAddinArb.getString(63);
        return message;
    }

    private void setVersionNumbers(ArrayList<String> scriptList) {
        this.m_firstVsn = this.m_currentRepoVsn;
        for (String filename : scriptList) {
            StringTokenizer st = new StringTokenizer(filename, "_");
            st.nextToken();
            String fromVsn = st.nextToken();
            String toVsn = st.nextToken();
            this.m_lastVsn = Integer.parseInt(toVsn);
        }
    }

    public void setScript(String script) {
        this.m_worker.setScript(script);
        this.setMessage(this.getUpgradeMessage(script));
    }

    private String getUpgradeMessage(String script) {
        StringTokenizer st = new StringTokenizer(script, "_");
        st.nextToken();
        String fromVsn = st.nextToken();
        String toVsn = st.nextToken();
        String message = MigrationAddinArb.getString(59) + " " + fromVsn + " " + MigrationAddinArb.getString(62) + " " + toVsn;
        return message;
    }

    @Override
    public void updateAbovePanel(Object object) {
    }

    public void setUpgradeScripts(ArrayList<String> files) {
        this.m_scripts = files;
    }

    @Override
    public JPanel getTopPanel() {
        return null;
    }

    @Override
    public JPanel getDownPanel() {
        return this.m_downPanel;
    }

    @Override
    public void updateBelowPanel(final Object message) {
        if (message instanceof String) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        UpgradeRunner.this.m_downLabel.setText((String)message);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

