/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobHelper {
    private Reader m_reader = null;
    private long m_length = 0L;

    public ClobHelper(String s) {
        if (s == null) {
            this.setReader(null);
            this.setLength(0L);
        } else {
            this.setReader(new StringReader(s));
            this.setLength(s.length());
        }
    }

    public ClobHelper(Clob clob) throws SQLException {
        if (clob == null) {
            this.setReader(null);
            this.setLength(0L);
            return;
        }
        this.setReader(clob.getCharacterStream());
        this.setLength(clob.length());
    }

    public ClobHelper(Reader reader, long length) {
        this.setReader(reader);
        this.setLength(length);
    }

    protected void setLength(long length) {
        this.m_length = length;
    }

    protected void setReader(Reader reader) {
        this.m_reader = reader;
    }

    public long getLength() {
        return this.m_length;
    }

    public Reader getReader() {
        return this.m_reader;
    }
}

