/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class ConstraintsIterator
extends PersistableObjectIterator {
    private static final String GET_CHECK_CONSTRAINTS_FOR_CONNECTIONID_QUERY = "SELECT ID FROM MD_CONSTRAINTS WHERE TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?) AND CONSTRAINT_TYPE = ?";
    private static final String GET_ALL_CONSTAINTS_QUERY = "SELECT ID FROM MD_CONSTRAINTS WHERE TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?)";
    private PreparedStatement m_myStatement;

    public ConstraintsIterator(PersistenceManager pman, DBObjectId connectionId, String constraintType, MigrationObjectFilterList filterList) throws PersistenceException {
        super(MdConstraint.class, pman);
        String whereClause = "";
        try {
            String sql;
            MigrationObjectFilter filter;
            if (filterList != null && (filter = filterList.getFilterForType(constraintType)) != null) {
                whereClause = filter.toWhereConditionForMigrationRepository();
                if (whereClause == null) {
                    throw new IllegalStateException("Error creating where condition");
                }
                if (whereClause.length() > 0) {
                    whereClause = whereClause + " AND " + whereClause;
                }
            }
            if (constraintType != null) {
                sql = GET_CHECK_CONSTRAINTS_FOR_CONNECTIONID_QUERY + whereClause;
                this.m_myStatement = pman.getPreparedStatement(sql);
                this.m_myStatement.setLong(1, connectionId.getId());
                this.m_myStatement.setString(2, constraintType);
            } else {
                sql = GET_ALL_CONSTAINTS_QUERY + whereClause;
                this.m_myStatement = pman.getPreparedStatement(sql);
                this.m_myStatement.setLong(1, connectionId.getId());
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    protected PreparedStatement getPreparedStatement() {
        return this.m_myStatement;
    }
}

