/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.TranslationContext;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;

public class DBObjectHierarchy {
    private MdConnection m_connection = null;
    private MdCatalog m_catalog = null;
    private MdSchema m_schema = null;
    private PersistableObject m_object = null;
    private PersistableObject m_part = null;
    private String m_objectType = null;
    private String m_partType = null;

    public DBObjectHierarchy(PersistableObject poObjOrPart, PersistenceManager pm) {
        this.init(poObjOrPart, pm);
    }

    private void init(PersistableObject poObjOrPart, PersistenceManager pm) {
        PersistenceUtility pu = PersistenceUtility.getInstance(pm);
        if (poObjOrPart == null) {
            return;
        }
        PersistableObject poObject = null;
        try {
            if (poObjOrPart.getObjectType().equals("MD_COLUMNS") || poObjOrPart.getObjectType().equals("MD_CONSTRAINTS") || poObjOrPart.getObjectType().equals("MD_TRIGGERS")) {
                this.setPart(poObjOrPart);
                this.setPartType(poObjOrPart.getObjectType());
                poObject = pu.loadParentPersistableObject(poObjOrPart);
            } else {
                poObject = poObjOrPart;
            }
            this.setObject(poObject);
            this.setObjectType(poObject.getObjectType());
            PersistableObject poSchema = pu.loadParentPersistableObject(poObject);
            this.setSchema((MdSchema)poSchema);
            PersistableObject poCatalog = pu.loadParentPersistableObject(poSchema);
            this.setCatalog((MdCatalog)poCatalog);
            PersistableObject poConnection = pu.loadParentPersistableObject(poCatalog);
            this.setConnection((MdConnection)poConnection);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public MdCatalog getCatalog() {
        return this.m_catalog;
    }

    public void setCatalog(MdCatalog catalog) {
        this.m_catalog = catalog;
    }

    public MdConnection getConnection() {
        return this.m_connection;
    }

    public void setConnection(MdConnection connection) {
        this.m_connection = connection;
    }

    public PersistableObject getObject() {
        return this.m_object;
    }

    public void setObject(PersistableObject object) {
        this.m_object = object;
    }

    public String getObjectType() {
        return this.m_objectType;
    }

    public void setObjectType(String objectType) {
        this.m_objectType = objectType;
    }

    public PersistableObject getPart() {
        return this.m_part;
    }

    public void setPart(PersistableObject part) {
        this.m_part = part;
    }

    public String getPartType() {
        return this.m_partType;
    }

    public void setPartType(String partType) {
        this.m_partType = partType;
    }

    public MdSchema getSchema() {
        return this.m_schema;
    }

    public void setSchema(MdSchema schema) {
        this.m_schema = schema;
    }

    public TranslationDBObjectReference getTranslationDBObjectReference() {
        TranslationObjectType objectType = TranslationContext.getRosettaObjectType(this.getPart() != null ? this.getPart() : this.getObject());
        String objectName = objectType.equals(TranslationObjectType.TRIGGER_TYPE) ? this.getPartName() : this.getObjectName();
        String partName = objectType.equals(TranslationObjectType.TRIGGER_TYPE) ? this.getObjectName() : this.getPartName();
        return new TranslationDBObjectReference(this.getConnection().getHost(), this.getCatalog().getCatalogName(), this.getSchema().getName(), objectName, partName, objectType, (Object)(this.getPart() != null ? this.getPart() : this.getObject()));
    }

    private String getObjectName() {
        if (this.getObjectType().equalsIgnoreCase("MD_TABLES")) {
            return ((MdTable)this.getObject()).getTableName();
        }
        if (this.getObjectType().equalsIgnoreCase("MD_STORED_PROGRAMS")) {
            return ((MdStoredProgram)this.getObject()).getName();
        }
        if (this.getObjectType().equalsIgnoreCase("MD_TRIGGERS")) {
            return ((MdTrigger)this.getObject()).getTriggerName();
        }
        if (this.getObjectType().equalsIgnoreCase("MD_VIEWS")) {
            return ((MdView)this.getObject()).getViewName();
        }
        return null;
    }

    private String getPartName() {
        if (this.getPart() == null) {
            return null;
        }
        if (this.getPartType().equalsIgnoreCase("MD_CONSTRAINTS")) {
            return ((MdConstraint)this.getPart()).getName();
        }
        if (this.getPartType().equalsIgnoreCase("MD_COLUMNS")) {
            return ((MdColumn)this.getPart()).getColumnName();
        }
        if (this.getPartType().equalsIgnoreCase("MD_TRIGGERS")) {
            return ((MdTrigger)this.getPart()).getTriggerName();
        }
        return null;
    }
}

