/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdDerivative;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class DerivativesIterator
extends PersistableObjectIterator {
    private static final String QUERY = "SELECT ID FROM MD_DERIVATIVES WHERE DERIVED_CONNECTION_ID_FK = ?";
    private DBObjectId m_connectionId;
    private String m_whereCondition;

    public DerivativesIterator(PersistenceManager pman, DBObjectId connectionId, String whereCondition) {
        super(MdDerivative.class, pman);
        this.m_connectionId = connectionId;
        this.m_whereCondition = whereCondition;
    }

    protected PreparedStatement getPreparedStatement() throws SQLException {
        String query = QUERY;
        if (this.m_whereCondition != null) {
            query = query + " AND " + this.m_whereCondition;
        }
        PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement(query);
        stmt.setLong(1, this.m_connectionId.getId());
        return stmt;
    }
}

