/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.Timestamp;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.DBObjectId;

public class Field {
    public static final String TYPE_LONG = "LONG";
    public static final String TYPE_STRING = "STRING";
    public static final String TYPE_INTEGER = "INTEGER";
    public static final String TYPE_CLOBHELPER = "CLOBHELPER";
    public static final String TYPE_DBOBJECTID = "DBOBJECTID";
    public static final String TYPE_TIMESTAMP = "TIMESTAMP";
    public static final String TYPE_DATE = "DATE";
    public static final String TYPE_READER = "READER";
    private String m_columnName;
    private String m_datatype;
    private boolean m_isNullable;
    private boolean m_updated;
    public Object m_value;

    public String getDatatype() {
        return this.m_datatype;
    }

    protected void setDatatype(String datatype) {
        this.m_datatype = datatype;
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    protected void setColumnName(String name) {
        this.m_columnName = name;
        this.setUpdated(true);
    }

    public boolean isUpdated() {
        return this.m_updated;
    }

    private void setUpdated(boolean updated) {
        this.m_updated = updated;
    }

    public Field(String name, String datatype) {
        this(name, datatype, true);
    }

    public Field(String name, String datatype, boolean isNullable) {
        this.setColumnName(name);
        this.setDatatype(datatype);
        this.setNullable(isNullable);
    }

    public Long getLong() {
        if (this.m_value == null) {
            return null;
        }
        if (this.m_value instanceof Long) {
            return (Long)this.m_value;
        }
        throw new IllegalStateException("Value is not a long");
    }

    public String getString() {
        if (this.m_value == null) {
            return null;
        }
        if (this.m_value instanceof String) {
            return (String)this.m_value;
        }
        throw new IllegalStateException("Value is not a string");
    }

    public Integer getInteger() {
        if (this.m_value == null) {
            return null;
        }
        if (this.m_value instanceof Integer) {
            return (Integer)this.m_value;
        }
        throw new IllegalStateException("Value is not an integer");
    }

    public DBObjectId getDBObjectId() {
        if (this.m_value == null) {
            return null;
        }
        if (this.m_value instanceof DBObjectId) {
            return (DBObjectId)this.m_value;
        }
        throw new IllegalStateException("Value is not a DBObjectId");
    }

    public ClobHelper getClobHelper() {
        if (this.m_value == null) {
            return null;
        }
        if (this.m_value instanceof ClobHelper) {
            return (ClobHelper)this.m_value;
        }
        throw new IllegalStateException("Value is not a Clob");
    }

    public Timestamp getTimestamp() {
        if (this.m_value == null) {
            return null;
        }
        if (this.m_value instanceof Timestamp) {
            return (Timestamp)this.m_value;
        }
        throw new IllegalStateException("Value is not a timestamp");
    }

    public Date getDate() {
        if (this.m_value == null) {
            return null;
        }
        if (this.m_value instanceof Date) {
            return (Date)this.m_value;
        }
        throw new IllegalStateException("Value is not a date");
    }

    public void setValue(Object value) {
        if (!this.isNullable() && value == null) {
            throw new IllegalStateException("Field is not nullable");
        }
        this.m_value = value;
    }

    public void clearUpdated() {
        this.m_updated = false;
    }

    public boolean isNullable() {
        return this.m_isNullable;
    }

    protected void setNullable(boolean isNullable) {
        this.m_isNullable = isNullable;
    }

    protected Object getValue() {
        return this.m_value;
    }

    public int getSQLType() {
        if (this.getDatatype().equals(TYPE_LONG)) {
            return 2;
        }
        if (this.getDatatype().equals(TYPE_STRING)) {
            return 12;
        }
        if (this.getDatatype().equals(TYPE_INTEGER)) {
            return 4;
        }
        if (this.getDatatype().equals(TYPE_DATE)) {
            return 91;
        }
        if (this.getDatatype().equals(TYPE_CLOBHELPER)) {
            return 2005;
        }
        if (this.getDatatype().equals(TYPE_DBOBJECTID)) {
            return 2;
        }
        throw new AssertionError((Object)("Unknown data type found :" + this.getDatatype()));
    }
}

