/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdAdditionalPropertie
extends PersistableObject {
    public static final String TABLE_NAME = "MD_ADDITIONAL_PROPERTIES";
    public static final String COLNAME_CONNECTION_ID_FK = "CONNECTION_ID_FK";
    public static final String COLNAME_REF_ID_FK = "REF_ID_FK";
    public static final String COLNAME_REF_TYPE = "REF_TYPE";
    public static final String COLNAME_PROPERTY_ORDER = "PROPERTY_ORDER";
    public static final String COLNAME_PROP_KEY = "PROP_KEY";
    public static final String COLNAME_VALUE = "VALUE";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MdAdditionalPropertie(DBObjectId connectionId, DBObjectId refId, String refType, String propKey) {
        this.setConnectionId(connectionId);
        this.setRefId(refId);
        this.setRefType(refType);
        this.setPropKey(propKey);
    }

    public static MdAdditionalPropertie getExistingInstance(DBObjectId key) {
        MdAdditionalPropertie ret = new MdAdditionalPropertie();
        ret.setKey(key);
        return ret;
    }

    private MdAdditionalPropertie() {
    }

    public static MdAdditionalPropertie retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdAdditionalPropertie ret = MdAdditionalPropertie.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setConnectionId(DBObjectId connectionId) {
        Field f = new Field(COLNAME_CONNECTION_ID_FK, "DBOBJECTID", false);
        f.setValue(connectionId);
        this.setField(f);
    }

    protected void setRefId(DBObjectId refId) {
        Field f = new Field(COLNAME_REF_ID_FK, "DBOBJECTID", false);
        f.setValue(refId);
        this.setField(f);
    }

    protected void setRefType(String refType) {
        Field f = new Field(COLNAME_REF_TYPE, "STRING", false);
        f.setValue(refType);
        this.setField(f);
    }

    public void setPropertyOrder(Integer propertyOrder) {
        Field f = new Field(COLNAME_PROPERTY_ORDER, "INTEGER");
        f.setValue(propertyOrder);
        this.setField(f);
    }

    protected void setPropKey(String propKey) {
        Field f = new Field(COLNAME_PROP_KEY, "STRING", false);
        f.setValue(propKey);
        this.setField(f);
    }

    public void setValue(String value) {
        Field f = new Field(COLNAME_VALUE, "STRING");
        f.setValue(value);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public DBObjectId getConnectionId() {
        Field f = this.getField(COLNAME_CONNECTION_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public DBObjectId getRefId() {
        Field f = this.getField(COLNAME_REF_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getRefType() {
        Field f = this.getField(COLNAME_REF_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Integer getPropertyOrder() {
        Field f = this.getField(COLNAME_PROPERTY_ORDER);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public String getPropKey() {
        Field f = this.getField(COLNAME_PROP_KEY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getValue() {
        Field f = this.getField(COLNAME_VALUE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            this.setConnectionId(new DBObjectId(rs.getLong(COLNAME_CONNECTION_ID_FK)));
            this.setRefId(new DBObjectId(rs.getLong(COLNAME_REF_ID_FK)));
            this.setRefType(rs.getString(COLNAME_REF_TYPE));
            Object o = rs.getInt(COLNAME_PROPERTY_ORDER);
            if (rs.wasNull()) {
                this.setPropertyOrder(null);
            } else {
                this.setPropertyOrder((Integer)o);
            }
            this.setPropKey(rs.getString(COLNAME_PROP_KEY));
            o = rs.getString(COLNAME_VALUE);
            if (rs.wasNull()) {
                this.setValue(null);
            } else {
                this.setValue((String)o);
            }
            o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    public String getContainerFieldName() {
        return COLNAME_CONNECTION_ID_FK;
    }

    public DBObjectId getContainerId() {
        return this.getConnectionId();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

