/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdCatalog
extends PersistableObject {
    public static final String TABLE_NAME = "MD_CATALOGS";
    public static final String COLNAME_CONNECTION_ID_FK = "CONNECTION_ID_FK";
    public static final String COLNAME_CATALOG_NAME = "CATALOG_NAME";
    public static final String COLNAME_DUMMY_FLAG = "DUMMY_FLAG";
    public static final String COLNAME_NATIVE_SQL = "NATIVE_SQL";
    public static final String COLNAME_NATIVE_KEY = "NATIVE_KEY";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdCatalog(DBObjectId connectionId) {
        this.setConnectionId(connectionId);
    }

    public static MdCatalog getExistingInstance(DBObjectId key) {
        MdCatalog ret = new MdCatalog();
        ret.setKey(key);
        return ret;
    }

    private MdCatalog() {
    }

    public static MdCatalog retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdCatalog ret = MdCatalog.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setConnectionId(DBObjectId connectionId) {
        Field f = new Field(COLNAME_CONNECTION_ID_FK, "DBOBJECTID", false);
        f.setValue(connectionId);
        this.setField(f);
    }

    public void setCatalogName(String catalogName) {
        Field f = new Field(COLNAME_CATALOG_NAME, "STRING");
        f.setValue(catalogName);
        this.setField(f);
    }

    public void setDummyFlag(String dummyFlag) {
        Field f = new Field(COLNAME_DUMMY_FLAG, "STRING");
        f.setValue(dummyFlag);
        this.setField(f);
    }

    public void setNativeSql(String snativeSql) {
        Field f = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(snativeSql);
        f.setValue(clobHelper);
        this.setField(f);
    }

    public void setNativeSql(ClobHelper clobHelper) {
        Field f = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        f.setValue(clobHelper);
        this.setField(f);
    }

    public void setNativeKey(String nativeKey) {
        Field f = new Field(COLNAME_NATIVE_KEY, "STRING");
        f.setValue(nativeKey);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public void setComments(String comments) {
        Field f = new Field(COLNAME_COMMENTS, "STRING");
        f.setValue(comments);
        this.setField(f);
    }

    public DBObjectId getConnectionId() {
        Field f = this.getField(COLNAME_CONNECTION_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getCatalogName() {
        Field f = this.getField(COLNAME_CATALOG_NAME);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getDummyFlag() {
        Field f = this.getField(COLNAME_DUMMY_FLAG);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public ClobHelper getNativeSql() {
        Field f = this.getField(COLNAME_NATIVE_SQL);
        if (f == null) {
            return null;
        }
        return f.getClobHelper();
    }

    public String getNativeKey() {
        Field f = this.getField(COLNAME_NATIVE_KEY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getComments() {
        Field f = this.getField(COLNAME_COMMENTS);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            this.setConnectionId(new DBObjectId(rs.getLong(COLNAME_CONNECTION_ID_FK)));
            Object o = rs.getString(COLNAME_CATALOG_NAME);
            if (rs.wasNull()) {
                this.setCatalogName(null);
            } else {
                this.setCatalogName((String)o);
            }
            o = rs.getString(COLNAME_DUMMY_FLAG);
            if (rs.wasNull()) {
                this.setDummyFlag(null);
            } else {
                this.setDummyFlag((String)o);
            }
            o = new ClobHelper(rs.getClob(COLNAME_NATIVE_SQL));
            if (rs.wasNull()) {
                this.setNativeSql((ClobHelper)null);
            } else {
                this.setNativeSql((ClobHelper)o);
            }
            o = rs.getString(COLNAME_NATIVE_KEY);
            if (rs.wasNull()) {
                this.setNativeKey(null);
            } else {
                this.setNativeKey((String)o);
            }
            o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
            o = rs.getString(COLNAME_COMMENTS);
            if (rs.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    public String getObjectName() {
        return this.getCatalogName();
    }

    public String getObjectNameFieldName() {
        return COLNAME_CATALOG_NAME;
    }

    public void rename(String newName) {
        this.setCatalogName(newName);
    }

    public String getContainerFieldName() {
        return COLNAME_CONNECTION_ID_FK;
    }

    public DBObjectId getContainerId() {
        return this.getConnectionId();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

