/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdColumn
extends PersistableObject {
    public static final String TABLE_NAME = "MD_COLUMNS";
    public static final String COLNAME_TABLE_ID_FK = "TABLE_ID_FK";
    public static final String COLNAME_COLUMN_NAME = "COLUMN_NAME";
    public static final String COLNAME_COLUMN_ORDER = "COLUMN_ORDER";
    public static final String COLNAME_COLUMN_TYPE = "COLUMN_TYPE";
    public static final String COLNAME_PRECISION = "PRECISION";
    public static final String COLNAME_SCALE = "SCALE";
    public static final String COLNAME_NULLABLE = "NULLABLE";
    public static final String COLNAME_DEFAULT_VALUE = "DEFAULT_VALUE";
    public static final String COLNAME_NATIVE_SQL = "NATIVE_SQL";
    public static final String COLNAME_NATIVE_KEY = "NATIVE_KEY";
    public static final String COLNAME_DATATYPE_TRANSFORMED_FLAG = "DATATYPE_TRANSFORMED_FLAG";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdColumn(DBObjectId tableId, String columnName, Integer columnOrder) {
        this.setTableId(tableId);
        this.setColumnName(columnName);
        this.setColumnOrder(columnOrder);
    }

    public static MdColumn getExistingInstance(DBObjectId key) {
        MdColumn ret = new MdColumn();
        ret.setKey(key);
        return ret;
    }

    private MdColumn() {
    }

    public static MdColumn retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdColumn ret = MdColumn.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setTableId(DBObjectId tableId) {
        Field f = new Field(COLNAME_TABLE_ID_FK, "DBOBJECTID", false);
        f.setValue(tableId);
        this.setField(f);
    }

    protected void setColumnName(String columnName) {
        Field f = new Field(COLNAME_COLUMN_NAME, "STRING", false);
        f.setValue(columnName);
        this.setField(f);
    }

    protected void setColumnOrder(Integer columnOrder) {
        Field f = new Field(COLNAME_COLUMN_ORDER, "INTEGER", false);
        f.setValue(columnOrder);
        this.setField(f);
    }

    public void setColumnType(String columnType) {
        Field f = new Field(COLNAME_COLUMN_TYPE, "STRING");
        f.setValue(columnType);
        this.setField(f);
    }

    public void setPrecision(Integer precision) {
        Field f = new Field(COLNAME_PRECISION, "INTEGER");
        f.setValue(precision);
        this.setField(f);
    }

    public void setScale(Integer scale) {
        Field f = new Field(COLNAME_SCALE, "INTEGER");
        f.setValue(scale);
        this.setField(f);
    }

    public void setNullable(String nullable) {
        Field f = new Field(COLNAME_NULLABLE, "STRING");
        f.setValue(nullable);
        this.setField(f);
    }

    public void setDefaultValue(String defaultValue) {
        Field f = new Field(COLNAME_DEFAULT_VALUE, "STRING");
        f.setValue(defaultValue);
        this.setField(f);
    }

    public void setNativeSql(String snativeSql) {
        Field f = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(snativeSql);
        f.setValue(clobHelper);
        this.setField(f);
    }

    public void setNativeSql(ClobHelper clobHelper) {
        Field f = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        f.setValue(clobHelper);
        this.setField(f);
    }

    public void setNativeKey(String nativeKey) {
        Field f = new Field(COLNAME_NATIVE_KEY, "STRING");
        f.setValue(nativeKey);
        this.setField(f);
    }

    public void setDatatypeTransformedFlag(String datatypeTransformedFlag) {
        Field f = new Field(COLNAME_DATATYPE_TRANSFORMED_FLAG, "STRING");
        f.setValue(datatypeTransformedFlag);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setComments(String comments) {
        Field f = new Field(COLNAME_COMMENTS, "STRING");
        f.setValue(comments);
        this.setField(f);
    }

    public DBObjectId getTableId() {
        Field f = this.getField(COLNAME_TABLE_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getColumnName() {
        Field f = this.getField(COLNAME_COLUMN_NAME);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Integer getColumnOrder() {
        Field f = this.getField(COLNAME_COLUMN_ORDER);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public String getColumnType() {
        Field f = this.getField(COLNAME_COLUMN_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Integer getPrecision() {
        Field f = this.getField(COLNAME_PRECISION);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getScale() {
        Field f = this.getField(COLNAME_SCALE);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public String getNullable() {
        Field f = this.getField(COLNAME_NULLABLE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getDefaultValue() {
        Field f = this.getField(COLNAME_DEFAULT_VALUE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public ClobHelper getNativeSql() {
        Field f = this.getField(COLNAME_NATIVE_SQL);
        if (f == null) {
            return null;
        }
        return f.getClobHelper();
    }

    public String getNativeKey() {
        Field f = this.getField(COLNAME_NATIVE_KEY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getDatatypeTransformedFlag() {
        Field f = this.getField(COLNAME_DATATYPE_TRANSFORMED_FLAG);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getComments() {
        Field f = this.getField(COLNAME_COMMENTS);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            this.setTableId(new DBObjectId(rs.getLong(COLNAME_TABLE_ID_FK)));
            this.setColumnName(rs.getString(COLNAME_COLUMN_NAME));
            this.setColumnOrder(rs.getInt(COLNAME_COLUMN_ORDER));
            Object o = rs.getString(COLNAME_COLUMN_TYPE);
            if (rs.wasNull()) {
                this.setColumnType(null);
            } else {
                this.setColumnType((String)o);
            }
            o = rs.getInt(COLNAME_PRECISION);
            if (rs.wasNull()) {
                this.setPrecision(null);
            } else {
                this.setPrecision((Integer)o);
            }
            o = rs.getInt(COLNAME_SCALE);
            if (rs.wasNull()) {
                this.setScale(null);
            } else {
                this.setScale((Integer)o);
            }
            o = rs.getString(COLNAME_NULLABLE);
            if (rs.wasNull()) {
                this.setNullable(null);
            } else {
                this.setNullable((String)o);
            }
            o = rs.getString(COLNAME_DEFAULT_VALUE);
            if (rs.wasNull()) {
                this.setDefaultValue(null);
            } else {
                this.setDefaultValue((String)o);
            }
            o = new ClobHelper(rs.getClob(COLNAME_NATIVE_SQL));
            if (rs.wasNull()) {
                this.setNativeSql((ClobHelper)null);
            } else {
                this.setNativeSql((ClobHelper)o);
            }
            o = rs.getString(COLNAME_NATIVE_KEY);
            if (rs.wasNull()) {
                this.setNativeKey(null);
            } else {
                this.setNativeKey((String)o);
            }
            o = rs.getString(COLNAME_DATATYPE_TRANSFORMED_FLAG);
            if (rs.wasNull()) {
                this.setDatatypeTransformedFlag(null);
            } else {
                this.setDatatypeTransformedFlag((String)o);
            }
            o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_COMMENTS);
            if (rs.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    public String getObjectName() {
        return this.getColumnName();
    }

    public String getObjectNameFieldName() {
        return COLNAME_COLUMN_NAME;
    }

    public void rename(String newName) {
        this.setColumnName(newName);
    }

    public String getContainerFieldName() {
        return COLNAME_TABLE_ID_FK;
    }

    public DBObjectId getContainerId() {
        return this.getTableId();
    }

    public boolean getNullableFlag() {
        return this.getNullable().equalsIgnoreCase("Y");
    }

    public String getUnit() {
        if (this.getColumnType().equals("VARCHAR2") || this.getColumnType().equals("CHAR")) {
            return "CHAR";
        }
        return null;
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

