/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdConnection
extends PersistableObject {
    public static final String TABLE_NAME = "MD_CONNECTIONS";
    public static final String COLNAME_PROJECT_ID_FK = "PROJECT_ID_FK";
    public static final String COLNAME_TYPE = "TYPE";
    public static final String COLNAME_HOST = "HOST";
    public static final String COLNAME_PORT = "PORT";
    public static final String COLNAME_USERNAME = "USERNAME";
    public static final String COLNAME_PASSWORD = "PASSWORD";
    public static final String COLNAME_DBURL = "DBURL";
    public static final String COLNAME_NAME = "NAME";
    public static final String COLNAME_NATIVE_SQL = "NATIVE_SQL";
    public static final String COLNAME_NUM_CATALOGS = "NUM_CATALOGS";
    public static final String COLNAME_NUM_COLUMNS = "NUM_COLUMNS";
    public static final String COLNAME_NUM_CONSTRAINTS = "NUM_CONSTRAINTS";
    public static final String COLNAME_NUM_GROUPS = "NUM_GROUPS";
    public static final String COLNAME_NUM_ROLES = "NUM_ROLES";
    public static final String COLNAME_NUM_INDEXES = "NUM_INDEXES";
    public static final String COLNAME_NUM_OTHER_OBJECTS = "NUM_OTHER_OBJECTS";
    public static final String COLNAME_NUM_PACKAGES = "NUM_PACKAGES";
    public static final String COLNAME_NUM_PRIVILEGES = "NUM_PRIVILEGES";
    public static final String COLNAME_NUM_SCHEMAS = "NUM_SCHEMAS";
    public static final String COLNAME_NUM_SEQUENCES = "NUM_SEQUENCES";
    public static final String COLNAME_NUM_STORED_PROGRAMS = "NUM_STORED_PROGRAMS";
    public static final String COLNAME_NUM_SYNONYMS = "NUM_SYNONYMS";
    public static final String COLNAME_NUM_TABLES = "NUM_TABLES";
    public static final String COLNAME_NUM_TABLESPACES = "NUM_TABLESPACES";
    public static final String COLNAME_NUM_TRIGGERS = "NUM_TRIGGERS";
    public static final String COLNAME_NUM_USER_DEFINED_DATA_TYPES = "NUM_USER_DEFINED_DATA_TYPES";
    public static final String COLNAME_NUM_USERS = "NUM_USERS";
    public static final String COLNAME_NUM_VIEWS = "NUM_VIEWS";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdConnection(DBObjectId projectId) {
        this.setProjectId(projectId);
    }

    public static MdConnection getExistingInstance(DBObjectId key) {
        MdConnection ret = new MdConnection();
        ret.setKey(key);
        return ret;
    }

    private MdConnection() {
    }

    public static MdConnection retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdConnection ret = MdConnection.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setProjectId(DBObjectId projectId) {
        Field f = new Field(COLNAME_PROJECT_ID_FK, "DBOBJECTID", false);
        f.setValue(projectId);
        this.setField(f);
    }

    public void setType(String type) {
        Field f = new Field(COLNAME_TYPE, "STRING");
        f.setValue(type);
        this.setField(f);
    }

    public void setHost(String host) {
        Field f = new Field(COLNAME_HOST, "STRING");
        f.setValue(host);
        this.setField(f);
    }

    public void setPort(Integer port) {
        Field f = new Field(COLNAME_PORT, "INTEGER");
        f.setValue(port);
        this.setField(f);
    }

    public void setUsername(String username) {
        Field f = new Field(COLNAME_USERNAME, "STRING");
        f.setValue(username);
        this.setField(f);
    }

    public void setPassword(String password) {
        Field f = new Field(COLNAME_PASSWORD, "STRING");
        f.setValue(password);
        this.setField(f);
    }

    public void setDburl(String dburl) {
        Field f = new Field(COLNAME_DBURL, "STRING");
        f.setValue(dburl);
        this.setField(f);
    }

    public void setName(String name) {
        Field f = new Field(COLNAME_NAME, "STRING");
        f.setValue(name);
        this.setField(f);
    }

    public void setNativeSql(String snativeSql) {
        Field f = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(snativeSql);
        f.setValue(clobHelper);
        this.setField(f);
    }

    public void setNativeSql(ClobHelper clobHelper) {
        Field f = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        f.setValue(clobHelper);
        this.setField(f);
    }

    public void setNumCatalogs(Integer numCatalogs) {
        Field f = new Field(COLNAME_NUM_CATALOGS, "INTEGER");
        f.setValue(numCatalogs);
        this.setField(f);
    }

    public void setNumColumns(Integer numColumns) {
        Field f = new Field(COLNAME_NUM_COLUMNS, "INTEGER");
        f.setValue(numColumns);
        this.setField(f);
    }

    public void setNumConstraints(Integer numConstraints) {
        Field f = new Field(COLNAME_NUM_CONSTRAINTS, "INTEGER");
        f.setValue(numConstraints);
        this.setField(f);
    }

    public void setNumGroups(Integer numGroups) {
        Field f = new Field(COLNAME_NUM_GROUPS, "INTEGER");
        f.setValue(numGroups);
        this.setField(f);
    }

    public void setNumRoles(Integer numRoles) {
        Field f = new Field(COLNAME_NUM_ROLES, "INTEGER");
        f.setValue(numRoles);
        this.setField(f);
    }

    public void setNumIndexes(Integer numIndexes) {
        Field f = new Field(COLNAME_NUM_INDEXES, "INTEGER");
        f.setValue(numIndexes);
        this.setField(f);
    }

    public void setNumOtherObjects(Integer numOtherObjects) {
        Field f = new Field(COLNAME_NUM_OTHER_OBJECTS, "INTEGER");
        f.setValue(numOtherObjects);
        this.setField(f);
    }

    public void setNumPackages(Integer numPackages) {
        Field f = new Field(COLNAME_NUM_PACKAGES, "INTEGER");
        f.setValue(numPackages);
        this.setField(f);
    }

    public void setNumPrivileges(Integer numPrivileges) {
        Field f = new Field(COLNAME_NUM_PRIVILEGES, "INTEGER");
        f.setValue(numPrivileges);
        this.setField(f);
    }

    public void setNumSchemas(Integer numSchemas) {
        Field f = new Field(COLNAME_NUM_SCHEMAS, "INTEGER");
        f.setValue(numSchemas);
        this.setField(f);
    }

    public void setNumSequences(Integer numSequences) {
        Field f = new Field(COLNAME_NUM_SEQUENCES, "INTEGER");
        f.setValue(numSequences);
        this.setField(f);
    }

    public void setNumStoredPrograms(Integer numStoredPrograms) {
        Field f = new Field(COLNAME_NUM_STORED_PROGRAMS, "INTEGER");
        f.setValue(numStoredPrograms);
        this.setField(f);
    }

    public void setNumSynonyms(Integer numSynonyms) {
        Field f = new Field(COLNAME_NUM_SYNONYMS, "INTEGER");
        f.setValue(numSynonyms);
        this.setField(f);
    }

    public void setNumTables(Integer numTables) {
        Field f = new Field(COLNAME_NUM_TABLES, "INTEGER");
        f.setValue(numTables);
        this.setField(f);
    }

    public void setNumTablespaces(Integer numTablespaces) {
        Field f = new Field(COLNAME_NUM_TABLESPACES, "INTEGER");
        f.setValue(numTablespaces);
        this.setField(f);
    }

    public void setNumTriggers(Integer numTriggers) {
        Field f = new Field(COLNAME_NUM_TRIGGERS, "INTEGER");
        f.setValue(numTriggers);
        this.setField(f);
    }

    public void setNumUserDefinedDataTypes(Integer numUserDefinedDataTypes) {
        Field f = new Field(COLNAME_NUM_USER_DEFINED_DATA_TYPES, "INTEGER");
        f.setValue(numUserDefinedDataTypes);
        this.setField(f);
    }

    public void setNumUsers(Integer numUsers) {
        Field f = new Field(COLNAME_NUM_USERS, "INTEGER");
        f.setValue(numUsers);
        this.setField(f);
    }

    public void setNumViews(Integer numViews) {
        Field f = new Field(COLNAME_NUM_VIEWS, "INTEGER");
        f.setValue(numViews);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public void setComments(String comments) {
        Field f = new Field(COLNAME_COMMENTS, "STRING");
        f.setValue(comments);
        this.setField(f);
    }

    public DBObjectId getProjectId() {
        Field f = this.getField(COLNAME_PROJECT_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getType() {
        Field f = this.getField(COLNAME_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getHost() {
        Field f = this.getField(COLNAME_HOST);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Integer getPort() {
        Field f = this.getField(COLNAME_PORT);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public String getUsername() {
        Field f = this.getField(COLNAME_USERNAME);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getPassword() {
        Field f = this.getField(COLNAME_PASSWORD);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getDburl() {
        Field f = this.getField(COLNAME_DBURL);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getName() {
        Field f = this.getField(COLNAME_NAME);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public ClobHelper getNativeSql() {
        Field f = this.getField(COLNAME_NATIVE_SQL);
        if (f == null) {
            return null;
        }
        return f.getClobHelper();
    }

    public Integer getNumCatalogs() {
        Field f = this.getField(COLNAME_NUM_CATALOGS);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumColumns() {
        Field f = this.getField(COLNAME_NUM_COLUMNS);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumConstraints() {
        Field f = this.getField(COLNAME_NUM_CONSTRAINTS);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumGroups() {
        Field f = this.getField(COLNAME_NUM_GROUPS);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumRoles() {
        Field f = this.getField(COLNAME_NUM_ROLES);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumIndexes() {
        Field f = this.getField(COLNAME_NUM_INDEXES);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumOtherObjects() {
        Field f = this.getField(COLNAME_NUM_OTHER_OBJECTS);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumPackages() {
        Field f = this.getField(COLNAME_NUM_PACKAGES);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumPrivileges() {
        Field f = this.getField(COLNAME_NUM_PRIVILEGES);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumSchemas() {
        Field f = this.getField(COLNAME_NUM_SCHEMAS);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumSequences() {
        Field f = this.getField(COLNAME_NUM_SEQUENCES);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumStoredPrograms() {
        Field f = this.getField(COLNAME_NUM_STORED_PROGRAMS);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumSynonyms() {
        Field f = this.getField(COLNAME_NUM_SYNONYMS);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumTables() {
        Field f = this.getField(COLNAME_NUM_TABLES);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumTablespaces() {
        Field f = this.getField(COLNAME_NUM_TABLESPACES);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumTriggers() {
        Field f = this.getField(COLNAME_NUM_TRIGGERS);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumUserDefinedDataTypes() {
        Field f = this.getField(COLNAME_NUM_USER_DEFINED_DATA_TYPES);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumUsers() {
        Field f = this.getField(COLNAME_NUM_USERS);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getNumViews() {
        Field f = this.getField(COLNAME_NUM_VIEWS);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getComments() {
        Field f = this.getField(COLNAME_COMMENTS);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            this.setProjectId(new DBObjectId(rs.getLong(COLNAME_PROJECT_ID_FK)));
            Object o = rs.getString(COLNAME_TYPE);
            if (rs.wasNull()) {
                this.setType(null);
            } else {
                this.setType((String)o);
            }
            o = rs.getString(COLNAME_HOST);
            if (rs.wasNull()) {
                this.setHost(null);
            } else {
                this.setHost((String)o);
            }
            o = rs.getInt(COLNAME_PORT);
            if (rs.wasNull()) {
                this.setPort(null);
            } else {
                this.setPort((Integer)o);
            }
            o = rs.getString(COLNAME_USERNAME);
            if (rs.wasNull()) {
                this.setUsername(null);
            } else {
                this.setUsername((String)o);
            }
            o = rs.getString(COLNAME_PASSWORD);
            if (rs.wasNull()) {
                this.setPassword(null);
            } else {
                this.setPassword((String)o);
            }
            o = rs.getString(COLNAME_DBURL);
            if (rs.wasNull()) {
                this.setDburl(null);
            } else {
                this.setDburl((String)o);
            }
            o = rs.getString(COLNAME_NAME);
            if (rs.wasNull()) {
                this.setName(null);
            } else {
                this.setName((String)o);
            }
            o = new ClobHelper(rs.getClob(COLNAME_NATIVE_SQL));
            if (rs.wasNull()) {
                this.setNativeSql((ClobHelper)null);
            } else {
                this.setNativeSql((ClobHelper)o);
            }
            o = rs.getInt(COLNAME_NUM_CATALOGS);
            if (rs.wasNull()) {
                this.setNumCatalogs(null);
            } else {
                this.setNumCatalogs((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_COLUMNS);
            if (rs.wasNull()) {
                this.setNumColumns(null);
            } else {
                this.setNumColumns((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_CONSTRAINTS);
            if (rs.wasNull()) {
                this.setNumConstraints(null);
            } else {
                this.setNumConstraints((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_GROUPS);
            if (rs.wasNull()) {
                this.setNumGroups(null);
            } else {
                this.setNumGroups((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_ROLES);
            if (rs.wasNull()) {
                this.setNumRoles(null);
            } else {
                this.setNumRoles((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_INDEXES);
            if (rs.wasNull()) {
                this.setNumIndexes(null);
            } else {
                this.setNumIndexes((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_OTHER_OBJECTS);
            if (rs.wasNull()) {
                this.setNumOtherObjects(null);
            } else {
                this.setNumOtherObjects((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_PACKAGES);
            if (rs.wasNull()) {
                this.setNumPackages(null);
            } else {
                this.setNumPackages((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_PRIVILEGES);
            if (rs.wasNull()) {
                this.setNumPrivileges(null);
            } else {
                this.setNumPrivileges((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_SCHEMAS);
            if (rs.wasNull()) {
                this.setNumSchemas(null);
            } else {
                this.setNumSchemas((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_SEQUENCES);
            if (rs.wasNull()) {
                this.setNumSequences(null);
            } else {
                this.setNumSequences((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_STORED_PROGRAMS);
            if (rs.wasNull()) {
                this.setNumStoredPrograms(null);
            } else {
                this.setNumStoredPrograms((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_SYNONYMS);
            if (rs.wasNull()) {
                this.setNumSynonyms(null);
            } else {
                this.setNumSynonyms((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_TABLES);
            if (rs.wasNull()) {
                this.setNumTables(null);
            } else {
                this.setNumTables((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_TABLESPACES);
            if (rs.wasNull()) {
                this.setNumTablespaces(null);
            } else {
                this.setNumTablespaces((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_TRIGGERS);
            if (rs.wasNull()) {
                this.setNumTriggers(null);
            } else {
                this.setNumTriggers((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_USER_DEFINED_DATA_TYPES);
            if (rs.wasNull()) {
                this.setNumUserDefinedDataTypes(null);
            } else {
                this.setNumUserDefinedDataTypes((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_USERS);
            if (rs.wasNull()) {
                this.setNumUsers(null);
            } else {
                this.setNumUsers((Integer)o);
            }
            o = rs.getInt(COLNAME_NUM_VIEWS);
            if (rs.wasNull()) {
                this.setNumViews(null);
            } else {
                this.setNumViews((Integer)o);
            }
            o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
            o = rs.getString(COLNAME_COMMENTS);
            if (rs.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    public String getObjectName() {
        return this.getName();
    }

    public String getObjectNameFieldName() {
        return COLNAME_NAME;
    }

    public void rename(String newName) {
        this.setName(newName);
    }

    public String getContainerFieldName() {
        return COLNAME_PROJECT_ID_FK;
    }

    public DBObjectId getContainerId() {
        return this.getProjectId();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

