/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdConstraint
extends PersistableObject {
    public static final String TABLE_NAME = "MD_CONSTRAINTS";
    public static final String COLNAME_DELETE_CLAUSE = "DELETE_CLAUSE";
    public static final String COLNAME_NAME = "NAME";
    public static final String COLNAME_CONSTRAINT_TYPE = "CONSTRAINT_TYPE";
    public static final String COLNAME_TABLE_ID_FK = "TABLE_ID_FK";
    public static final String COLNAME_REFTABLE_ID_FK = "REFTABLE_ID_FK";
    public static final String COLNAME_CONSTRAINT_TEXT = "CONSTRAINT_TEXT";
    public static final String COLNAME_LANGUAGE = "LANGUAGE";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdConstraint(DBObjectId tableId, String language) {
        this.setTableId(tableId);
        this.setLanguage(language);
    }

    public static MdConstraint getExistingInstance(DBObjectId key) {
        MdConstraint ret = new MdConstraint();
        ret.setKey(key);
        return ret;
    }

    private MdConstraint() {
    }

    public static MdConstraint retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdConstraint ret = MdConstraint.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    public void setDeleteClause(String deleteClause) {
        Field f = new Field(COLNAME_DELETE_CLAUSE, "STRING");
        f.setValue(deleteClause);
        this.setField(f);
    }

    public void setName(String name) {
        Field f = new Field(COLNAME_NAME, "STRING");
        f.setValue(name);
        this.setField(f);
    }

    public void setConstraintType(String constraintType) {
        Field f = new Field(COLNAME_CONSTRAINT_TYPE, "STRING");
        f.setValue(constraintType);
        this.setField(f);
    }

    protected void setTableId(DBObjectId tableId) {
        Field f = new Field(COLNAME_TABLE_ID_FK, "DBOBJECTID", false);
        f.setValue(tableId);
        this.setField(f);
    }

    public void setReftableId(DBObjectId reftableId) {
        Field f = new Field(COLNAME_REFTABLE_ID_FK, "DBOBJECTID");
        f.setValue(reftableId);
        this.setField(f);
    }

    public void setConstraintText(String sconstraintText) {
        Field f = new Field(COLNAME_CONSTRAINT_TEXT, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(sconstraintText);
        f.setValue(clobHelper);
        this.setField(f);
    }

    public void setConstraintText(ClobHelper clobHelper) {
        Field f = new Field(COLNAME_CONSTRAINT_TEXT, "CLOBHELPER");
        f.setValue(clobHelper);
        this.setField(f);
    }

    public void setLanguage(String language) {
        Field f = new Field(COLNAME_LANGUAGE, "STRING", false);
        f.setValue(language);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public void setComments(String comments) {
        Field f = new Field(COLNAME_COMMENTS, "STRING");
        f.setValue(comments);
        this.setField(f);
    }

    public String getDeleteClause() {
        Field f = this.getField(COLNAME_DELETE_CLAUSE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getName() {
        Field f = this.getField(COLNAME_NAME);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getConstraintType() {
        Field f = this.getField(COLNAME_CONSTRAINT_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getTableId() {
        Field f = this.getField(COLNAME_TABLE_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public DBObjectId getReftableId() {
        Field f = this.getField(COLNAME_REFTABLE_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public ClobHelper getConstraintText() {
        Field f = this.getField(COLNAME_CONSTRAINT_TEXT);
        if (f == null) {
            return null;
        }
        return f.getClobHelper();
    }

    public String getLanguage() {
        Field f = this.getField(COLNAME_LANGUAGE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getComments() {
        Field f = this.getField(COLNAME_COMMENTS);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            Object o = rs.getString(COLNAME_DELETE_CLAUSE);
            if (rs.wasNull()) {
                this.setDeleteClause(null);
            } else {
                this.setDeleteClause((String)o);
            }
            o = rs.getString(COLNAME_NAME);
            if (rs.wasNull()) {
                this.setName(null);
            } else {
                this.setName((String)o);
            }
            o = rs.getString(COLNAME_CONSTRAINT_TYPE);
            if (rs.wasNull()) {
                this.setConstraintType(null);
            } else {
                this.setConstraintType((String)o);
            }
            this.setTableId(new DBObjectId(rs.getLong(COLNAME_TABLE_ID_FK)));
            o = new DBObjectId(rs.getLong(COLNAME_REFTABLE_ID_FK));
            if (rs.wasNull()) {
                this.setReftableId(null);
            } else {
                this.setReftableId((DBObjectId)o);
            }
            o = new ClobHelper(rs.getClob(COLNAME_CONSTRAINT_TEXT));
            if (rs.wasNull()) {
                this.setConstraintText((ClobHelper)null);
            } else {
                this.setConstraintText((ClobHelper)o);
            }
            this.setLanguage(rs.getString(COLNAME_LANGUAGE));
            o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
            o = rs.getString(COLNAME_COMMENTS);
            if (rs.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    public String getObjectName() {
        return this.getName();
    }

    public String getObjectNameFieldName() {
        return COLNAME_NAME;
    }

    public void rename(String newName) {
        this.setName(newName);
    }

    public String getContainerFieldName() {
        return COLNAME_TABLE_ID_FK;
    }

    public DBObjectId getContainerId() {
        return this.getTableId();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

