/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdConstraintDetail
extends PersistableObject {
    public static final String TABLE_NAME = "MD_CONSTRAINT_DETAILS";
    public static final String COLNAME_REF_FLAG = "REF_FLAG";
    public static final String COLNAME_CONSTRAINT_ID_FK = "CONSTRAINT_ID_FK";
    public static final String COLNAME_COLUMN_ID_FK = "COLUMN_ID_FK";
    public static final String COLNAME_COLUMN_PORTION = "COLUMN_PORTION";
    public static final String COLNAME_CONSTRAINT_TEXT = "CONSTRAINT_TEXT";
    public static final String COLNAME_DETAIL_ORDER = "DETAIL_ORDER";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MdConstraintDetail(DBObjectId constraintId, Integer detailOrder) {
        this.setConstraintId(constraintId);
        this.setDetailOrder(detailOrder);
    }

    public static MdConstraintDetail getExistingInstance(DBObjectId key) {
        MdConstraintDetail ret = new MdConstraintDetail();
        ret.setKey(key);
        return ret;
    }

    private MdConstraintDetail() {
    }

    public static MdConstraintDetail retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdConstraintDetail ret = MdConstraintDetail.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    public void setRefFlag(String refFlag) {
        Field f = new Field(COLNAME_REF_FLAG, "STRING");
        f.setValue(refFlag);
        this.setField(f);
    }

    protected void setConstraintId(DBObjectId constraintId) {
        Field f = new Field(COLNAME_CONSTRAINT_ID_FK, "DBOBJECTID", false);
        f.setValue(constraintId);
        this.setField(f);
    }

    public void setColumnId(DBObjectId columnId) {
        Field f = new Field(COLNAME_COLUMN_ID_FK, "DBOBJECTID");
        f.setValue(columnId);
        this.setField(f);
    }

    public void setColumnPortion(Integer columnPortion) {
        Field f = new Field(COLNAME_COLUMN_PORTION, "INTEGER");
        f.setValue(columnPortion);
        this.setField(f);
    }

    public void setConstraintText(String sconstraintText) {
        Field f = new Field(COLNAME_CONSTRAINT_TEXT, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(sconstraintText);
        f.setValue(clobHelper);
        this.setField(f);
    }

    public void setConstraintText(ClobHelper clobHelper) {
        Field f = new Field(COLNAME_CONSTRAINT_TEXT, "CLOBHELPER");
        f.setValue(clobHelper);
        this.setField(f);
    }

    protected void setDetailOrder(Integer detailOrder) {
        Field f = new Field(COLNAME_DETAIL_ORDER, "INTEGER", false);
        f.setValue(detailOrder);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public String getRefFlag() {
        Field f = this.getField(COLNAME_REF_FLAG);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getConstraintId() {
        Field f = this.getField(COLNAME_CONSTRAINT_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public DBObjectId getColumnId() {
        Field f = this.getField(COLNAME_COLUMN_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Integer getColumnPortion() {
        Field f = this.getField(COLNAME_COLUMN_PORTION);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public ClobHelper getConstraintText() {
        Field f = this.getField(COLNAME_CONSTRAINT_TEXT);
        if (f == null) {
            return null;
        }
        return f.getClobHelper();
    }

    public Integer getDetailOrder() {
        Field f = this.getField(COLNAME_DETAIL_ORDER);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            Object o = rs.getString(COLNAME_REF_FLAG);
            if (rs.wasNull()) {
                this.setRefFlag(null);
            } else {
                this.setRefFlag((String)o);
            }
            this.setConstraintId(new DBObjectId(rs.getLong(COLNAME_CONSTRAINT_ID_FK)));
            o = new DBObjectId(rs.getLong(COLNAME_COLUMN_ID_FK));
            if (rs.wasNull()) {
                this.setColumnId(null);
            } else {
                this.setColumnId((DBObjectId)o);
            }
            o = rs.getInt(COLNAME_COLUMN_PORTION);
            if (rs.wasNull()) {
                this.setColumnPortion(null);
            } else {
                this.setColumnPortion((Integer)o);
            }
            o = new ClobHelper(rs.getClob(COLNAME_CONSTRAINT_TEXT));
            if (rs.wasNull()) {
                this.setConstraintText((ClobHelper)null);
            } else {
                this.setConstraintText((ClobHelper)o);
            }
            this.setDetailOrder(rs.getInt(COLNAME_DETAIL_ORDER));
            o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    public String getContainerFieldName() {
        return COLNAME_CONSTRAINT_ID_FK;
    }

    public DBObjectId getContainerId() {
        return this.getConstraintId();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

