/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdDerivative
extends PersistableObject {
    public static final String TABLE_NAME = "MD_DERIVATIVES";
    public static final String COLNAME_SRC_ID = "SRC_ID";
    public static final String COLNAME_SRC_TYPE = "SRC_TYPE";
    public static final String COLNAME_DERIVED_ID = "DERIVED_ID";
    public static final String COLNAME_DERIVED_TYPE = "DERIVED_TYPE";
    public static final String COLNAME_DERIVED_CONNECTION_ID_FK = "DERIVED_CONNECTION_ID_FK";
    public static final String COLNAME_TRANSFORMED = "TRANSFORMED";
    public static final String COLNAME_ORIGINAL_IDENTIFIER = "ORIGINAL_IDENTIFIER";
    public static final String COLNAME_NEW_IDENTIFIER = "NEW_IDENTIFIER";
    public static final String COLNAME_DERIVED_OBJECT_NAMESPACE = "DERIVED_OBJECT_NAMESPACE";
    public static final String COLNAME_DERIVATIVE_REASON = "DERIVATIVE_REASON";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MdDerivative(DBObjectId srcId, DBObjectId derivedId, DBObjectId derivedConnectionId) {
        this.setSrcId(srcId);
        this.setDerivedId(derivedId);
        this.setDerivedConnectionId(derivedConnectionId);
    }

    public static MdDerivative getExistingInstance(DBObjectId key) {
        MdDerivative ret = new MdDerivative();
        ret.setKey(key);
        return ret;
    }

    private MdDerivative() {
    }

    public static MdDerivative retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdDerivative ret = MdDerivative.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setSrcId(DBObjectId srcId) {
        Field f = new Field(COLNAME_SRC_ID, "DBOBJECTID", false);
        f.setValue(srcId);
        this.setField(f);
    }

    public void setSrcType(String srcType) {
        Field f = new Field(COLNAME_SRC_TYPE, "STRING");
        f.setValue(srcType);
        this.setField(f);
    }

    protected void setDerivedId(DBObjectId derivedId) {
        Field f = new Field(COLNAME_DERIVED_ID, "DBOBJECTID", false);
        f.setValue(derivedId);
        this.setField(f);
    }

    public void setDerivedType(String derivedType) {
        Field f = new Field(COLNAME_DERIVED_TYPE, "STRING");
        f.setValue(derivedType);
        this.setField(f);
    }

    protected void setDerivedConnectionId(DBObjectId derivedConnectionId) {
        Field f = new Field(COLNAME_DERIVED_CONNECTION_ID_FK, "DBOBJECTID", false);
        f.setValue(derivedConnectionId);
        this.setField(f);
    }

    public void setTransformed(String transformed) {
        Field f = new Field(COLNAME_TRANSFORMED, "STRING");
        f.setValue(transformed);
        this.setField(f);
    }

    public void setOriginalIdentifier(String originalIdentifier) {
        Field f = new Field(COLNAME_ORIGINAL_IDENTIFIER, "STRING");
        f.setValue(originalIdentifier);
        this.setField(f);
    }

    public void setNewIdentifier(String newIdentifier) {
        Field f = new Field(COLNAME_NEW_IDENTIFIER, "STRING");
        f.setValue(newIdentifier);
        this.setField(f);
    }

    public void setDerivedObjectNamespace(String derivedObjectNamespace) {
        Field f = new Field(COLNAME_DERIVED_OBJECT_NAMESPACE, "STRING");
        f.setValue(derivedObjectNamespace);
        this.setField(f);
    }

    public void setDerivativeReason(String derivativeReason) {
        Field f = new Field(COLNAME_DERIVATIVE_REASON, "STRING");
        f.setValue(derivativeReason);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public DBObjectId getSrcId() {
        Field f = this.getField(COLNAME_SRC_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getSrcType() {
        Field f = this.getField(COLNAME_SRC_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getDerivedId() {
        Field f = this.getField(COLNAME_DERIVED_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getDerivedType() {
        Field f = this.getField(COLNAME_DERIVED_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getDerivedConnectionId() {
        Field f = this.getField(COLNAME_DERIVED_CONNECTION_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getTransformed() {
        Field f = this.getField(COLNAME_TRANSFORMED);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getOriginalIdentifier() {
        Field f = this.getField(COLNAME_ORIGINAL_IDENTIFIER);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getNewIdentifier() {
        Field f = this.getField(COLNAME_NEW_IDENTIFIER);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getDerivedObjectNamespace() {
        Field f = this.getField(COLNAME_DERIVED_OBJECT_NAMESPACE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getDerivativeReason() {
        Field f = this.getField(COLNAME_DERIVATIVE_REASON);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            this.setSrcId(new DBObjectId(rs.getLong(COLNAME_SRC_ID)));
            Object o = rs.getString(COLNAME_SRC_TYPE);
            if (rs.wasNull()) {
                this.setSrcType(null);
            } else {
                this.setSrcType((String)o);
            }
            this.setDerivedId(new DBObjectId(rs.getLong(COLNAME_DERIVED_ID)));
            o = rs.getString(COLNAME_DERIVED_TYPE);
            if (rs.wasNull()) {
                this.setDerivedType(null);
            } else {
                this.setDerivedType((String)o);
            }
            this.setDerivedConnectionId(new DBObjectId(rs.getLong(COLNAME_DERIVED_CONNECTION_ID_FK)));
            o = rs.getString(COLNAME_TRANSFORMED);
            if (rs.wasNull()) {
                this.setTransformed(null);
            } else {
                this.setTransformed((String)o);
            }
            o = rs.getString(COLNAME_ORIGINAL_IDENTIFIER);
            if (rs.wasNull()) {
                this.setOriginalIdentifier(null);
            } else {
                this.setOriginalIdentifier((String)o);
            }
            o = rs.getString(COLNAME_NEW_IDENTIFIER);
            if (rs.wasNull()) {
                this.setNewIdentifier(null);
            } else {
                this.setNewIdentifier((String)o);
            }
            o = rs.getString(COLNAME_DERIVED_OBJECT_NAMESPACE);
            if (rs.wasNull()) {
                this.setDerivedObjectNamespace(null);
            } else {
                this.setDerivedObjectNamespace((String)o);
            }
            o = rs.getString(COLNAME_DERIVATIVE_REASON);
            if (rs.wasNull()) {
                this.setDerivativeReason(null);
            } else {
                this.setDerivativeReason((String)o);
            }
            o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

