/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.ide.util.Assert;

public class MdIdentityColumn
extends MdColumn {
    public static final String PROPERTY_SEED = "SEEDVALUE";
    public static final String PROPERTY_INCREMENT = "INCREMENT";
    public static final String PROPERTY_LASTVALUE = "LASTVALUE";

    public MdIdentityColumn(DBObjectId tableId, String columnName, Integer columnOrder, long seed, DBObjectId connectionId) {
        super(tableId, columnName, columnOrder);
        this.addProperty(PROPERTY_SEED, Long.toString(seed), connectionId);
    }

    public MdIdentityColumn(DBObjectId tableId, String columnName, Integer columnOrder, long seed, long increment, DBObjectId connectionId) {
        this(tableId, columnName, columnOrder, seed, connectionId);
        this.addProperty(PROPERTY_INCREMENT, Long.toString(increment), connectionId);
    }

    public MdIdentityColumn(DBObjectId tableId, String columnName, Integer columnOrder, long seed, long increment, long lastValue, DBObjectId connectionId) {
        this(tableId, columnName, columnOrder, seed, increment, connectionId);
        this.addProperty(PROPERTY_LASTVALUE, Long.toString(lastValue), connectionId);
    }

    public Long getSeed() {
        String s = this.getProperty(PROPERTY_SEED);
        if (s != null) {
            try {
                return new Long(s);
            }
            catch (NumberFormatException nfe) {
                Assert.println((String)("Warning: Seed value is not a number " + s));
                return null;
            }
        }
        return null;
    }

    public Long getIncrement() {
        String s = this.getProperty(PROPERTY_INCREMENT);
        if (s != null) {
            try {
                return new Long(s);
            }
            catch (NumberFormatException nfe) {
                Assert.println((String)("Warning: Increment value is not a number " + s));
                return null;
            }
        }
        return null;
    }

    public Long getLastValue() {
        String s = this.getProperty(PROPERTY_LASTVALUE);
        if (s != null) {
            try {
                return new Long(s);
            }
            catch (NumberFormatException nfe) {
                Assert.println((String)("Warning: Increment value is not a number " + s));
                return null;
            }
        }
        return null;
    }

    public boolean hasSeed() {
        return this.getSeed() != null;
    }

    public boolean hasIncrement() {
        return this.getIncrement() != null;
    }

    public boolean hasLastValue() {
        return this.getLastValue() != null;
    }
}

