/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdIndexDetail
extends PersistableObject {
    public static final String TABLE_NAME = "MD_INDEX_DETAILS";
    public static final String COLNAME_INDEX_ID_FK = "INDEX_ID_FK";
    public static final String COLNAME_COLUMN_ID_FK = "COLUMN_ID_FK";
    public static final String COLNAME_INDEX_PORTION = "INDEX_PORTION";
    public static final String COLNAME_DETAIL_ORDER = "DETAIL_ORDER";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MdIndexDetail(DBObjectId indexId, DBObjectId columnId, Integer detailOrder) {
        this.setIndexId(indexId);
        this.setColumnId(columnId);
        this.setDetailOrder(detailOrder);
    }

    public static MdIndexDetail getExistingInstance(DBObjectId key) {
        MdIndexDetail ret = new MdIndexDetail();
        ret.setKey(key);
        return ret;
    }

    private MdIndexDetail() {
    }

    public static MdIndexDetail retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdIndexDetail ret = MdIndexDetail.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setIndexId(DBObjectId indexId) {
        Field f = new Field(COLNAME_INDEX_ID_FK, "DBOBJECTID", false);
        f.setValue(indexId);
        this.setField(f);
    }

    protected void setColumnId(DBObjectId columnId) {
        Field f = new Field(COLNAME_COLUMN_ID_FK, "DBOBJECTID", false);
        f.setValue(columnId);
        this.setField(f);
    }

    public void setIndexPortion(Integer indexPortion) {
        Field f = new Field(COLNAME_INDEX_PORTION, "INTEGER");
        f.setValue(indexPortion);
        this.setField(f);
    }

    protected void setDetailOrder(Integer detailOrder) {
        Field f = new Field(COLNAME_DETAIL_ORDER, "INTEGER", false);
        f.setValue(detailOrder);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public DBObjectId getIndexId() {
        Field f = this.getField(COLNAME_INDEX_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public DBObjectId getColumnId() {
        Field f = this.getField(COLNAME_COLUMN_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Integer getIndexPortion() {
        Field f = this.getField(COLNAME_INDEX_PORTION);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getDetailOrder() {
        Field f = this.getField(COLNAME_DETAIL_ORDER);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            this.setIndexId(new DBObjectId(rs.getLong(COLNAME_INDEX_ID_FK)));
            this.setColumnId(new DBObjectId(rs.getLong(COLNAME_COLUMN_ID_FK)));
            Object o = rs.getInt(COLNAME_INDEX_PORTION);
            if (rs.wasNull()) {
                this.setIndexPortion(null);
            } else {
                this.setIndexPortion((Integer)o);
            }
            this.setDetailOrder(rs.getInt(COLNAME_DETAIL_ORDER));
            o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    public String getContainerFieldName() {
        return COLNAME_INDEX_ID_FK;
    }

    public DBObjectId getContainerId() {
        return this.getIndexId();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

