/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdMigrDependency
extends PersistableObject {
    public static final String TABLE_NAME = "MD_MIGR_DEPENDENCY";
    public static final String COLNAME_CONNECTION_ID_FK = "CONNECTION_ID_FK";
    public static final String COLNAME_PARENT_ID = "PARENT_ID";
    public static final String COLNAME_CHILD_ID = "CHILD_ID";
    public static final String COLNAME_PARENT_OBJECT_TYPE = "PARENT_OBJECT_TYPE";
    public static final String COLNAME_CHILD_OBJECT_TYPE = "CHILD_OBJECT_TYPE";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MdMigrDependency(DBObjectId connectionId, DBObjectId parentId, DBObjectId childId, String parentObjectType, String childObjectType) {
        this.setConnectionId(connectionId);
        this.setParentId(parentId);
        this.setChildId(childId);
        this.setParentObjectType(parentObjectType);
        this.setChildObjectType(childObjectType);
    }

    public static MdMigrDependency getExistingInstance(DBObjectId key) {
        MdMigrDependency ret = new MdMigrDependency();
        ret.setKey(key);
        return ret;
    }

    private MdMigrDependency() {
    }

    public static MdMigrDependency retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdMigrDependency ret = MdMigrDependency.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setConnectionId(DBObjectId connectionId) {
        Field f = new Field(COLNAME_CONNECTION_ID_FK, "DBOBJECTID", false);
        f.setValue(connectionId);
        this.setField(f);
    }

    protected void setParentId(DBObjectId parentId) {
        Field f = new Field(COLNAME_PARENT_ID, "DBOBJECTID", false);
        f.setValue(parentId);
        this.setField(f);
    }

    protected void setChildId(DBObjectId childId) {
        Field f = new Field(COLNAME_CHILD_ID, "DBOBJECTID", false);
        f.setValue(childId);
        this.setField(f);
    }

    protected void setParentObjectType(String parentObjectType) {
        Field f = new Field(COLNAME_PARENT_OBJECT_TYPE, "STRING", false);
        f.setValue(parentObjectType);
        this.setField(f);
    }

    protected void setChildObjectType(String childObjectType) {
        Field f = new Field(COLNAME_CHILD_OBJECT_TYPE, "STRING", false);
        f.setValue(childObjectType);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public DBObjectId getConnectionId() {
        Field f = this.getField(COLNAME_CONNECTION_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public DBObjectId getParentId() {
        Field f = this.getField(COLNAME_PARENT_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public DBObjectId getChildId() {
        Field f = this.getField(COLNAME_CHILD_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getParentObjectType() {
        Field f = this.getField(COLNAME_PARENT_OBJECT_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getChildObjectType() {
        Field f = this.getField(COLNAME_CHILD_OBJECT_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            this.setConnectionId(new DBObjectId(rs.getLong(COLNAME_CONNECTION_ID_FK)));
            this.setParentId(new DBObjectId(rs.getLong(COLNAME_PARENT_ID)));
            this.setChildId(new DBObjectId(rs.getLong(COLNAME_CHILD_ID)));
            this.setParentObjectType(rs.getString(COLNAME_PARENT_OBJECT_TYPE));
            this.setChildObjectType(rs.getString(COLNAME_CHILD_OBJECT_TYPE));
            Object o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    public String getContainerFieldName() {
        return COLNAME_CONNECTION_ID_FK;
    }

    public DBObjectId getContainerId() {
        return this.getConnectionId();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

