/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdMigrParameter
extends PersistableObject {
    public static final String TABLE_NAME = "MD_MIGR_PARAMETER";
    public static final String COLNAME_CONNECTION_ID_FK = "CONNECTION_ID_FK";
    public static final String COLNAME_OBJECT_ID = "OBJECT_ID";
    public static final String COLNAME_OBJECT_TYPE = "OBJECT_TYPE";
    public static final String COLNAME_PARAM_EXISTING = "PARAM_EXISTING";
    public static final String COLNAME_PARAM_ORDER = "PARAM_ORDER";
    public static final String COLNAME_PARAM_NAME = "PARAM_NAME";
    public static final String COLNAME_PARAM_TYPE = "PARAM_TYPE";
    public static final String COLNAME_PARAM_DATA_TYPE = "PARAM_DATA_TYPE";
    public static final String COLNAME_PERCISION = "PERCISION";
    public static final String COLNAME_SCALE = "SCALE";
    public static final String COLNAME_NULLABLE = "NULLABLE";
    public static final String COLNAME_DEFAULT_VALUE = "DEFAULT_VALUE";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MdMigrParameter(DBObjectId connectionId, DBObjectId objectId, String objectType, Integer paramExisting, Integer paramOrder, String paramName, String paramType, String paramDataType, String nullable) {
        this.setConnectionId(connectionId);
        this.setObjectId(objectId);
        this.setObjectType(objectType);
        this.setParamExisting(paramExisting);
        this.setParamOrder(paramOrder);
        this.setParamName(paramName);
        this.setParamType(paramType);
        this.setParamDataType(paramDataType);
        this.setNullable(nullable);
    }

    public static MdMigrParameter getExistingInstance(DBObjectId key) {
        MdMigrParameter ret = new MdMigrParameter();
        ret.setKey(key);
        return ret;
    }

    private MdMigrParameter() {
    }

    public static MdMigrParameter retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdMigrParameter ret = MdMigrParameter.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setConnectionId(DBObjectId connectionId) {
        Field f = new Field(COLNAME_CONNECTION_ID_FK, "DBOBJECTID", false);
        f.setValue(connectionId);
        this.setField(f);
    }

    protected void setObjectId(DBObjectId objectId) {
        Field f = new Field(COLNAME_OBJECT_ID, "DBOBJECTID", false);
        f.setValue(objectId);
        this.setField(f);
    }

    protected void setObjectType(String objectType) {
        Field f = new Field(COLNAME_OBJECT_TYPE, "STRING", false);
        f.setValue(objectType);
        this.setField(f);
    }

    protected void setParamExisting(Integer paramExisting) {
        Field f = new Field(COLNAME_PARAM_EXISTING, "INTEGER", false);
        f.setValue(paramExisting);
        this.setField(f);
    }

    protected void setParamOrder(Integer paramOrder) {
        Field f = new Field(COLNAME_PARAM_ORDER, "INTEGER", false);
        f.setValue(paramOrder);
        this.setField(f);
    }

    protected void setParamName(String paramName) {
        Field f = new Field(COLNAME_PARAM_NAME, "STRING", false);
        f.setValue(paramName);
        this.setField(f);
    }

    protected void setParamType(String paramType) {
        Field f = new Field(COLNAME_PARAM_TYPE, "STRING", false);
        f.setValue(paramType);
        this.setField(f);
    }

    protected void setParamDataType(String paramDataType) {
        Field f = new Field(COLNAME_PARAM_DATA_TYPE, "STRING", false);
        f.setValue(paramDataType);
        this.setField(f);
    }

    public void setPercision(Integer percision) {
        Field f = new Field(COLNAME_PERCISION, "INTEGER");
        f.setValue(percision);
        this.setField(f);
    }

    public void setScale(Integer scale) {
        Field f = new Field(COLNAME_SCALE, "INTEGER");
        f.setValue(scale);
        this.setField(f);
    }

    protected void setNullable(String nullable) {
        Field f = new Field(COLNAME_NULLABLE, "STRING", false);
        f.setValue(nullable);
        this.setField(f);
    }

    public void setDefaultValue(String defaultValue) {
        Field f = new Field(COLNAME_DEFAULT_VALUE, "STRING");
        f.setValue(defaultValue);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public DBObjectId getConnectionId() {
        Field f = this.getField(COLNAME_CONNECTION_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public DBObjectId getObjectId() {
        Field f = this.getField(COLNAME_OBJECT_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getObjectType() {
        Field f = this.getField(COLNAME_OBJECT_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Integer getParamExisting() {
        Field f = this.getField(COLNAME_PARAM_EXISTING);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getParamOrder() {
        Field f = this.getField(COLNAME_PARAM_ORDER);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public String getParamName() {
        Field f = this.getField(COLNAME_PARAM_NAME);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getParamType() {
        Field f = this.getField(COLNAME_PARAM_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getParamDataType() {
        Field f = this.getField(COLNAME_PARAM_DATA_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Integer getPercision() {
        Field f = this.getField(COLNAME_PERCISION);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public Integer getScale() {
        Field f = this.getField(COLNAME_SCALE);
        if (f == null) {
            return null;
        }
        return f.getInteger();
    }

    public String getNullable() {
        Field f = this.getField(COLNAME_NULLABLE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getDefaultValue() {
        Field f = this.getField(COLNAME_DEFAULT_VALUE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            this.setConnectionId(new DBObjectId(rs.getLong(COLNAME_CONNECTION_ID_FK)));
            this.setObjectId(new DBObjectId(rs.getLong(COLNAME_OBJECT_ID)));
            this.setObjectType(rs.getString(COLNAME_OBJECT_TYPE));
            this.setParamExisting(rs.getInt(COLNAME_PARAM_EXISTING));
            this.setParamOrder(rs.getInt(COLNAME_PARAM_ORDER));
            this.setParamName(rs.getString(COLNAME_PARAM_NAME));
            this.setParamType(rs.getString(COLNAME_PARAM_TYPE));
            this.setParamDataType(rs.getString(COLNAME_PARAM_DATA_TYPE));
            Object o = rs.getInt(COLNAME_PERCISION);
            if (rs.wasNull()) {
                this.setPercision(null);
            } else {
                this.setPercision((Integer)o);
            }
            o = rs.getInt(COLNAME_SCALE);
            if (rs.wasNull()) {
                this.setScale(null);
            } else {
                this.setScale((Integer)o);
            }
            this.setNullable(rs.getString(COLNAME_NULLABLE));
            o = rs.getString(COLNAME_DEFAULT_VALUE);
            if (rs.wasNull()) {
                this.setDefaultValue(null);
            } else {
                this.setDefaultValue((String)o);
            }
            o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    public String getContainerFieldName() {
        return COLNAME_CONNECTION_ID_FK;
    }

    public DBObjectId getContainerId() {
        return this.getConnectionId();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

