/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdPrivilege
extends PersistableObject {
    public static final String TABLE_NAME = "MD_PRIVILEGES";
    public static final String COLNAME_SCHEMA_ID_FK = "SCHEMA_ID_FK";
    public static final String COLNAME_PRIVILEGE_NAME = "PRIVILEGE_NAME";
    public static final String COLNAME_PRIVELEGE_OBJECT_ID = "PRIVELEGE_OBJECT_ID";
    public static final String COLNAME_PRIVELEGEOBJECTTYPE = "PRIVELEGEOBJECTTYPE";
    public static final String COLNAME_PRIVELEGE_TYPE = "PRIVELEGE_TYPE";
    public static final String COLNAME_ADMIN_OPTION = "ADMIN_OPTION";
    public static final String COLNAME_NATIVE_SQL = "NATIVE_SQL";
    public static final String COLNAME_NATIVE_KEY = "NATIVE_KEY";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdPrivilege(DBObjectId schemaId, String privilegeName, String privelegeobjecttype, String privelegeType, ClobHelper nativeSql) {
        this.setSchemaId(schemaId);
        this.setPrivilegeName(privilegeName);
        this.setPrivelegeobjecttype(privelegeobjecttype);
        this.setPrivelegeType(privelegeType);
        this.setNativeSql(nativeSql);
    }

    public static MdPrivilege getExistingInstance(DBObjectId key) {
        MdPrivilege ret = new MdPrivilege();
        ret.setKey(key);
        return ret;
    }

    private MdPrivilege() {
    }

    public static MdPrivilege retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdPrivilege ret = MdPrivilege.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setSchemaId(DBObjectId schemaId) {
        Field f = new Field(COLNAME_SCHEMA_ID_FK, "DBOBJECTID", false);
        f.setValue(schemaId);
        this.setField(f);
    }

    protected void setPrivilegeName(String privilegeName) {
        Field f = new Field(COLNAME_PRIVILEGE_NAME, "STRING", false);
        f.setValue(privilegeName);
        this.setField(f);
    }

    public void setPrivelegeObjectId(DBObjectId privelegeObjectId) {
        Field f = new Field(COLNAME_PRIVELEGE_OBJECT_ID, "DBOBJECTID");
        f.setValue(privelegeObjectId);
        this.setField(f);
    }

    protected void setPrivelegeobjecttype(String privelegeobjecttype) {
        Field f = new Field(COLNAME_PRIVELEGEOBJECTTYPE, "STRING", false);
        f.setValue(privelegeobjecttype);
        this.setField(f);
    }

    protected void setPrivelegeType(String privelegeType) {
        Field f = new Field(COLNAME_PRIVELEGE_TYPE, "STRING", false);
        f.setValue(privelegeType);
        this.setField(f);
    }

    public void setAdminOption(String adminOption) {
        Field f = new Field(COLNAME_ADMIN_OPTION, "STRING");
        f.setValue(adminOption);
        this.setField(f);
    }

    protected void setNativeSql(String snativeSql) {
        Field f = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(snativeSql);
        f.setValue(clobHelper);
        this.setField(f);
    }

    protected void setNativeSql(ClobHelper clobHelper) {
        Field f = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        f.setValue(clobHelper);
        this.setField(f);
    }

    public void setNativeKey(String nativeKey) {
        Field f = new Field(COLNAME_NATIVE_KEY, "STRING");
        f.setValue(nativeKey);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public void setComments(String comments) {
        Field f = new Field(COLNAME_COMMENTS, "STRING");
        f.setValue(comments);
        this.setField(f);
    }

    public DBObjectId getSchemaId() {
        Field f = this.getField(COLNAME_SCHEMA_ID_FK);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getPrivilegeName() {
        Field f = this.getField(COLNAME_PRIVILEGE_NAME);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getPrivelegeObjectId() {
        Field f = this.getField(COLNAME_PRIVELEGE_OBJECT_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public String getPrivelegeobjecttype() {
        Field f = this.getField(COLNAME_PRIVELEGEOBJECTTYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getPrivelegeType() {
        Field f = this.getField(COLNAME_PRIVELEGE_TYPE);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getAdminOption() {
        Field f = this.getField(COLNAME_ADMIN_OPTION);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public ClobHelper getNativeSql() {
        Field f = this.getField(COLNAME_NATIVE_SQL);
        if (f == null) {
            return null;
        }
        return f.getClobHelper();
    }

    public String getNativeKey() {
        Field f = this.getField(COLNAME_NATIVE_KEY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getComments() {
        Field f = this.getField(COLNAME_COMMENTS);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            this.setSchemaId(new DBObjectId(rs.getLong(COLNAME_SCHEMA_ID_FK)));
            this.setPrivilegeName(rs.getString(COLNAME_PRIVILEGE_NAME));
            Object o = new DBObjectId(rs.getLong(COLNAME_PRIVELEGE_OBJECT_ID));
            if (rs.wasNull()) {
                this.setPrivelegeObjectId(null);
            } else {
                this.setPrivelegeObjectId((DBObjectId)o);
            }
            this.setPrivelegeobjecttype(rs.getString(COLNAME_PRIVELEGEOBJECTTYPE));
            this.setPrivelegeType(rs.getString(COLNAME_PRIVELEGE_TYPE));
            o = rs.getString(COLNAME_ADMIN_OPTION);
            if (rs.wasNull()) {
                this.setAdminOption(null);
            } else {
                this.setAdminOption((String)o);
            }
            this.setNativeSql(new ClobHelper(rs.getClob(COLNAME_NATIVE_SQL)));
            o = rs.getString(COLNAME_NATIVE_KEY);
            if (rs.wasNull()) {
                this.setNativeKey(null);
            } else {
                this.setNativeKey((String)o);
            }
            o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
            o = rs.getString(COLNAME_COMMENTS);
            if (rs.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    public String getObjectName() {
        return this.getPrivilegeName();
    }

    public String getObjectNameFieldName() {
        return COLNAME_PRIVILEGE_NAME;
    }

    public void rename(String newName) {
        this.setPrivilegeName(newName);
    }

    public String getContainerFieldName() {
        return COLNAME_SCHEMA_ID_FK;
    }

    public DBObjectId getContainerId() {
        return this.getSchemaId();
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

