/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdProject
extends PersistableObject {
    public static final String TABLE_NAME = "MD_PROJECTS";
    public static final String COLNAME_PROJECT_NAME = "PROJECT_NAME";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdProject(String projectName) {
        this.setProjectName(projectName);
    }

    public static MdProject getExistingInstance(DBObjectId key) {
        MdProject ret = new MdProject();
        ret.setKey(key);
        return ret;
    }

    private MdProject() {
    }

    public static MdProject retrieveExistingInstance(PersistenceManager pman, DBObjectId key) throws PersistenceException, NoSuchObjectException {
        MdProject ret = MdProject.getExistingInstance(key);
        ret.retrieve(pman);
        return ret;
    }

    protected void setProjectName(String projectName) {
        Field f = new Field(COLNAME_PROJECT_NAME, "STRING", false);
        f.setValue(projectName);
        this.setField(f);
    }

    public void setSecurityGroupId(DBObjectId securityGroupId) {
        Field f = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        f.setValue(securityGroupId);
        this.setField(f);
    }

    public void setCreatedOn(Date createdOn) {
        Field f = new Field(COLNAME_CREATED_ON, "DATE");
        f.setValue(createdOn);
        this.setField(f);
    }

    public void setCreatedBy(String createdBy) {
        Field f = new Field(COLNAME_CREATED_BY, "STRING");
        f.setValue(createdBy);
        this.setField(f);
    }

    public void setLastUpdatedOn(Date lastUpdatedOn) {
        Field f = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        f.setValue(lastUpdatedOn);
        this.setField(f);
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        Field f = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        f.setValue(lastUpdatedBy);
        this.setField(f);
    }

    public void setComments(String comments) {
        Field f = new Field(COLNAME_COMMENTS, "STRING");
        f.setValue(comments);
        this.setField(f);
    }

    public String getProjectName() {
        Field f = this.getField(COLNAME_PROJECT_NAME);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field f = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (f == null) {
            return null;
        }
        return f.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field f = this.getField(COLNAME_CREATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getCreatedBy() {
        Field f = this.getField(COLNAME_CREATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public Date getLastUpdatedOn() {
        Field f = this.getField(COLNAME_LAST_UPDATED_ON);
        if (f == null) {
            return null;
        }
        return f.getDate();
    }

    public String getLastUpdatedBy() {
        Field f = this.getField(COLNAME_LAST_UPDATED_BY);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public String getComments() {
        Field f = this.getField(COLNAME_COMMENTS);
        if (f == null) {
            return null;
        }
        return f.getString();
    }

    public void retrieve(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet crs = this.issueRetrieveQuery(pman);
        ResultSet rs = crs.getResultSet();
        try {
            this.setProjectName(rs.getString(COLNAME_PROJECT_NAME));
            Object o = new DBObjectId(rs.getLong(COLNAME_SECURITY_GROUP_ID));
            if (rs.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)o);
            }
            o = rs.getDate(COLNAME_CREATED_ON);
            if (rs.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)o);
            }
            o = rs.getString(COLNAME_CREATED_BY);
            if (rs.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)o);
            }
            o = rs.getDate(COLNAME_LAST_UPDATED_ON);
            if (rs.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)o);
            }
            o = rs.getString(COLNAME_LAST_UPDATED_BY);
            if (rs.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)o);
            }
            o = rs.getString(COLNAME_COMMENTS);
            if (rs.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)o);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            crs.close();
        }
        this.retrieveAdditionalProperties(pman);
        this.clearUpdatedFields();
    }

    public String getObjectName() {
        return this.getProjectName();
    }

    public String getObjectNameFieldName() {
        return COLNAME_PROJECT_NAME;
    }

    public void rename(String newName) {
        this.setProjectName(newName);
    }

    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

