/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MgvAllProjectsRec;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MgvIterator
implements CloseableIterator {
    private CloseableResultSet m_crs;
    private Constructor m_recordConstructor;
    private MgvAllProjectsRec m_nextRecord;

    public MgvIterator(Class recordClass, String query, DBObjectId searchId, PersistenceManager pman) throws PersistenceException {
        Class[] constructorParameters = new Class[]{ResultSet.class};
        try {
            this.m_recordConstructor = recordClass.getConstructor(constructorParameters);
        }
        catch (NoSuchMethodException nsme) {
            throw new PersistenceException(nsme);
        }
        try {
            PreparedStatement stmt = pman.getPreparedStatement(query);
            stmt.setLong(1, searchId.getId());
            ResultSet rs = stmt.executeQuery();
            this.m_crs = new CloseableResultSet(null, rs);
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    public void close() {
        if (this.m_crs != null) {
            this.m_crs.close();
        }
    }

    public boolean hasNext() {
        block6: {
            if (this.m_crs == null || this.m_crs.getResultSet() == null) {
                return false;
            }
            ResultSet rs = this.m_crs.getResultSet();
            try {
                if (rs.next()) {
                    Object[] parms = new Object[]{rs};
                    try {
                        this.m_nextRecord = (MgvAllProjectsRec)this.m_recordConstructor.newInstance(parms);
                        break block6;
                    }
                    catch (Exception e) {
                        this.m_crs.close();
                        this.m_crs = null;
                        return false;
                    }
                }
                this.m_crs.close();
                this.m_crs = null;
                return false;
            }
            catch (SQLException sqlex) {
                this.m_crs.close();
                this.m_crs = null;
                return false;
            }
        }
        return true;
    }

    public Object next() {
        if (this.m_nextRecord == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_nextRecord;
    }

    public void remove() {
    }
}

