/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class OrderedColumnsIterator
extends PersistableObjectIterator {
    private static final String QUERY_COLUMNS_QUERY = "SELECT ID FROM MD_COLUMNS WHERE TABLE_ID_FK = ? ORDER BY COLUMN_ORDER";
    private DBObjectId m_tableId;

    public OrderedColumnsIterator(PersistenceManager pman, DBObjectId tableId) {
        super(MdColumn.class, pman);
        this.setTableId(tableId);
    }

    protected DBObjectId getTableId() {
        return this.m_tableId;
    }

    protected void setTableId(DBObjectId tableId) {
        this.m_tableId = tableId;
    }

    protected PreparedStatement getPreparedStatement() throws SQLException {
        PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement(QUERY_COLUMNS_QUERY);
        stmt.setLong(1, this.getTableId().getId());
        return stmt;
    }
}

