/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class PersistableMasterChildren
extends PersistableObjectIterator {
    private PreparedStatement m_myPreparedStatement;
    private static final String GET_IDS_QUERY = "SELECT ID FROM {0} WHERE {1} = ?";

    public PersistableMasterChildren(Class child, String fkcol, DBObjectId masterkey, PersistenceManager pman, MigrationObjectFilterList filterList) throws PersistenceException {
        super(child, pman);
        MigrationObjectFilter filter;
        String tableName = this.getTableName();
        String[] params = new String[]{this.getTableName(), fkcol};
        String sql = MessageFormat.format(GET_IDS_QUERY, params);
        if (filterList != null && (filter = filterList.getFilterForType(tableName)) != null) {
            String whereClause = filter.toWhereConditionForMigrationRepository();
            if (whereClause == null) {
                throw new IllegalStateException("Error creating where condition");
            }
            sql = sql + " AND " + whereClause;
        }
        try {
            this.m_myPreparedStatement = pman.getPreparedStatement(sql);
            this.m_myPreparedStatement.setLong(1, masterkey.getId());
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    protected PreparedStatement getPreparedStatement() {
        return this.m_myPreparedStatement;
    }
}

