/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.MdAdditionalPropertie;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public abstract class PersistableObject {
    public static final String COLNAME_OBJECTID = "ID";
    private static final String REMOVE_PROPERTIES_QUERY = "DELETE FROM MD_ADDITIONAL_PROPERTIES WHERE REF_ID_FK=?";
    private static final String RETRIEVE_ADDITIONAL_PROPERTIES_QUERY = "SELECT PROP_KEY, VALUE, PROPERTY_ORDER, CONNECTION_ID_FK FROM MD_ADDITIONAL_PROPERTIES WHERE REF_ID_FK=? ORDER BY PROPERTY_ORDER";
    private static final String REMOVE_OBJECT_QUERY = "DELETE FROM {0} WHERE ID = :1";
    private static final String COUNT_OBJECTS_QUERY = "SELECT COUNT (*) FROM {0}";
    private static final String RETRIEVE_OBJECT_QUERY = "SELECT * FROM {0} WHERE ID = :1";
    private DBObjectId m_key;
    private Hashtable<String, Field> m_fields;
    private boolean m_isPersisted;
    private boolean m_isChanged;
    private ArrayList<AdditionalProperty> m_additionalProperties;
    private DBObjectId m_additionalPropertyConnectionId;
    private String m_insertStatement = null;

    protected abstract String getStorageTableName();

    public PersistableObject() {
        this.m_fields = new Hashtable();
        this.m_additionalProperties = new ArrayList();
    }

    public PersistableObject(DBObjectId key) {
        this.setKey(key);
    }

    public String getContainerFieldName() {
        return null;
    }

    public DBObjectId getContainerId() {
        return null;
    }

    public String getObjectName() {
        return null;
    }

    public String getObjectNameFieldName() {
        return null;
    }

    public boolean isChanged() {
        if (this.m_isChanged) {
            return true;
        }
        for (Field f : this.m_fields.values()) {
            if (!f.isUpdated()) continue;
            this.m_isChanged = true;
            break;
        }
        return this.m_isChanged;
    }

    protected void setChanged(boolean isChanged) {
        this.m_isChanged = isChanged;
    }

    protected boolean isPersisted() {
        return this.m_isPersisted;
    }

    private void setPersisted(boolean isPersisted) {
        this.m_isPersisted = isPersisted;
    }

    public DBObjectId getKey() {
        return this.m_key;
    }

    protected void setKey(DBObjectId key) {
        this.m_key = key;
        this.m_isPersisted = true;
    }

    public void save(PersistenceManager pman) throws PersistenceException {
        if (!this.m_isPersisted) {
            this.doInsert(pman);
        } else if (this.m_isChanged) {
            this.doUpdate(pman);
        }
        try {
            pman.commit();
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    protected String getInsertStatement() {
        if (this.m_insertStatement == null) {
            StringBuffer sBuf = new StringBuffer();
            StringBuffer sValuesClause = new StringBuffer();
            sBuf.append("INSERT INTO ");
            sValuesClause.append(") VALUES (");
            sBuf.append(this.getStorageTableName());
            sBuf.append("(");
            int count = 0;
            int bindIndex = 1;
            for (Field f : this.m_fields.values()) {
                sBuf.append("\"" + f.getColumnName() + "\"");
                sValuesClause.append(":" + bindIndex);
                ++bindIndex;
                if (++count < this.m_fields.size()) {
                    sBuf.append(", ");
                    sValuesClause.append(", ");
                    continue;
                }
                sValuesClause.append(")");
                sBuf.append(sValuesClause);
            }
            this.m_insertStatement = sBuf.toString();
        }
        return this.m_insertStatement;
    }

    private void doInsert(PersistenceManager pman) throws PersistenceException {
        String[] retKeys = new String[]{COLNAME_OBJECTID};
        try {
            PreparedStatement stmt = pman.getPreparedStatement(this.getInsertStatement(), retKeys);
            int nextParm = 1;
            for (Field f : this.m_fields.values()) {
                nextParm = this.setFieldOnPreparedStatement(stmt, nextParm, f);
            }
            stmt.executeUpdate();
            ResultSet rs = stmt.getGeneratedKeys();
            rs.next();
            this.setKey(new DBObjectId(rs.getLong(1)));
            this.saveAdditionalProperties(pman);
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        this.setChanged(false);
        this.setPersisted(true);
    }

    private void saveAdditionalProperties(PersistenceManager pman) throws PersistenceException {
        this.removeExistingAdditionalProperties(pman);
        if (this.m_additionalProperties.size() == 0) {
            return;
        }
        int iCount = 0;
        for (AdditionalProperty prop : this.m_additionalProperties) {
            MdAdditionalPropertie saveProp = new MdAdditionalPropertie(this.getAdditionalPropertyConnectionId(), this.getKey(), this.getStorageTableName(), prop.getKey());
            saveProp.setPropertyOrder(iCount++);
            saveProp.setValue(prop.getValue());
            saveProp.save(pman);
        }
    }

    protected void retrieveAdditionalProperties(PersistenceManager pman) throws PersistenceException {
        if (!this.isPersisted()) {
            return;
        }
        if (this.getAdditionalProperties().length != 0) {
            return;
        }
        CloseableResultSet crs = null;
        try {
            PreparedStatement stmt = pman.getPreparedStatement(RETRIEVE_ADDITIONAL_PROPERTIES_QUERY);
            stmt.setLong(1, this.m_key.getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            while (rs.next()) {
                AdditionalProperty prop = new AdditionalProperty(rs.getString(1), rs.getString(2));
                DBObjectId connectionId = new DBObjectId(rs.getLong(4));
                this.addProperty(prop, connectionId);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    private void removeExistingAdditionalProperties(PersistenceManager pman) throws PersistenceException {
        try {
            PreparedStatement stmt = pman.getPreparedStatement(REMOVE_PROPERTIES_QUERY);
            stmt.setLong(1, this.m_key.getId());
            stmt.executeUpdate();
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    private boolean fieldsUpdated() {
        for (Field f : this.m_fields.values()) {
            if (!f.isUpdated()) continue;
            return true;
        }
        return false;
    }

    protected void doUpdate(PersistenceManager pman) throws PersistenceException {
        if (this.fieldsUpdated()) {
            String sql = this.generateUpdateStatement();
            try {
                PreparedStatement stmt = pman.getPreparedStatement(sql);
                int nextParm = 1;
                for (Field f : this.m_fields.values()) {
                    if (!f.isUpdated()) continue;
                    nextParm = this.setFieldOnPreparedStatement(stmt, nextParm, f);
                }
                stmt.setLong(nextParm, this.m_key.getId());
                int rowsAffected = stmt.executeUpdate();
                if (rowsAffected != 1) {
                    throw new PersistenceException("Affected rows = " + rowsAffected + ", expecting only 1");
                }
            }
            catch (SQLException sqlex) {
                throw new PersistenceException(sqlex);
            }
        }
        this.saveAdditionalProperties(pman);
        this.clearUpdatedFields();
        this.setChanged(false);
        this.setPersisted(true);
    }

    private String generateUpdateStatement() {
        boolean bNeedsComma = false;
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("UPDATE ");
        sBuf.append(this.getStorageTableName());
        sBuf.append(" SET ");
        for (Field f : this.m_fields.values()) {
            if (!f.isUpdated()) continue;
            if (bNeedsComma) {
                sBuf.append(", ");
            }
            sBuf.append("\"" + f.getColumnName() + "\"");
            sBuf.append("= ?");
            bNeedsComma = true;
        }
        sBuf.append(" WHERE ID = ?");
        return sBuf.toString();
    }

    protected void setField(Field f) {
        if (this.m_fields.contains(f.getColumnName())) {
            this.m_fields.remove(f.getColumnName());
        }
        this.m_fields.put(f.getColumnName(), f);
        this.m_isChanged = true;
    }

    private int setFieldOnPreparedStatement(PreparedStatement stmt, int parmIndex, Field f) throws SQLException {
        if (f.getValue() == null) {
            stmt.setNull(parmIndex++, f.getSQLType());
            return parmIndex;
        }
        if (f.getDatatype().equals("LONG")) {
            stmt.setLong(parmIndex++, f.getLong());
        } else if (f.getDatatype().equals("STRING")) {
            stmt.setString(parmIndex++, f.getString());
        } else if (f.getDatatype().equals("DBOBJECTID")) {
            stmt.setLong(parmIndex++, f.getDBObjectId().getId());
        } else if (f.getDatatype().equals("INTEGER")) {
            stmt.setInt(parmIndex++, f.getInteger());
        } else if (f.getDatatype().equals("DATE")) {
            stmt.setDate(parmIndex++, f.getDate());
        } else if (f.getDatatype().equals("CLOBHELPER")) {
            ClobHelper clobHelper = f.getClobHelper();
            if (clobHelper.getLength() > Integer.MAX_VALUE) {
                throw new IllegalStateException("Clob value too long");
            }
            stmt.setCharacterStream(parmIndex++, clobHelper.getReader(), (int)clobHelper.getLength());
        } else if (f.getDatatype().equals("TIMESTAMP")) {
            stmt.setTimestamp(parmIndex++, f.getTimestamp());
        } else {
            throw new AssertionError((Object)("Unknown datatype " + f.getDatatype()));
        }
        return parmIndex;
    }

    protected void clearUpdatedFields() {
        for (Field f : this.m_fields.values()) {
            f.clearUpdated();
        }
    }

    protected Field getField(String fieldname) {
        if (this.m_fields.containsKey(fieldname)) {
            return this.m_fields.get(fieldname);
        }
        return null;
    }

    public void addProperty(String key, String value, DBObjectId connectionId) {
        AdditionalProperty prop = new AdditionalProperty(key, value);
        this.addProperty(prop, connectionId);
    }

    public void addProperty(AdditionalProperty property, DBObjectId connectionId) {
        this.m_additionalProperties.add(property);
        this.setAdditionalPropertyConnectionId(connectionId);
        this.setChanged(true);
    }

    public AdditionalProperty[] getAdditionalProperties() {
        return this.m_additionalProperties.toArray(new AdditionalProperty[this.m_additionalProperties.size()]);
    }

    public String getProperty(String propKey) {
        for (AdditionalProperty ap : this.m_additionalProperties) {
            if (!ap.getKey().equalsIgnoreCase(propKey)) continue;
            return ap.getValue();
        }
        return null;
    }

    public void delete(PersistenceManager pman) throws PersistenceException {
        if (!this.isPersisted()) {
            return;
        }
        if (this.getKey() == null) {
            return;
        }
        String sql = MessageFormat.format(REMOVE_OBJECT_QUERY, this.getStorageTableName());
        try {
            PreparedStatement stmt = pman.getPreparedStatement(sql);
            stmt.setLong(1, this.getKey().getId());
            int rowsAffected = stmt.executeUpdate();
            pman.commit();
            if (rowsAffected > 1) {
                throw new PersistenceException("Delete caused " + rowsAffected + " to be deleted");
            }
            this.removeExistingAdditionalProperties(pman);
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    public int countObjects(PersistenceManager pman) throws PersistenceException {
        String sql = MessageFormat.format(COUNT_OBJECTS_QUERY, this.getStorageTableName());
        try {
            PreparedStatement stmt = pman.getPreparedStatement(sql);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            int ret = rs.getInt(1);
            try {
                rs.close();
            }
            catch (SQLException sqlex1) {
                // empty catch block
            }
            return ret;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    protected CloseableResultSet issueRetrieveQuery(PersistenceManager pman) throws PersistenceException, NoSuchObjectException {
        if (this.getKey() == null) {
            throw new PersistenceException("Cannot retrieve object if key is not set");
        }
        String sql = MessageFormat.format(RETRIEVE_OBJECT_QUERY, this.getStorageTableName());
        try {
            PreparedStatement stmt = pman.getPreparedStatement(sql);
            stmt.setLong(1, this.getKey().getId());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new NoSuchObjectException(this, this.getKey());
            }
            return new CloseableResultSet(null, rs);
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    protected DBObjectId getAdditionalPropertyConnectionId() {
        return this.m_additionalPropertyConnectionId;
    }

    protected void setAdditionalPropertyConnectionId(DBObjectId additionalPropertyConnectionId) {
        if (this.m_additionalPropertyConnectionId == null) {
            if (additionalPropertyConnectionId == null) {
                throw new IllegalArgumentException("Cannot set the additional property connection id to null");
            }
            this.m_additionalPropertyConnectionId = additionalPropertyConnectionId;
        } else if (!this.m_additionalPropertyConnectionId.equals(additionalPropertyConnectionId)) {
            throw new IllegalStateException("Attempt to change additional property connection id");
        }
    }

    public String getObjectType() {
        return this.getStorageTableName();
    }
}

