/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public abstract class PersistableObjectIterator
implements CloseableIterator {
    protected ResultSet m_resultSet;
    private PreparedStatement m_preparedStatement;
    protected Class m_class;
    private DBObjectId m_nextId;
    private PersistenceManager m_persistenceManager;

    public PersistableObjectIterator(Class persistableObjectClass, PersistenceManager pman) {
        this.setPersistenceManager(pman);
        this.m_class = persistableObjectClass;
        String tableName = this.getTableName();
        if (tableName == null) {
            throw new IllegalStateException("Invalid class");
        }
    }

    protected String getTableName() {
        String ret = null;
        try {
            Field f = this.m_class.getField("TABLE_NAME");
            ret = f.get(new Object()).toString();
        }
        catch (Exception e) {
            return null;
        }
        return ret;
    }

    public boolean hasNext() {
        if (this.m_preparedStatement == null) {
            try {
                this.m_preparedStatement = this.getPreparedStatement();
                this.m_resultSet = this.m_preparedStatement.executeQuery();
            }
            catch (SQLException sqlex) {
                return false;
            }
        }
        if (this.m_resultSet == null) {
            return false;
        }
        try {
            if (this.m_resultSet.next()) {
                this.m_nextId = new DBObjectId(this.m_resultSet.getLong(1));
                return true;
            }
            CloseableResultSet crs = new CloseableResultSet(null, this.m_resultSet);
            crs.close();
            return false;
        }
        catch (SQLException sqlex) {
            this.m_resultSet = null;
            this.m_preparedStatement = null;
            return false;
        }
    }

    public Object next() {
        Object newObject = null;
        if (this.m_nextId == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        Class[] params = new Class[]{PersistenceManager.class, DBObjectId.class};
        try {
            Method m = this.m_class.getMethod("retrieveExistingInstance", params);
            Object[] args = new Object[]{this.getPersistenceManager(), this.m_nextId};
            newObject = m.invoke(null, args);
        }
        catch (Exception e) {
            throw new NoSuchElementException(e.getMessage());
        }
        this.m_nextId = null;
        return newObject;
    }

    public void remove() {
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    public void close() {
        CloseableResultSet.close(null, this.m_resultSet);
        this.m_resultSet = null;
    }

    public void closePreparedStatement() {
        CloseableResultSet.close(this.m_preparedStatement, null);
        this.m_preparedStatement = null;
    }

    protected abstract PreparedStatement getPreparedStatement() throws SQLException;
}

