/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.dbtools.metadata.persistence.CloseableResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceManager {
    private Connection m_conn;
    private Hashtable<String, PreparedStatement> m_preparedStatementCache;
    private int m_cacheHitCount;
    private int m_cacheMissCount;

    public PersistenceManager(Connection conn) {
        this.m_conn = conn;
        this.m_preparedStatementCache = new Hashtable();
        this.m_cacheHitCount = 0;
        this.m_cacheMissCount = 0;
    }

    public Connection getConn() {
        return this.m_conn;
    }

    public void commit() throws SQLException {
        this.m_conn.commit();
    }

    public void rollback() throws SQLException {
        this.m_conn.rollback();
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        return this.getPreparedStatement(sql, null);
    }

    public PreparedStatement getPreparedStatement(String sql, String[] retKeys) throws SQLException {
        PreparedStatement stmt = this.getPreparedStatementCache().get(sql);
        if (stmt == null) {
            ++this.m_cacheMissCount;
            stmt = retKeys == null ? this.getConn().prepareStatement(sql) : this.getConn().prepareStatement(sql, retKeys);
            this.m_preparedStatementCache.put(sql, stmt);
        } else {
            ++this.m_cacheHitCount;
        }
        return stmt;
    }

    public String debugCache() {
        if (this.m_cacheMissCount + this.m_cacheHitCount == 0) {
            return String.format("Cache contains %d items.  Hit count=%d, Miss count=%d", this.m_preparedStatementCache.size(), this.m_cacheHitCount, this.m_cacheMissCount);
        }
        return String.format("Cache contains %d items.  Hit count=%d, Miss count=%d, ratio=%2.4f%%", this.m_preparedStatementCache.size(), this.m_cacheHitCount, this.m_cacheMissCount, Float.valueOf(100.0f * (float)this.m_cacheHitCount / (float)(this.m_cacheMissCount + this.m_cacheHitCount)));
    }

    public void releaseCache() {
        for (PreparedStatement stmt : this.m_preparedStatementCache.values()) {
            CloseableResultSet.close(stmt, null);
        }
        this.m_preparedStatementCache = null;
        this.m_cacheHitCount = 0;
        this.m_cacheMissCount = 0;
    }

    private Hashtable<String, PreparedStatement> getPreparedStatementCache() {
        if (this.m_preparedStatementCache == null) {
            this.m_preparedStatementCache = new Hashtable();
            this.m_cacheHitCount = 0;
            this.m_cacheMissCount = 0;
        }
        return this.m_preparedStatementCache;
    }
}

