/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.ConstraintsIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.ForeignKeyConstraintsIterator;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdDerivative;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdGroupMember;
import oracle.dbtools.metadata.persistence.MdGroupPrivilege;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdOtherObject;
import oracle.dbtools.metadata.persistence.MdPackage;
import oracle.dbtools.metadata.persistence.MdPrivilege;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSequence;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdSynonym;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTablespace;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserDefinedDataType;
import oracle.dbtools.metadata.persistence.MdUserPrivilege;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.MgvAllSchemasRec;
import oracle.dbtools.metadata.persistence.MgvAllStoredProgramsRec;
import oracle.dbtools.metadata.persistence.MgvAllTableTriggersRec;
import oracle.dbtools.metadata.persistence.MgvAllTablesRec;
import oracle.dbtools.metadata.persistence.MgvAllViewTriggersRec;
import oracle.dbtools.metadata.persistence.MgvAllViewsRec;
import oracle.dbtools.metadata.persistence.MgvIterator;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.OrderedColumnsIterator;
import oracle.dbtools.metadata.persistence.PersistableMasterChildren;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.SchemaTableTriggersIterator;
import oracle.dbtools.metadata.persistence.TablesWithIdentityColumnsIterator;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.jdbc.OracleCallableStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistenceUtility {
    private PersistenceManager m_persistenceManager;
    private static Hashtable<PersistenceManager, PersistenceUtility> s_allUtils = new Hashtable();

    public static PersistenceUtility getInstance(PersistenceManager pman) {
        PersistenceUtility p = s_allUtils.get(pman);
        if (p == null) {
            p = new PersistenceUtility(pman);
            s_allUtils.put(pman, p);
        }
        return p;
    }

    private PersistenceUtility(PersistenceManager pman) {
        this.setPersistenceManager(pman);
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    public CloseableIterator<MgvAllCatalogsRec> getCatalogsForConnectionId(DBObjectId connectionId, MigrationObjectFilterList filterList) throws PersistenceException {
        MigrationObjectFilter filter;
        String sql = "SELECT * FROM MGV_ALL_CATALOGS WHERE CONNECTION_ID = ?";
        String filterCondition = null;
        if (filterList != null && (filter = filterList.getFilterForType("MD_CATALOGS")) != null) {
            filterCondition = filter.toConditionClause("CATALOG_NAME", "CATALOG_ID");
        }
        if (filterCondition != null) {
            sql = sql + " AND " + filterCondition;
        }
        MgvIterator ret = new MgvIterator(MgvAllCatalogsRec.class, sql, connectionId, this.getPersistenceManager());
        return ret;
    }

    public CloseableIterator<MgvAllCatalogsRec> getCatalogsForConnectionId(DBObjectId connectionId) throws PersistenceException {
        return this.getCatalogsForConnectionId(connectionId, null);
    }

    public CloseableIterator getSchemasforCatalogId(DBObjectId catalogId, MigrationObjectFilterList filterList) throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MdSchema.class, "CATALOG_ID_FK  ", catalogId, this.getPersistenceManager(), filterList);
        return ret;
    }

    public int getSchemaCountForConnectionId(DBObjectId connectionId, MigrationObjectFilterList filterList) throws PersistenceException {
        int filter22;
        String sql = "SELECT COUNT(*) FROM MGV_ALL_SCHEMA WHERE CONNECTION_ID = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            MigrationObjectFilter filter22;
            if (filterList != null && (filter22 = filterList.getFilterForType("MD_SCHEMAS")) != null) {
                sql = sql + " AND " + filter22.toConditionClause("SCHEMA_NAME", "SCHEMA_ID");
            }
            stmt = this.getPersistenceManager().getPreparedStatement(sql);
            stmt.setLong(1, connectionId.getId());
            rs = stmt.executeQuery();
            rs.next();
            filter22 = rs.getInt(1);
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
        return filter22;
    }

    public CloseableIterator getSchemasforCatalogId(DBObjectId catalogId) throws PersistenceException {
        return this.getSchemasforCatalogId(catalogId, null);
    }

    public CloseableIterator getUsersforSchemaId(DBObjectId schemaId, MigrationObjectFilterList filterList) throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MdUser.class, "SCHEMA_ID_FK  ", schemaId, this.getPersistenceManager(), filterList);
        return ret;
    }

    public boolean userExistsInSchema(DBObjectId schemaId, String username) throws PersistenceException {
        ResultSet rs;
        block4: {
            boolean bl;
            PreparedStatement stmt = null;
            rs = null;
            try {
                stmt = this.getPersistenceManager().getPreparedStatement("SELECT COUNT(1) FROM MD_USERS WHERE SCHEMA_ID_FK = ? AND USERNAME = ?");
                stmt.setLong(1, schemaId.getId());
                stmt.setString(2, username);
                rs = stmt.executeQuery();
                rs.next();
                int count = rs.getInt(1);
                if (count <= 0) break block4;
                bl = true;
            }
            catch (SQLException sqlex) {
                try {
                    throw new PersistenceException(sqlex);
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close(null, rs);
                    throw throwable;
                }
            }
            CloseableResultSet.close(null, rs);
            return bl;
        }
        CloseableResultSet.close(null, rs);
        return false;
    }

    public CloseableIterator getUsersforSchemaId(DBObjectId schemaId) throws PersistenceException {
        return this.getUsersforSchemaId(schemaId, null);
    }

    public CloseableIterator getAllCapturedConnections() throws PersistenceException {
        PersistableMasterChildren ret = null;
        if (this.getPersistenceManager().getConn() != null) {
            ret = new PersistableMasterChildren(MdConnection.class, "NVL2(TYPE, 2, 1)", new DBObjectId(1L), this.getPersistenceManager(), null);
        }
        return ret;
    }

    public CloseableIterator<MgvAllSchemasRec> getSchemasForConnectionId(DBObjectId connectionId, MigrationObjectFilterList filterList) throws PersistenceException {
        MigrationObjectFilter filter;
        String sql = "SELECT * FROM MGV_ALL_SCHEMA WHERE CONNECTION_ID = ?";
        if (filterList != null && (filter = filterList.getFilterForType("MD_SCHEMAS")) != null) {
            sql = sql + " AND " + filter.toConditionClause("SCHEMA_NAME", "SCHEMA_ID");
        }
        MgvIterator ret = new MgvIterator(MgvAllSchemasRec.class, sql, connectionId, this.getPersistenceManager());
        return ret;
    }

    public CloseableIterator<MgvAllSchemasRec> getSchemasForConnectionId(DBObjectId connectionId) throws PersistenceException {
        return this.getSchemasForConnectionId(connectionId, null);
    }

    public CloseableIterator<MgvAllTablesRec> getTablesForConnectionId(DBObjectId connectionId, MigrationObjectFilterList filterList) throws PersistenceException {
        MigrationObjectFilter filter;
        String sql = "SELECT * FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?";
        if (filterList != null && (filter = filterList.getFilterForType("MD_TABLES")) != null) {
            sql = sql + " AND " + filter.toWhereConditionForMigrationRepository();
        }
        MgvIterator ret = new MgvIterator(MgvAllTablesRec.class, sql, connectionId, this.getPersistenceManager());
        return ret;
    }

    public CloseableIterator<MgvAllTablesRec> getTablesForConnectionId(DBObjectId connectionId) throws PersistenceException {
        return this.getTablesForConnectionId(connectionId, null);
    }

    public MgvAllTablesRec getTablesForTableId(DBObjectId connectionId) throws PersistenceException {
        MgvIterator list = new MgvIterator(MgvAllTablesRec.class, "SELECT * FROM MGV_ALL_TABLES WHERE TABLE_ID = ?", connectionId, this.getPersistenceManager());
        if (list.hasNext()) {
            return (MgvAllTablesRec)list.next();
        }
        return null;
    }

    public CloseableIterator<MgvAllTableTriggersRec> getTableTriggersForConnectionId(DBObjectId connectionId) throws PersistenceException {
        MgvIterator ret = new MgvIterator(MgvAllTableTriggersRec.class, "SELECT * FROM MGV_ALL_TABLE_TRIGGERS WHERE CONNECTION_ID = ?", connectionId, this.getPersistenceManager());
        return ret;
    }

    public CloseableIterator<MgvAllViewTriggersRec> getViewTriggersForConnectionId(DBObjectId connectionId) throws PersistenceException {
        MgvIterator ret = new MgvIterator(MgvAllViewTriggersRec.class, "SELECT * FROM MGV_ALL_VIEW_TRIGGERS WHERE CONNECTION_ID = ?", connectionId, this.getPersistenceManager());
        return ret;
    }

    public CloseableIterator<MgvAllStoredProgramsRec> getStoredProgramsForConnectionId(DBObjectId connectionId) throws PersistenceException {
        MgvIterator ret = new MgvIterator(MgvAllStoredProgramsRec.class, "SELECT * FROM MGV_ALL_STORED_PROGRAMS WHERE CONNECTION_ID = ? ORDER BY STORED_PROGRAM_NAME", connectionId, this.getPersistenceManager());
        return ret;
    }

    public CloseableIterator<MgvAllStoredProgramsRec> getStoredProgramsForSchemaId(DBObjectId schemaId, MigrationObjectFilterList filterList) throws PersistenceException {
        MigrationObjectFilter filter;
        String filterCondition = null;
        String sql = "SELECT * FROM MGV_ALL_STORED_PROGRAMS WHERE SCHEMA_ID = ?";
        if (filterList != null && (filter = filterList.getFilterForType("MD_STORED_PROGRAMS")) != null) {
            filterCondition = filter.toConditionClause("STORED_PROGRAM_NAME", "STORED_PROGRAM_ID");
        }
        if (filterCondition != null) {
            sql = sql + " AND " + filterCondition;
        }
        MgvIterator ret = new MgvIterator(MgvAllStoredProgramsRec.class, sql, schemaId, this.getPersistenceManager());
        return ret;
    }

    public CloseableIterator<MgvAllViewsRec> getViewsForConnectionId(DBObjectId connectionId) throws PersistenceException {
        MgvIterator ret = new MgvIterator(MgvAllViewsRec.class, "SELECT * FROM MGV_ALL_VIEWS WHERE CONNECTION_ID = ?", connectionId, this.getPersistenceManager());
        return ret;
    }

    public CloseableIterator getColumnsForTableId(DBObjectId tableId) throws PersistenceException {
        OrderedColumnsIterator ret = new OrderedColumnsIterator(this.getPersistenceManager(), tableId);
        return ret;
    }

    public CloseableIterator getTablesForSchemaId(DBObjectId schemaId, MigrationObjectFilterList filterList) throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MdTable.class, "SCHEMA_ID_FK", schemaId, this.getPersistenceManager(), filterList);
        return ret;
    }

    public CloseableIterator getTablesForSchemaId(DBObjectId schemaId) throws PersistenceException {
        return this.getTablesForSchemaId(schemaId, null);
    }

    public CloseableIterator getViewsForSchemaId(DBObjectId schemaId, MigrationObjectFilterList filterList) throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MdView.class, "SCHEMA_ID_FK", schemaId, this.getPersistenceManager(), filterList);
        return ret;
    }

    public CloseableIterator getViewsForSchemaId(DBObjectId schemaId) throws PersistenceException {
        return this.getViewsForSchemaId(schemaId, null);
    }

    public CloseableIterator getConstraintsForTableId(DBObjectId tableId, MigrationObjectFilterList filterList) throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MdConstraint.class, "TABLE_ID_FK", tableId, this.getPersistenceManager(), filterList);
        return ret;
    }

    public CloseableIterator getForeignKeyConstraintsForSchemaId(DBObjectId schemaId) throws PersistenceException {
        return new ForeignKeyConstraintsIterator(this.getPersistenceManager(), schemaId);
    }

    public CloseableIterator getConstraintsForConnectionId(DBObjectId connectionId) throws PersistenceException {
        ConstraintsIterator ret = new ConstraintsIterator(this.getPersistenceManager(), connectionId, null, null);
        return ret;
    }

    public CloseableIterator getConstraintsForTableId(DBObjectId tableId) throws PersistenceException {
        return this.getConstraintsForTableId(tableId, null);
    }

    public CloseableIterator getConstraintDetails(DBObjectId constraintId) throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MdConstraintDetail.class, "CONSTRAINT_ID_FK", constraintId, this.getPersistenceManager(), null);
        return ret;
    }

    public CloseableIterator getIndexesForTableId(DBObjectId tableId, MigrationObjectFilterList filterList) throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MdIndexe.class, "TABLE_ID_FK", tableId, this.getPersistenceManager(), filterList);
        return ret;
    }

    public CloseableIterator getIndexesForTableId(DBObjectId tableId) throws PersistenceException {
        return this.getIndexesForTableId(tableId, null);
    }

    public CloseableIterator getIndexDetails(DBObjectId indexId) throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MdIndexDetail.class, "INDEX_ID_FK", indexId, this.getPersistenceManager(), null);
        return ret;
    }

    public boolean getHaveIaBlob(MdSchema schema) throws PersistenceException {
        CloseableResultSet crs = null;
        try {
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement(" SELECT A.TABLE_NAME, B.COLUMN_NAME FROM MD_TABLES A,  MD_COLUMNS B WHERE A.SCHEMA_ID_FK = ? AND A.ID = B.TABLE_ID_FK AND UPPER(B.COLUMN_TYPE) = 'BLOB' ");
            stmt.setLong(1, schema.getKey().getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    public DBObjectId getIdForColumn(DBObjectId tableId, String columnName) throws PersistenceException {
        CloseableResultSet crs = null;
        try {
            DBObjectId ret;
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_COLUMNS WHERE TABLE_ID_FK=? AND UPPER(COLUMN_NAME)=UPPER(?)");
            stmt.setLong(1, tableId.getId());
            stmt.setString(2, columnName);
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            rs.next();
            DBObjectId dBObjectId = ret = new DBObjectId(rs.getLong(1));
            return dBObjectId;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    public DBObjectId getIdForTable(DBObjectId schemaId, String tableName) throws PersistenceException {
        CloseableResultSet crs = null;
        try {
            DBObjectId ret;
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_TABLES WHERE SCHEMA_ID_FK=? AND UPPER(TABLE_NAME)=UPPER(?)");
            stmt.setLong(1, schemaId.getId());
            stmt.setString(2, tableName);
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            rs.next();
            DBObjectId dBObjectId = ret = new DBObjectId(rs.getLong(1));
            return dBObjectId;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    public DBObjectId getIdForStoredProgram(DBObjectId schemaId, String storedProgramName) throws PersistenceException {
        CloseableResultSet crs = null;
        try {
            DBObjectId ret;
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_STORED_PROGRAMS WHERE SCHEMA_ID_FK=? AND UPPER(NAME)=UPPER(?)");
            stmt.setLong(1, schemaId.getId());
            stmt.setString(2, storedProgramName);
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            rs.next();
            DBObjectId dBObjectId = ret = new DBObjectId(rs.getLong(1));
            return dBObjectId;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    public DBObjectId getIdForView(DBObjectId schemaId, String viewName) throws PersistenceException {
        CloseableResultSet crs = null;
        try {
            DBObjectId ret;
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_VIEWS WHERE SCHEMA_ID_FK=? AND UPPER(VIEW_NAME)=UPPER(?)");
            stmt.setLong(1, schemaId.getId());
            stmt.setString(2, viewName);
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            rs.next();
            DBObjectId dBObjectId = ret = new DBObjectId(rs.getLong(1));
            return dBObjectId;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    public DBObjectId getIdForSchema(DBObjectId catalogId, String schemaName) throws PersistenceException {
        DBObjectId dBObjectId;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBObjectId ret = null;
        try {
            stmt = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_SCHEMAS WHERE CATALOG_ID_FK=? AND UPPER(NAME)=UPPER(?)");
            stmt.setLong(1, catalogId.getId());
            stmt.setString(2, schemaName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ret = new DBObjectId(rs.getLong(1));
            }
            dBObjectId = ret;
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
        return dBObjectId;
    }

    public DBObjectId getIdForColumn(DBObjectId tableId, int order) throws PersistenceException {
        DBObjectId dBObjectId;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            DBObjectId ret;
            stmt = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_COLUMNS WHERE TABLE_ID_FK=? AND COLUMN_ORDER=?");
            stmt.setLong(1, tableId.getId());
            stmt.setInt(2, order);
            rs = stmt.executeQuery();
            rs.next();
            dBObjectId = ret = new DBObjectId(rs.getLong(1));
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
        return dBObjectId;
    }

    public DBObjectId getIdForUser(DBObjectId schemaId, String userName) throws PersistenceException {
        CloseableResultSet crs = null;
        try {
            DBObjectId ret;
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_USERS WHERE SCHEMA_ID_FK=? AND UPPER(USERNAME)=UPPER(?)");
            stmt.setLong(1, schemaId.getId());
            stmt.setString(2, userName);
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            rs.next();
            DBObjectId dBObjectId = ret = new DBObjectId(rs.getLong(1));
            return dBObjectId;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    public CloseableIterator getAllConvertedConnections() throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MdConnection.class, "NVL2(TYPE, 1, 2)", new DBObjectId(1L), this.getPersistenceManager(), null);
        return ret;
    }

    public CloseableIterator getCheckConstraintsForConectionId(DBObjectId connectionId, MigrationObjectFilterList filterList) throws PersistenceException {
        ConstraintsIterator ret = new ConstraintsIterator(this.getPersistenceManager(), connectionId, "CHECK", filterList);
        return ret;
    }

    public CloseableIterator getTablesWithIdentityColsForConnectionId(DBObjectId connectionId) throws PersistenceException {
        TablesWithIdentityColumnsIterator ret = new TablesWithIdentityColumnsIterator(this.getPersistenceManager(), connectionId);
        return ret;
    }

    public CloseableIterator<MdSequence> getSequencesForSchemaId(DBObjectId schemaId, MigrationObjectFilterList filterList) throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MdSequence.class, "SCHEMA_ID_FK", schemaId, this.getPersistenceManager(), filterList);
        return ret;
    }

    public CloseableIterator<MdGroup> getGroupsForSchemaId(DBObjectId schemaId, MigrationObjectFilterList filterList) throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MdGroup.class, "SCHEMA_ID_FK", schemaId, this.getPersistenceManager(), filterList);
        return ret;
    }

    public CloseableIterator<MdSequence> getSequencesForSchemaId(DBObjectId schemaId) throws PersistenceException {
        return this.getSequencesForSchemaId(schemaId, null);
    }

    public CloseableIterator<MdTrigger> getTriggersForSchemaId(DBObjectId schemaId, MigrationObjectFilterList filterList) throws PersistenceException {
        SchemaTableTriggersIterator ret = new SchemaTableTriggersIterator(this.getPersistenceManager(), schemaId, filterList);
        return ret;
    }

    public CloseableIterator<MdTrigger> getTriggersForSchemaId(DBObjectId schemaId) throws PersistenceException {
        return this.getTriggersForSchemaId(schemaId, null);
    }

    public DBObjectId getSchemaIdForUser(DBObjectId catalogId, String userName) throws PersistenceException {
        DBObjectId dBObjectId;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            DBObjectId ret;
            stmt = this.getPersistenceManager().getPreparedStatement("SELECT U.SCHEMA_ID_FK FROM MD_USERS U, MD_SCHEMAS S WHERE S.ID = U.SCHEMA_ID_FK AND S.CATALOG_ID_FK=? AND U.USERNAME=?");
            stmt.setLong(1, catalogId.getId());
            stmt.setString(2, userName);
            rs = stmt.executeQuery();
            rs.next();
            dBObjectId = ret = new DBObjectId(rs.getLong(1));
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
        return dBObjectId;
    }

    public DBObjectId getSchemaIdForGroup(DBObjectId catalogId, String groupName) throws PersistenceException {
        DBObjectId dBObjectId;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            DBObjectId ret;
            stmt = this.getPersistenceManager().getPreparedStatement("SELECT G.SCHEMA_ID_FK FROM MD_GROUPS G, MD_SCHEMAS S WHERE S.ID = G.SCHEMA_ID_FK AND S.CATALOG_ID_FK=? AND G.GROUP_NAME=?");
            stmt.setLong(1, catalogId.getId());
            stmt.setString(2, groupName);
            rs = stmt.executeQuery();
            rs.next();
            dBObjectId = ret = new DBObjectId(rs.getLong(1));
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
        return dBObjectId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateConnectionStatistics(MdConnection mdconnection) throws PersistenceException {
        OracleCallableStatement stmt = null;
        try {
            stmt = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.GATHERCONNECTIONSTATS(?)}");
            stmt.registerOutParameter(1, 4);
            stmt.setLong(2, mdconnection.getKey().getId());
            stmt.execute();
            if (stmt == null) return;
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                if (stmt == null) throw throwable;
                CloseableResultSet.close(stmt, null);
                throw throwable;
            }
        }
        CloseableResultSet.close((Statement)stmt, null);
        return;
    }

    public PersistableObject loadPersistableObject(DBObjectId objectId, String type) throws PersistenceException, NoSuchObjectException {
        PersistableObject obj = null;
        if (type.equals("MD_ADDITIONAL_PROPERTIES")) {
            obj = null;
        } else if (type.equals("MD_CATALOGS")) {
            obj = MdCatalog.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_COLUMNS")) {
            obj = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_CONNECTIONS")) {
            obj = MdConnection.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_CONSTRAINT_DETAILS")) {
            obj = MdConstraintDetail.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_CONSTRAINTS")) {
            obj = MdConstraint.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_DERIVATIVES")) {
            obj = MdDerivative.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_GROUPS")) {
            obj = MdGroup.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_GROUP_MEMBERS")) {
            obj = MdGroupMember.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_GROUP_PRIVILEGES")) {
            obj = MdGroupPrivilege.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_INDEX_DETAILS")) {
            obj = MdIndexDetail.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_INDEXES")) {
            obj = MdIndexe.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_OTHER_OBJECTS")) {
            obj = MdOtherObject.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_PACKAGES")) {
            obj = MdPackage.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_PRIVILEGES")) {
            obj = MdPrivilege.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_PROJECTS")) {
            obj = MdProject.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_REPOVERSIONS")) {
            obj = null;
        } else if (type.equals("MD_SCHEMAS")) {
            obj = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_SEQUENCES")) {
            obj = MdSequence.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_STORED_PROGRAMS")) {
            obj = MdStoredProgram.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_SYNONYMS")) {
            obj = MdSynonym.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_TABLES")) {
            obj = MdTable.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_TABLESPACES")) {
            obj = MdTablespace.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_TRIGGERS")) {
            obj = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_USER_DEFINED_DATA_TYPES")) {
            obj = MdUserDefinedDataType.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_USERS")) {
            obj = MdUser.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_USER_PRIVILEGES")) {
            obj = MdUserPrivilege.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        } else if (type.equals("MD_VIEWS")) {
            obj = MdView.retrieveExistingInstance(this.getPersistenceManager(), objectId);
        }
        return obj;
    }

    public String[] getAllDataTypesForConnection(DBObjectId connectionId) throws PersistenceException {
        ArrayList<String> results = new ArrayList<String>();
        CloseableResultSet crs = null;
        try {
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement("SELECT DISTINCT(COLUMN_TYPE) FROM MD_COLUMNS WHERE TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?)");
            stmt.setLong(1, connectionId.getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            while (rs.next()) {
                results.add(rs.getString(1));
            }
            String[] stringArray = results.toArray(new String[results.size()]);
            return stringArray;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    public String getHostForConnection(DBObjectId connectionId) throws PersistenceException {
        String result = new String();
        CloseableResultSet crs = null;
        try {
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement("SELECT HOST FROM MD_CONNECTIONS WHERE Id=?");
            stmt.setLong(1, connectionId.getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            while (rs.next()) {
                result = rs.getString(1);
            }
            String string = result;
            return string;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    public PersistableObject loadParentPersistableObject(PersistableObject poObject) throws PersistenceException, NoSuchObjectException {
        Object parentObj = null;
        String type = poObject.getObjectType();
        parentObj = type.equals("MD_CATALOGS") ? MdConnection.retrieveExistingInstance(this.getPersistenceManager(), ((MdCatalog)poObject).getConnectionId()) : (type.equals("MD_COLUMNS") ? MdTable.retrieveExistingInstance(this.getPersistenceManager(), ((MdColumn)poObject).getTableId()) : (type.equals("MD_CONNECTIONS") ? null : (type.equals("MD_CONSTRAINTS") ? MdTable.retrieveExistingInstance(this.getPersistenceManager(), ((MdConstraint)poObject).getTableId()) : (type.equals("MD_SCHEMAS") ? MdCatalog.retrieveExistingInstance(this.getPersistenceManager(), ((MdSchema)poObject).getCatalogId()) : (type.equals("MD_STORED_PROGRAMS") ? MdSchema.retrieveExistingInstance(this.getPersistenceManager(), ((MdStoredProgram)poObject).getSchemaId()) : (type.equals("MD_SYNONYMS") ? MdSchema.retrieveExistingInstance(this.getPersistenceManager(), ((MdSynonym)poObject).getSchemaId()) : (type.equals("MD_TABLES") ? MdSchema.retrieveExistingInstance(this.getPersistenceManager(), ((MdTable)poObject).getSchemaId()) : (type.equals("MD_TRIGGERS") ? (((MdTrigger)poObject).getTriggerOnFlag().equals("T") ? MdTable.retrieveExistingInstance(this.getPersistenceManager(), ((MdTrigger)poObject).getTableOrViewId()) : MdView.retrieveExistingInstance(this.getPersistenceManager(), ((MdTrigger)poObject).getTableOrViewId())) : (type.equals("MD_VIEWS") ? MdSchema.retrieveExistingInstance(this.getPersistenceManager(), ((MdView)poObject).getSchemaId()) : (type.equals("MD_SEQUENCES") ? MdSchema.retrieveExistingInstance(this.getPersistenceManager(), ((MdSequence)poObject).getSchemaId()) : (type.equals("MD_INDEXES") ? MdSchema.retrieveExistingInstance(this.getPersistenceManager(), ((MdIndexe)poObject).getTableId()) : null)))))))))));
        return parentObj;
    }

    public DBObjectId getIdForCatalog(DBObjectId connectionId, String catalogName) throws PersistenceException {
        DBObjectId dBObjectId;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            DBObjectId ret;
            stmt = this.getPersistenceManager().getPreparedStatement("SELECT ID FROM MD_CATALOGS WHERE CONNECTION_ID_FK=?  AND UPPER(CATALOG_NAME) =UPPER(?)");
            stmt.setLong(1, connectionId.getId());
            stmt.setString(2, catalogName);
            rs = stmt.executeQuery();
            rs.next();
            dBObjectId = ret = new DBObjectId(rs.getLong(1));
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
        return dBObjectId;
    }

    public MgvAllStoredProgramsRec getStoredProgramForProgramId(DBObjectId programId) throws PersistenceException {
        MgvIterator list = new MgvIterator(MgvAllStoredProgramsRec.class, "SELECT * FROM MGV_ALL_STORED_PROGRAMS WHERE STORED_PROGRAM_ID = ?", programId, this.getPersistenceManager());
        if (list.hasNext()) {
            return (MgvAllStoredProgramsRec)list.next();
        }
        return null;
    }

    public MgvAllViewsRec getViewRecordForViewId(DBObjectId viewId) throws PersistenceException {
        MgvIterator list = new MgvIterator(MgvAllViewsRec.class, "SELECT * FROM MGV_ALL_VIEWS WHERE VIEW_ID = ?", viewId, this.getPersistenceManager());
        if (list.hasNext()) {
            return (MgvAllViewsRec)list.next();
        }
        return null;
    }

    public MdPackage getEmulationPackageForSchema(DBObjectId schemaId) throws PersistenceException, NoSuchObjectException {
        MdPackage pkgId2;
        ResultSet rs;
        block5: {
            String queryPkg = " SELECT A.ID FROM MD_PACKAGES  A, MD_ADDITIONAL_PROPERTIES B WHERE A.ID = B.REF_ID_FK AND B.PROP_KEY = 'MIGRATIONEMULATION' AND B.VALUE = 'Y' AND A.SCHEMA_ID_FK = ?";
            PreparedStatement stmt = null;
            rs = null;
            stmt = this.getPersistenceManager().getPreparedStatement(queryPkg);
            stmt.setLong(1, schemaId.getId());
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            DBObjectId pkgId2 = new DBObjectId(rs.getLong(1));
            MdPackage mdPackage = MdPackage.retrieveExistingInstance(this.getPersistenceManager(), pkgId2);
            CloseableResultSet.close(null, rs);
            return mdPackage;
        }
        try {
            pkgId2 = null;
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
        return pkgId2;
    }

    public MdSynonym getEmulationSynonymForSchema(DBObjectId schemaId) throws PersistenceException, NoSuchObjectException {
        MdSynonym synonymId2;
        ResultSet rs;
        block5: {
            String querySynonym = "SELECT A.ID FROM MD_SYNONYMS A, MD_ADDITIONAL_PROPERTIES B WHERE A.ID = B.REF_ID_FK AND B.PROP_KEY = 'MIGRATIONEMULATION' AND B.VALUE = 'Y' AND A.SCHEMA_ID_FK = ?";
            PreparedStatement stmt = null;
            rs = null;
            stmt = this.getPersistenceManager().getPreparedStatement(querySynonym);
            stmt.setLong(1, schemaId.getId());
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            DBObjectId synonymId2 = new DBObjectId(rs.getLong(1));
            MdSynonym mdSynonym = MdSynonym.retrieveExistingInstance(this.getPersistenceManager(), synonymId2);
            CloseableResultSet.close(null, rs);
            return mdSynonym;
        }
        try {
            synonymId2 = null;
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
        return synonymId2;
    }

    public DBObjectId getIdForTrigger(DBObjectId schemaId, String triggerName) throws PersistenceException {
        CloseableResultSet crs = null;
        try {
            DBObjectId ret;
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement(" SELECT TRIGGER_ID FROM MGV_ALL_VIEW_TRIGGERS  WHERE UPPER(TRIGGER_NAME)=UPPER(?) AND SCHEMA_ID =?  UNION  SELECT TRIGGER_ID FROM MGV_ALL_TABLE_TRIGGERS   WHERE UPPER(TRIGGER_NAME)=UPPER(?) AND SCHEMA_ID =? ");
            stmt.setString(1, triggerName);
            stmt.setLong(2, schemaId.getId());
            stmt.setString(3, triggerName);
            stmt.setLong(4, schemaId.getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            rs.next();
            DBObjectId dBObjectId = ret = new DBObjectId(rs.getLong(1));
            return dBObjectId;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    public ArrayList<String> getEmulationFuncsForSchema(DBObjectId schemaId) throws PersistenceException {
        ArrayList<String> result = new ArrayList<String>();
        CloseableResultSet crs = null;
        try {
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement(" SELECT DISTINCT(child_name)  FROM md_migr_weakdep WHERE schema_id_fk =?");
            stmt.setLong(1, schemaId.getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    public ArrayList<String> getEmulationFuncsForConnection(DBObjectId connectionId) throws PersistenceException {
        ArrayList<String> result = new ArrayList<String>();
        CloseableResultSet crs = null;
        try {
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement(" SELECT DISTINCT(child_name) FROM md_migr_weakdep WHERE connection_id_fk =?");
            stmt.setLong(1, connectionId.getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            while (rs.next()) {
                result.add(rs.getString(1));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    public static boolean isColumnNullable(MdColumn col) {
        return col.getNullable().equalsIgnoreCase("Y");
    }
}

