/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.metadata.persistence.BlobHelper;

public class PrepareBlobHelper {
    public static final int OVERSIZE = 20000;
    private byte[] m_permanentByteStore = null;
    private File m_fileStore = null;
    private BufferedOutputStream m_bufferedOutputStream = null;
    private int m_totalLength = 0;
    private boolean m_inputStreamIsNull = false;
    private int m_overSize = 20000;

    public PrepareBlobHelper() {
    }

    public PrepareBlobHelper(int overSize) {
        this.m_overSize = overSize;
    }

    public void setInputStream(InputStream is) throws IOException {
        int currentSize = 0;
        if (is != null) {
            BufferedInputStream bis = new BufferedInputStream(is);
            if (this.m_permanentByteStore == null) {
                this.m_permanentByteStore = new byte[this.m_overSize];
            }
            boolean exit = false;
            int bytesGot = 0;
            while (!exit) {
                bytesGot = bis.read(this.m_permanentByteStore, currentSize, this.m_overSize - currentSize);
                if (bytesGot == -1 || bytesGot + currentSize == this.m_overSize) {
                    exit = true;
                    continue;
                }
                currentSize += bytesGot;
            }
            if (bytesGot == -1) {
                this.m_totalLength = currentSize;
                return;
            }
            this.m_fileStore = File.createTempFile("Blobstore", ".tmp");
            this.m_fileStore.deleteOnExit();
            this.m_bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.m_fileStore));
            this.m_bufferedOutputStream.write(this.m_permanentByteStore, 0, this.m_overSize);
            this.m_totalLength = this.m_overSize;
            while (true) {
                exit = false;
                currentSize = 0;
                while (!exit) {
                    bytesGot = bis.read(this.m_permanentByteStore, currentSize, this.m_overSize - currentSize);
                    if (bytesGot == -1 || bytesGot + currentSize == this.m_overSize) {
                        exit = true;
                        continue;
                    }
                    currentSize += bytesGot;
                }
                if (bytesGot == -1) {
                    this.m_totalLength += currentSize;
                    this.m_bufferedOutputStream.write(this.m_permanentByteStore, 0, currentSize);
                    return;
                }
                this.m_totalLength += this.m_overSize;
                this.m_bufferedOutputStream.write(this.m_permanentByteStore, 0, this.m_overSize);
            }
        }
        this.m_inputStreamIsNull = true;
    }

    public BlobHelper getBlobHelper() throws IOException {
        if (this.m_fileStore != null && this.m_bufferedOutputStream != null) {
            this.m_bufferedOutputStream.close();
        }
        if (this.m_inputStreamIsNull) {
            return null;
        }
        if (this.m_fileStore == null) {
            return new BlobHelper(new ByteArrayInputStream(this.m_permanentByteStore, 0, this.m_totalLength), this.m_totalLength);
        }
        BufferedInputStream rdr = new BufferedInputStream(new FileInputStream(this.m_fileStore));
        return new BlobHelper(rdr, this.m_totalLength);
    }

    public void close() throws IOException {
        if (this.m_fileStore != null) {
            this.m_bufferedOutputStream.close();
        }
        if (this.m_fileStore != null) {
            this.m_fileStore.delete();
        }
    }
}

