/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.ide.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBasedPersitableObjectIterator<T extends PersistableObject>
implements CloseableIterator<T> {
    private static final String QUERYBY_PROPERTY = "SELECT DISTINCT(REF_ID_FK), REF_TYPE FROM MD_ADDITIONAL_PROPERTIES WHERE PROP_KEY IN (";
    private static final String CONDITION = ") AND CONNECTION_ID_FK = ?";
    private PersistenceManager m_persistenceManager;
    private String[] m_propertyKeys;
    private PreparedStatement m_preparedStatement;
    private DBObjectId m_connectionId;
    private ResultSet m_resultSet;
    private DBObjectId m_nextId;
    private String m_nextObjectType;
    private PersistenceUtility m_persistenceUtility;

    public PropertyBasedPersitableObjectIterator(String[] propertyKeys, PersistenceManager pman, DBObjectId connectionId) {
        if (propertyKeys == null || propertyKeys.length == 0) {
            throw new IllegalArgumentException("Property keys invalid");
        }
        this.setPersistenceManager(pman);
        this.setConnectionId(connectionId);
        this.setPersistenceUtility(PersistenceUtility.getInstance(pman));
        this.m_propertyKeys = new String[propertyKeys.length];
        for (int i = 0; i < propertyKeys.length; ++i) {
            this.m_propertyKeys[i] = propertyKeys[i];
        }
    }

    private String generateSQLQuery() {
        StringBuffer sBuf = new StringBuffer(QUERYBY_PROPERTY);
        for (int i = 0; i < this.m_propertyKeys.length; ++i) {
            sBuf.append('?');
            if (i >= this.m_propertyKeys.length - 1) continue;
            sBuf.append(", ");
        }
        sBuf.append(CONDITION);
        return sBuf.toString();
    }

    private PreparedStatement getPreparedStatement() throws SQLException {
        int i;
        String query = this.generateSQLQuery();
        System.out.println(query);
        PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement(this.generateSQLQuery());
        for (i = 0; i < this.m_propertyKeys.length; ++i) {
            stmt.setString(i + 1, this.m_propertyKeys[i]);
        }
        stmt.setLong(i + 1, this.getConnectionId().getId());
        return stmt;
    }

    @Override
    public void close() {
        CloseableResultSet crs = new CloseableResultSet(null, this.m_resultSet);
        crs.close();
        this.m_preparedStatement = null;
        this.m_resultSet = null;
    }

    @Override
    public boolean hasNext() {
        if (this.m_preparedStatement == null) {
            try {
                this.m_preparedStatement = this.getPreparedStatement();
                this.m_resultSet = this.m_preparedStatement.executeQuery();
            }
            catch (SQLException sqlex) {
                return false;
            }
        }
        if (this.m_resultSet == null) {
            return false;
        }
        try {
            if (this.m_resultSet.next()) {
                this.m_nextId = new DBObjectId(this.m_resultSet.getLong(1));
                this.m_nextObjectType = this.m_resultSet.getString(2);
                return true;
            }
            CloseableResultSet crs = new CloseableResultSet(null, this.m_resultSet);
            crs.close();
            return false;
        }
        catch (SQLException sqlex) {
            this.m_resultSet = null;
            this.m_preparedStatement = null;
            return false;
        }
    }

    @Override
    public T next() {
        PersistableObject newObject = null;
        if (this.m_nextId == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            newObject = this.getPersistenceUtility().loadPersistableObject(this.m_nextId, this.m_nextObjectType);
        }
        catch (NoSuchObjectException nsoe) {
            Assert.printStackTrace((Throwable)nsoe);
            throw new NoSuchElementException(nsoe.getMessage());
        }
        catch (PersistenceException pex) {
            Assert.printStackTrace((Throwable)pex);
            throw new NoSuchElementException(pex.getMessage());
        }
        this.m_nextId = null;
        this.m_nextObjectType = null;
        return (T)newObject;
    }

    @Override
    public void remove() {
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    protected DBObjectId getConnectionId() {
        return this.m_connectionId;
    }

    protected void setConnectionId(DBObjectId connectionId) {
        this.m_connectionId = connectionId;
    }

    protected PersistenceUtility getPersistenceUtility() {
        return this.m_persistenceUtility;
    }

    protected void setPersistenceUtility(PersistenceUtility persistenceUtility) {
        this.m_persistenceUtility = persistenceUtility;
    }
}

