/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class TablesWithIdentityColumnsIterator
extends PersistableObjectIterator {
    static final String QUERY_TABLES_WITH_IDENTITY_COLS = "SELECT TABLE_ID_FK from MD_COLUMNS WHERE ID IN (SELECT REF_IF_FK FROM MD_ADDITIONAL_PROPERTIES WHERE PROP_KEY='SEEDVALUE') AND TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?)";
    private DBObjectId m_connectionId;

    public TablesWithIdentityColumnsIterator(PersistenceManager pman, DBObjectId connectionId) {
        super(MdTable.class, pman);
        this.m_connectionId = connectionId;
    }

    protected PreparedStatement getPreparedStatement() throws SQLException {
        PreparedStatement ret = this.getPersistenceManager().getPreparedStatement(QUERY_TABLES_WITH_IDENTITY_COLS);
        ret.setLong(1, this.m_connectionId.getId());
        return ret;
    }
}

