/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.MgvAllSchemasRec;
import oracle.dbtools.metadata.persistence.MgvAllTablesRec;
import oracle.dbtools.metadata.persistence.MgvAllViewsRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureEventListener;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.Capturer;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.ide.util.Assert;

public abstract class CaptureWorker
implements Cancelable {
    public static final String[] CAPTURE_ORDER = new String[]{"MD_CATALOGS", "MD_SCHEMAS", "MD_USERS", "MD_TABLES", "MD_COLUMNS", "MD_INDEXES", "MD_INDEX_DETAILS", "MD_CONSTRAINTS", "MD_CONSTRAINT_DETAILS", "MD_VIEWS", "MD_STORED_PROGRAMS", "MD_TRIGGERS", "MD_GROUPS"};
    protected String m_projectName;
    protected CaptureContext m_context = new CaptureContext();
    protected String m_pluginIdentifier;
    protected MdConnection m_capturedConnection;
    protected MigrationObjectFilterList m_filters;

    public MdConnection getCapturedConnection() {
        return this.m_capturedConnection;
    }

    protected void setCapturedConnection(MdConnection capturedConnection) {
        this.m_capturedConnection = capturedConnection;
    }

    protected String getProjectName() {
        return this.m_projectName;
    }

    protected void setProjectName(String projectName) {
        this.m_projectName = projectName;
    }

    protected abstract Capturer getCapturer();

    public CaptureWorker(String projectName, String pluginIdentifier) {
        this(projectName, pluginIdentifier, null);
    }

    public CaptureWorker(String projectName, String pluginIdentifier, MigrationObjectFilterList filters) {
        this.setProjectName(projectName);
        this.setPluginIdentifier(pluginIdentifier);
        this.setFilters(filters);
    }

    protected MigrationStorer getStorer() {
        return this.getCapturer().getStorer();
    }

    public void addActionListener(CaptureEventListener listener) {
        this.getCaptureAudience().addListener(listener);
    }

    protected void fireListeners(CaptureEvent event) {
        this.getCaptureAudience().fireListeners(event);
    }

    protected void fireStartStore(String objType, String objName) {
        CaptureEvent event = new CaptureEvent(3, objType, objName);
        this.fireListeners(event);
    }

    protected void fireEndStore(String objType, String objName) {
        CaptureEvent event = new CaptureEvent(4, objType, objName);
        this.fireListeners(event);
    }

    public boolean runCapture() throws PersistenceException, CaptureException {
        CaptureEvent captureEvent = new CaptureEvent(6, "", MigrationAddinArb.getString(86));
        this.fireListeners(captureEvent);
        if (this.m_capturedConnection == null) {
            this.storeConnection();
        }
        for (String s : CAPTURE_ORDER) {
            try {
                if (this.shouldCancel()) {
                    CaptureEvent event = new CaptureEvent(-1, s, "");
                    this.fireListeners(event);
                    try {
                        this.getStorer().rollback();
                    }
                    catch (SQLException sqlex) {
                        return false;
                    }
                    return false;
                }
                this.captureType(s);
            }
            catch (SQLException sqlex) {
                throw new CaptureException(sqlex);
            }
        }
        try {
            this.getStorer().commit();
            this.updateStatistics();
            captureEvent.setEventId(7);
            this.fireListeners(captureEvent);
        }
        catch (SQLException sqlex) {
            MigrationLogUtil.logThrowable("MigrationLog.DB_COMMIT_ERROR", "Capture", (Throwable)sqlex);
            Assert.printStackTrace((Throwable)sqlex);
            return false;
        }
        return true;
    }

    private void updateStatistics() throws PersistenceException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        util.updateConnectionStatistics(this.getCapturedConnection());
    }

    protected void captureType(String objType) throws PersistenceException, SQLException, CaptureException {
        if (this.m_filters != null && this.m_filters.getFilterForType(objType) == null) {
            return;
        }
        if (objType.equals("MD_CATALOGS")) {
            this.captureCatalog();
        } else if (objType.equals("MD_SCHEMAS")) {
            this.captureSchema();
        } else if (objType.equals("MD_VIEWS")) {
            this.capturePerSchema("MD_VIEWS");
        } else if (objType.equals("MD_USERS")) {
            this.capturePerSchema("MD_USERS");
        } else if (objType.equals("MD_TABLES")) {
            this.captureTables();
        } else if (objType.equals("MD_COLUMNS")) {
            this.capturePerTable("MD_COLUMNS");
        } else if (objType.equals("MD_INDEXES")) {
            this.capturePerTable("MD_INDEXES");
        } else if (objType.equals("MD_INDEX_DETAILS")) {
            this.capturePerTable("MD_INDEX_DETAILS");
        } else if (objType.equals("MD_CONSTRAINTS")) {
            this.capturePerTable("MD_CONSTRAINTS");
        } else if (objType.equals("MD_CONSTRAINT_DETAILS")) {
            this.capturePerTable("MD_CONSTRAINT_DETAILS");
        } else if (objType.equals("MD_STORED_PROGRAMS")) {
            this.capturePerSchema("MD_STORED_PROGRAMS");
        } else if (objType.equals("MD_TRIGGERS")) {
            this.capturePerTable("MD_TRIGGERS");
            this.capturePerView("MD_TRIGGERS");
        } else if (objType.equals("MD_GROUPS")) {
            this.capturePerCatalog("MD_GROUPS");
        } else {
            Assert.println((String)("DD>> TODO: Handle " + objType));
        }
    }

    protected void captureCatalog() throws PersistenceException, CaptureException {
        MigrationObjectFilter filter = null;
        if (this.m_filters != null) {
            filter = this.m_filters.getFilterForType("MD_CATALOGS");
        }
        this.captureCatalogImpl(filter);
    }

    protected abstract void captureCatalogImpl(MigrationObjectFilter var1) throws PersistenceException, CaptureException;

    protected void captureSchema() throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter filter = null;
        boolean catalogFound = false;
        if (this.m_filters != null) {
            filter = this.m_filters.getFilterForType("MD_SCHEMAS");
        }
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        DBObjectId currentConnection = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllCatalogsRec> capturedCatalogs = util.getCatalogsForConnectionId(currentConnection);
        while (capturedCatalogs.hasNext()) {
            catalogFound = true;
            if (this.shouldCancel()) {
                capturedCatalogs.close();
                CaptureEvent event = new CaptureEvent(-1, "SCHEMA", "");
                this.fireListeners(event);
                return;
            }
            MgvAllCatalogsRec catRec = (MgvAllCatalogsRec)capturedCatalogs.next();
            this.checkNewCatalog(catRec.getCatalogId());
            this.captureSchemaImpl(filter);
        }
        if (!catalogFound) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.INFO, "Capture.NO_VALID_CATALOGS");
        }
    }

    protected abstract void captureSchemaImpl(MigrationObjectFilter var1) throws PersistenceException, CaptureException;

    protected void capturePerCatalog(String type) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter filter = null;
        if (this.m_filters != null) {
            filter = this.m_filters.getFilterForType(type);
        }
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        DBObjectId currentConnection = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllCatalogsRec> capturedCatalogs = util.getCatalogsForConnectionId(currentConnection);
        while (capturedCatalogs.hasNext()) {
            if (this.shouldCancel()) {
                capturedCatalogs.close();
                CaptureEvent event = new CaptureEvent(-1, type, "");
                this.fireListeners(event);
                return;
            }
            MgvAllCatalogsRec catRec = (MgvAllCatalogsRec)capturedCatalogs.next();
            this.checkNewCatalog(catRec.getCatalogId());
            this.capturePerCatalogImpl(type, filter);
        }
    }

    protected abstract void capturePerCatalogImpl(String var1, MigrationObjectFilter var2) throws PersistenceException, CaptureException;

    protected void captureTables() throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter filter = null;
        if (this.m_filters != null) {
            filter = this.m_filters.getFilterForType("MD_TABLES");
        }
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        DBObjectId currentConnection = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllSchemasRec> capturedSchemas = util.getSchemasForConnectionId(currentConnection, this.m_filters);
        while (capturedSchemas.hasNext()) {
            if (this.shouldCancel()) {
                capturedSchemas.close();
                CaptureEvent event = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners(event);
                return;
            }
            MgvAllSchemasRec schemaRec = (MgvAllSchemasRec)capturedSchemas.next();
            this.checkNewCatalog(schemaRec.getCatalogId());
            this.checkNewSchema(schemaRec.getSchemaId());
            this.captureTableImpl(filter);
        }
    }

    protected abstract void captureTableImpl(MigrationObjectFilter var1) throws PersistenceException, CaptureException;

    protected void capturePerSchema(String type) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter filter = null;
        if (this.m_filters != null) {
            filter = this.m_filters.getFilterForType(type);
        }
        this.m_context.setContextVariable("PER_CONTEXT", "MD_SCHEMAS");
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        DBObjectId currentConnection = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllSchemasRec> capturedSchemas = util.getSchemasForConnectionId(currentConnection, this.m_filters);
        while (capturedSchemas.hasNext()) {
            if (this.shouldCancel()) {
                capturedSchemas.close();
                CaptureEvent event = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners(event);
                this.m_context.resetContextVariable("PER_CONTEXT");
                return;
            }
            MgvAllSchemasRec schemaRec = (MgvAllSchemasRec)capturedSchemas.next();
            this.checkNewCatalog(schemaRec.getCatalogId());
            this.checkNewSchema(schemaRec.getSchemaId());
            this.capturePerSchemaImpl(type, filter);
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    protected abstract void capturePerSchemaImpl(String var1, MigrationObjectFilter var2) throws PersistenceException, CaptureException;

    protected void capturePerTable(String type) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter filter = null;
        this.m_context.setContextVariable("PER_CONTEXT", "MD_TABLES");
        if (this.m_filters != null) {
            filter = this.m_filters.getFilterForType(type);
        }
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        DBObjectId currentConnection = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllTablesRec> capturedTables = util.getTablesForConnectionId(currentConnection, this.m_filters);
        while (capturedTables.hasNext()) {
            if (this.shouldCancel()) {
                capturedTables.close();
                CaptureEvent event = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners(event);
                this.m_context.resetContextVariable("PER_CONTEXT");
                return;
            }
            MgvAllTablesRec tableRec = (MgvAllTablesRec)capturedTables.next();
            this.checkNewCatalog(tableRec.getCatalogId());
            this.checkNewSchema(tableRec.getSchemaId());
            this.checkNewTable(tableRec.getTableId());
            this.capturePerTableImpl(type, filter);
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    protected abstract void capturePerTableImpl(String var1, MigrationObjectFilter var2) throws PersistenceException, CaptureException;

    protected void capturePerView(String type) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter filter = null;
        this.m_context.setContextVariable("PER_CONTEXT", "MD_VIEWS");
        if (this.m_filters != null) {
            filter = this.m_filters.getFilterForType(type);
        }
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        DBObjectId currentConnection = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllViewsRec> capturedViews = util.getViewsForConnectionId(currentConnection);
        while (capturedViews.hasNext()) {
            if (this.shouldCancel()) {
                capturedViews.close();
                CaptureEvent event = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners(event);
                this.m_context.resetContextVariable("PER_CONTEXT");
                return;
            }
            MgvAllViewsRec viewRec = (MgvAllViewsRec)capturedViews.next();
            this.checkNewCatalog(viewRec.getCatalogId());
            this.checkNewSchema(viewRec.getSchemaId());
            this.checkNewView(viewRec.getViewId());
            this.capturePerViewImpl(type, filter);
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    protected abstract void capturePerViewImpl(String var1, MigrationObjectFilter var2) throws PersistenceException, CaptureException;

    protected void storeConnection() throws PersistenceException, CaptureException {
        this.m_context.setContextVariable("PROJECT", this.getProjectName());
        this.fireStartStore("PROJECT", this.getProjectName());
        MdProject migrproject = new MdProject(this.getProjectName());
        migrproject = (MdProject)this.getStorer().storeObject(migrproject);
        this.m_context.setContextVariable("PROJECTID", migrproject.getKey());
        MdConnection migrconn = new MdConnection(migrproject.getKey());
        migrconn.setDburl(this.getCapturer().getSourceURL());
        this.m_context.setContextVariable("CONNECTION", migrconn.getDburl());
        this.fireStartStore("CONNECTION", migrconn.getDburl());
        migrconn.setName(this.getCapturer().getModelName());
        migrconn = (MdConnection)this.getStorer().storeObject(migrconn);
        migrconn.addProperty("PLUGIN_ID", this.getPluginIdentifier(), migrconn.getKey());
        migrconn = (MdConnection)this.getStorer().storeObject(migrconn);
        MigrationLogUtil.startMigrationLogSession(migrconn.getKey());
        this.setCapturedConnection(migrconn);
        this.m_context.setContextVariable("CONNECTIONID", migrconn.getKey());
        this.fireEndStore("CONNECTION", migrconn.getDburl());
    }

    protected CaptureAudience getCaptureAudience() {
        if (this.m_context != null) {
            return this.m_context.getAudience();
        }
        return null;
    }

    public void signalCancel() {
        this.m_context.signalCancel();
    }

    protected boolean shouldCancel() {
        return this.m_context.shouldCancel();
    }

    private void checkNewCatalog(DBObjectId catalogId) throws PersistenceException {
        if (!catalogId.equals(this.m_context.getContextVariable("CATALOGID"))) {
            MdCatalog catalog = MdCatalog.getExistingInstance(catalogId);
            try {
                PersistenceUtility util = this.getStorer().getPersistenceUtility();
                catalog = (MdCatalog)util.loadPersistableObject(catalogId, "MD_CATALOGS");
            }
            catch (NoSuchObjectException nsoe) {
                throw new PersistenceException(nsoe);
            }
            this.m_context.setContextVariable("CATALOGID", catalog.getKey());
            this.m_context.setContextVariable("CATALOG", catalog);
        }
    }

    private void checkNewSchema(DBObjectId schemaId) throws PersistenceException {
        if (!schemaId.equals(this.m_context.getContextVariable("SCHEMAID"))) {
            MdSchema schema = MdSchema.getExistingInstance(schemaId);
            try {
                PersistenceUtility util = this.getStorer().getPersistenceUtility();
                schema = (MdSchema)util.loadPersistableObject(schemaId, "MD_SCHEMAS");
            }
            catch (NoSuchObjectException nsoe) {
                throw new PersistenceException(nsoe);
            }
            this.m_context.setContextVariable("SCHEMA", schema.getName());
            this.m_context.setContextVariable("SCHEMAID", schema.getKey());
            this.m_context.setContextVariable("SCHEMAOBJ", schema);
        }
    }

    private void checkNewTable(DBObjectId tableId) throws PersistenceException {
        if (!tableId.equals(this.m_context.getContextVariable("TABLEID"))) {
            MdTable table = MdTable.getExistingInstance(tableId);
            try {
                PersistenceUtility util = this.getStorer().getPersistenceUtility();
                table = (MdTable)util.loadPersistableObject(tableId, "MD_TABLES");
            }
            catch (NoSuchObjectException nsoe) {
                throw new PersistenceException(nsoe);
            }
            this.m_context.setContextVariable("TABLE", table.getTableName());
            this.m_context.setContextVariable("TABLEID", table.getKey());
        }
    }

    private void checkNewView(DBObjectId viewId) throws PersistenceException {
        if (!viewId.equals(this.m_context.getContextVariable("VIEWID"))) {
            MdView view = MdView.getExistingInstance(viewId);
            try {
                PersistenceUtility util = this.getStorer().getPersistenceUtility();
                view = (MdView)util.loadPersistableObject(viewId, "MD_VIEWS");
            }
            catch (NoSuchObjectException nsoe) {
                throw new PersistenceException(nsoe);
            }
            this.m_context.setContextVariable("VIEWID", view.getKey());
            this.m_context.setContextVariable("VIEW", view.getViewName());
        }
    }

    protected String getPluginIdentifier() {
        return this.m_pluginIdentifier;
    }

    protected void setPluginIdentifier(String pluginIdentifier) {
        this.m_pluginIdentifier = pluginIdentifier;
    }

    public void setFilters(MigrationObjectFilterList filters) {
        this.m_filters = filters;
    }

    public void setTargetConnection(MdConnection migrconn) {
        this.setCapturedConnection(migrconn);
        this.m_context.setContextVariable("PROJECTID", migrconn.getProjectId());
        this.m_context.setContextVariable("CONNECTION", migrconn.getDburl());
        this.m_context.setContextVariable("CONNECTIONID", migrconn.getKey());
    }
}

