/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.capture.Capturer;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class OfflineCaptureWorker
extends CaptureWorker {
    private OfflineCapturer m_capturer;

    public OfflineCaptureWorker(OfflineCapturer offlineCapturer, String projectName, String pluginIdentifier) {
        this(offlineCapturer, projectName, pluginIdentifier, null);
    }

    public OfflineCaptureWorker(OfflineCapturer offlineCapturer, String projectName, String pluginIdentifier, MigrationObjectFilterList filters) {
        super(projectName, pluginIdentifier, filters);
        this.m_capturer = offlineCapturer;
    }

    protected void captureCatalogImpl(MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects("MD_CATALOGS", this.m_context, filter);
    }

    protected void capturePerCatalogImpl(String type, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(type, this.m_context, filter);
    }

    protected void capturePerSchemaImpl(String type, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(type, this.m_context, filter);
    }

    protected void capturePerTableImpl(String type, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(type, this.m_context, filter);
    }

    protected void capturePerViewImpl(String type, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(type, this.m_context, filter);
    }

    protected void captureSchemaImpl(MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects("MD_SCHEMAS", this.m_context, filter);
    }

    protected void captureTableImpl(MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects("MD_TABLES", this.m_context, filter);
    }

    protected Capturer getCapturer() {
        return this.m_capturer;
    }
}

