/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.capture.Capturer;
import oracle.dbtools.migration.capture.OnlineCapturer;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class OnlineCaptureWorker
extends CaptureWorker {
    private OnlineCapturer m_onlineCapturer;

    public OnlineCaptureWorker(OnlineCapturer capturer, String projectName, String pluginIdentifier) {
        this(capturer, projectName, pluginIdentifier, null);
    }

    public OnlineCaptureWorker(OnlineCapturer capturer, String projectName, String pluginIdentifier, MigrationObjectFilterList filters) {
        super(projectName, pluginIdentifier, filters);
        this.m_onlineCapturer = capturer;
    }

    protected void capturePerCatalogImpl(String type, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        String sql = this.m_onlineCapturer.getCaptureQueries().getQueryForType(type, filter);
        if (sql != null) {
            try {
                QueryCapture.doTypeCapture(sql, type, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sqlex) {
                throw new CaptureException(sqlex);
            }
        } else {
            this.m_onlineCapturer.captureObjects(type, this.m_context, filter);
        }
    }

    protected void captureCatalogImpl(MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        String sql = this.m_onlineCapturer.getCaptureQueries().getQueryForType("MD_CATALOGS", filter);
        if (sql != null) {
            try {
                QueryCapture.doCatalogCapture(sql, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sqlex) {
                throw new CaptureException(sqlex);
            }
        } else {
            this.m_onlineCapturer.captureObjects("MD_CATALOGS", this.m_context, filter);
        }
    }

    protected void captureSchemaImpl(MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        String sql = this.m_onlineCapturer.getCaptureQueries().getQueryForType("MD_SCHEMAS", filter);
        if (sql != null) {
            try {
                QueryCapture.doSchemaCapture(sql, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sqlex) {
                throw new CaptureException(sqlex);
            }
        } else {
            this.m_onlineCapturer.captureObjects("MD_SCHEMAS", this.m_context, filter);
        }
    }

    protected void captureTableImpl(MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        String sql = this.m_onlineCapturer.getCaptureQueries().getQueryForType("MD_TABLES", filter);
        if (sql != null) {
            try {
                QueryCapture.doTableCapture(sql, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sqlex) {
                throw new CaptureException(sqlex);
            }
        } else {
            this.m_onlineCapturer.captureObjects("MD_TABLES", this.m_context, filter);
        }
    }

    protected void capturePerSchemaImpl(String type, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        String sql = this.m_onlineCapturer.getCaptureQueries().getQueryForType(type, filter);
        if (sql != null) {
            try {
                QueryCapture.doTypeCapture(sql, type, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sqlex) {
                throw new CaptureException(sqlex);
            }
        } else {
            this.m_onlineCapturer.captureObjects(type, this.m_context, filter);
        }
    }

    protected void capturePerTableImpl(String type, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        String sql = this.m_onlineCapturer.getCaptureQueries().getQueryForType(type, filter);
        if (sql != null) {
            try {
                QueryCapture.doTypeCapture(sql, type, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sqlex) {
                throw new CaptureException(sqlex);
            }
        } else {
            this.m_onlineCapturer.captureObjects(type, this.m_context, filter);
        }
    }

    protected void capturePerViewImpl(String type, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        String sql = this.m_onlineCapturer.getCaptureQueries().getQueryForType(type, filter);
        if (sql != null) {
            try {
                QueryCapture.doTypeCapture(sql, type, this.m_onlineCapturer.getSourceConnection(), this.getStorer(), this.m_context);
            }
            catch (SQLException sqlex) {
                throw new CaptureException(sqlex);
            }
        } else {
            this.m_onlineCapturer.captureObjects(type, this.m_context, filter);
        }
    }

    protected Capturer getCapturer() {
        return this.m_onlineCapturer;
    }
}

