/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationStorer;

public final class QueryCapture {
    private QueryCapture() {
        throw new UnsupportedOperationException("This class should not be instanciated.");
    }

    public static CloseableResultSet issueSQL(String sql, Connection conn, CaptureContext context) throws SQLException {
        String query = context.applyToSQLString(sql);
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        return new CloseableResultSet(stmt, rs);
    }

    public static void doCatalogCapture(String sql, Connection conn, MigrationStorer storer, CaptureContext context) throws SQLException, PersistenceException {
        CloseableResultSet crs = QueryCapture.issueSQL(sql, conn, context);
        ResultSet rs = crs.getResultSet();
        while (rs.next()) {
            if (context.shouldCancel()) {
                crs.close();
                CaptureEvent event = new CaptureEvent(-1, "SCHEMA", "");
                context.getAudience().fireListeners(event);
                return;
            }
            QueryCapture.processCatalogRow(rs, storer, context);
        }
        crs.close();
    }

    protected static void processCatalogRow(ResultSet rs, MigrationStorer storer, CaptureContext context) throws SQLException, PersistenceException {
        DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
        MdCatalog catalog = new MdCatalog(connectionId);
        String catalogName = rs.getString(1);
        catalog.setCatalogName(catalogName);
        storer.storeObject(catalog);
    }

    public static void doSchemaCapture(String sql, Connection conn, MigrationStorer storer, CaptureContext context) throws SQLException, PersistenceException {
        CloseableResultSet crs = QueryCapture.issueSQL(sql, conn, context);
        ResultSet rs = crs.getResultSet();
        while (rs.next()) {
            if (context.shouldCancel()) {
                crs.close();
                CaptureEvent event = new CaptureEvent(-1, "SCHEMA", "");
                context.getAudience().fireListeners(event);
                return;
            }
            QueryCapture.processSchemaRow(rs, storer, context);
        }
        crs.close();
    }

    public static void processSchemaRow(ResultSet rs, MigrationStorer storer, CaptureContext context) throws SQLException, PersistenceException {
        CaptureAudience audience = context.getAudience();
        DBObjectId catalogId = (DBObjectId)context.getContextVariable("CATALOGID");
        DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
        MdSchema schema = new MdSchema(catalogId);
        schema.setName(rs.getString(1));
        ResultSetMetaData rsmd = rs.getMetaData();
        if (rsmd.getColumnCount() > 1) {
            for (int i = 1; i < rsmd.getColumnCount(); ++i) {
                schema.addProperty(rsmd.getColumnName(i), rs.getString(i), connectionId);
            }
        }
        CaptureEvent event = new CaptureEvent(3, "SCHEMA", schema.getName());
        audience.fireListeners(event);
        storer.storeObject(schema);
        event.setEventId(4);
        audience.fireListeners(event);
    }

    public static void doTableCapture(String sql, Connection conn, MigrationStorer storer, CaptureContext context) throws SQLException, PersistenceException {
        CloseableResultSet crs = QueryCapture.issueSQL(sql, conn, context);
        ResultSet rs = crs.getResultSet();
        while (rs.next()) {
            if (context.shouldCancel()) {
                crs.close();
                CaptureEvent event = new CaptureEvent(-1, "TABLE", "");
                context.getAudience().fireListeners(event);
                return;
            }
            QueryCapture.processTableRow(rs, storer, context);
        }
        crs.close();
    }

    public static void processTableRow(ResultSet rs, MigrationStorer storer, CaptureContext context) throws PersistenceException, SQLException {
        CaptureAudience audience = context.getAudience();
        DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
        DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
        String qualifiedName = "";
        MdCatalog catalog = (MdCatalog)context.getContextVariable("CATALOG");
        if (catalog != null && !MigrationUtils.catalogIsDummy(catalog)) {
            qualifiedName = catalog.getCatalogName() + ".";
        }
        String schemaName = (String)context.getContextVariable("SCHEMA");
        qualifiedName = qualifiedName + schemaName + ".";
        String tableName = rs.getString(1);
        qualifiedName = qualifiedName + tableName;
        MdTable table = new MdTable(schemaId, tableName, qualifiedName);
        ResultSetMetaData rsmd = rs.getMetaData();
        if (rsmd.getColumnCount() > 1) {
            for (int i = 1; i < rsmd.getColumnCount(); ++i) {
                table.addProperty(rsmd.getColumnName(i), rs.getString(i), connectionId);
            }
        }
        CaptureEvent event = new CaptureEvent(3, "TABLE", table.getTableName());
        audience.fireListeners(event);
        storer.storeObject(table);
        event.setEventId(4);
        audience.fireListeners(event);
    }

    public static void doTypeCapture(String sql, String type, Connection sourceConnection, MigrationStorer storer, CaptureContext context) throws PersistenceException, SQLException {
        CloseableResultSet crs = QueryCapture.issueSQL(sql, sourceConnection, context);
        ResultSet rs = crs.getResultSet();
        int i = 1;
        while (rs.next()) {
            if (context.shouldCancel()) {
                crs.close();
                CaptureEvent event = new CaptureEvent(-1, type, "");
                context.getAudience().fireListeners(event);
                return;
            }
            if (type.equals("MD_COLUMNS")) {
                QueryCapture.processColumnRow(rs, storer, context, i++);
                continue;
            }
            if (type.equals("MD_INDEXES")) {
                QueryCapture.processIndexRow(rs, storer, context);
                continue;
            }
            throw new PersistenceException("doTypeCapture does not support type of " + type);
        }
        crs.close();
    }

    private static void processColumnRow(ResultSet rs, MigrationStorer storer, CaptureContext context, int order) throws PersistenceException, SQLException {
        DBObjectId tableId = (DBObjectId)context.getContextVariable("TABLEID");
        MdColumn column = new MdColumn(tableId, rs.getString(1), order);
        CaptureAudience audience = context.getAudience();
        column.setColumnType(rs.getString(2));
        column.setPrecision(rs.getInt(3));
        column.setScale(rs.getInt(4));
        String nullable = rs.getString(5);
        nullable = nullable.toUpperCase().equals("Y") || nullable.equals("1") ? "Y" : "N";
        column.setNullable(nullable);
        CaptureEvent event = new CaptureEvent(3, "COLUMN", column.getColumnName());
        audience.fireListeners(event);
        storer.storeObject(column);
        event.setEventId(4);
        audience.fireListeners(event);
    }

    private static void processIndexRow(ResultSet rs, MigrationStorer storer, CaptureContext context) throws PersistenceException, SQLException {
    }
}

