/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.convert.TextMappingRuleSet;
import oracle.dbtools.migration.convert.XMLTextMappingRuleSet;
import oracle.dbtools.migration.translation.api.ITranslator;
import oracle.ide.util.Assert;
import org.xml.sax.SAXException;

public abstract class AbstractConverter
implements Converter {
    TextMappingRuleSet m_ruleSet;

    public TextMappingRuleSet getDefaultValueMappingRules() {
        if (this.m_ruleSet == null) {
            this.loadRuleSet();
        }
        return this.m_ruleSet;
    }

    private void loadRuleSet() {
        InputStream stream = this.getClass().getResourceAsStream(this.getDefaultValueMappingXML());
        try {
            this.m_ruleSet = new XMLTextMappingRuleSet(stream);
        }
        catch (SAXException saxe) {
            Assert.printStackTrace((Throwable)saxe);
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
        }
    }

    public abstract ITranslator getPlaformTranslator();

    public abstract String getDefaultValueMappingXML();
}

