/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectHierarchy;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.DerivativesIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUserDefinedDataType;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllSchemasRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableMasterChildren;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.NoCopyFoundException;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.persistence.MigrDatatypeTransformMap;
import oracle.dbtools.migration.persistence.MigrDatatypeTransformRule;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConvertUtils {
    public static final int MAX_ORACLE_IDENTIFIER_LENGTH = 30;
    private static final String QUERY_FIND_OBJECT_COPY = "SELECT DERIVED_ID FROM MD_DERIVATIVES WHERE SRC_ID = ? AND SRC_TYPE = ? AND DERIVED_TYPE = ? AND DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_FIND_PERSISTABLE_OBJECT_COPY = "SELECT DERIVED_ID, DERIVED_TYPE FROM MD_DERIVATIVES WHERE SRC_ID = ? AND SRC_TYPE = ? AND DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_FIND_PERSISTABLE_OBJECT_ORIGIONAL = "SELECT SRC_ID, SRC_TYPE FROM MD_DERIVATIVES WHERE DERIVED_ID = ? AND DERIVED_TYPE = ? AND DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_FIND_ORIGINAL_OBJECT = "SELECT SRC_ID FROM MD_DERIVATIVES WHERE DERIVED_ID = ? AND SRC_TYPE = ? AND DERIVED_TYPE = ? AND DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_REMOVE_DERIVED_RECORD = "DELETE FROM MD_DERIVATIVES WHERE DERIVED_ID = ? AND DERIVED_TYPE = ? AND DERIVED_CONNECTION_ID_FK =?";
    private static final String QUERY_COALASCED_CATALOGS = "SELECT SRC_TYPE, ORIGINAL_IDENTIFIER, NEW_IDENTIFIER, DERIVED_ID FROM MD_DERIVATIVES WHERE DERIVED_TYPE= 'MD_SCHEMAS' AND DERIVED_CONNECTION_ID_FK = ? ORDER BY DERIVED_ID";
    private static final String QUERY_AUTO_DATAYTPE_CHANGES = "SELECT C.TABLE_NAME, COLUMN_NAME, COLUMN_TYPE, PRECISION, SCALE FROM MD_COLUMNS A, MD_DERIVATIVES B, MD_TABLES C WHERE A.ID = B.DERIVED_ID AND B.DERIVED_TYPE = 'MD_COLUMNS' AND B.DERIVATIVE_REASON = 'INVDTTYPE'  AND C.ID = A.TABLE_ID_FK AND B.DERIVED_CONNECTION_ID_FK =?";
    private static final String QUERY_DROPPED_NCLOB_INDEXES = "SELECT C.TABLE_NAME, A.INDEX_NAME FROM MD_INDEXES A, MD_DERIVATIVES B, MD_TABLES C WHERE A.ID = B.SRC_ID AND B.DERIVATIVE_REASON = 'NCLOBIND' AND C.ID = A.TABLE_ID_FK AND B.DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_DROPPED_DUPLICATE_INDEXES = "SELECT C.TABLE_NAME, A.INDEX_NAME, D.INDEX_NAME, D.ID FROM MD_INDEXES A, MD_DERIVATIVES B, MD_TABLES C, MD_INDEXES D WHERE A.ID = B.SRC_ID AND B.DERIVATIVE_REASON = 'DUPIND' AND C.ID = A.TABLE_ID_FK AND D.ID = B.DERIVED_ID AND B.DERIVED_CONNECTION_ID_FK = ?";
    private static final String QUERY_INDEX_CONSTRAINT_CLASHES = "SELECT A.INDEX_NAME, B.TABLE_NAME  FROM MD_INDEXES A, MD_TABLES B WHERE A.TABLE_ID_FK = B.ID AND A.TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?) AND A.ID NOT IN (SELECT SRC_ID FROM MD_DERIVATIVES WHERE SRC_TYPE = 'MD_INDEXES' AND DERIVED_CONNECTION_ID_FK = ?)";
    private static HashMap<TranslationObjectType, String> s_dbObjectToMDTypeMap;
    private static HashMap<String, TranslationObjectType> s_mdTypeToRosettaTypeMap;

    private ConvertUtils() {
    }

    private static MigrDatatypeTransformRule persistableRule(DBObjectId mapId, DataTypeMappingRule rule) {
        DataTypeSpecification source = rule.getSourceDataType();
        DataTypeSpecification target = rule.getTargetDataType();
        MigrDatatypeTransformRule persistableRule = new MigrDatatypeTransformRule(mapId, source.getName(), target.getName());
        if (source.hasPrecision()) {
            persistableRule.setSourcePrecision(source.getPrecision());
            if (source.hasScale()) {
                persistableRule.setSourceScale(source.getScale());
            }
        }
        if (target.hasPrecision()) {
            persistableRule.setTargetPrecision(target.getPrecision());
            if (target.hasScale()) {
                persistableRule.setTargetScale(target.getScale());
            }
        }
        return persistableRule;
    }

    private static void removeExistingMap(PersistenceManager pman, DBObjectId projectId) throws PersistenceException {
        PreparedStatement stmt = null;
        try {
            stmt = pman.getPreparedStatement("DELETE FROM MIGR_DATATYPE_TRANSFORM_MAP WHERE PROJECT_ID_FK = ?");
            stmt.setLong(1, projectId.getId());
            stmt.executeUpdate();
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    public static void removeDerivedConstraint(PersistenceManager pman, MdConstraint constraint, DBObjectId connectionId) throws PersistenceException {
        DBObjectId store = constraint.getKey();
        constraint.delete(pman);
        PreparedStatement stmt = null;
        try {
            stmt = pman.getPreparedStatement(QUERY_REMOVE_DERIVED_RECORD);
            stmt.setLong(1, store.getId());
            stmt.setString(2, "MD_CONSTRAINTS");
            stmt.setLong(3, connectionId.getId());
            stmt.executeUpdate();
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    public static DBObjectId persistMap(PersistenceManager pman, DBObjectId projectId, String name, DataTypeConversionMap map) throws PersistenceException {
        MigrDatatypeTransformMap persistableMap = new MigrDatatypeTransformMap(projectId);
        persistableMap.setMapName(name);
        ConvertUtils.removeExistingMap(pman, projectId);
        persistableMap.save(pman);
        for (DataTypeMappingRule rule : map.values()) {
            MigrDatatypeTransformRule persistableRule = ConvertUtils.persistableRule(persistableMap.getKey(), rule);
            persistableRule.save(pman);
        }
        return persistableMap.getKey();
    }

    public static DataTypeConversionMap getDefaultMapFromSupportedMap(SupportedDataTypesMap map) {
        DataTypeSpecification[] sourceTypes = map.getSourceDataTypes();
        DataTypeConversionMap retMap = new DataTypeConversionMap();
        for (DataTypeSpecification spec : sourceTypes) {
            DataTypeMappingRule[] rules = map.getRulesForDataType(spec);
            if (rules.length <= 0) continue;
            retMap.addRule(rules[0]);
        }
        return retMap;
    }

    public static DataTypeConversionMap getPersistedMap(PersistenceManager pman, DBObjectId currentConnection) throws PersistenceException {
        MdConnection mdconnection;
        DataTypeConversionMap retMap = new DataTypeConversionMap();
        try {
            mdconnection = MdConnection.retrieveExistingInstance(pman, currentConnection);
        }
        catch (NoSuchObjectException nsoe) {
            throw new PersistenceException(nsoe);
        }
        MigrDatatypeTransformMap mapsForProjectId = ConvertUtils.getMapForProjectId(pman, mdconnection.getProjectId());
        if (mapsForProjectId == null) {
            return retMap;
        }
        DBObjectId mapId = mapsForProjectId.getKey();
        PersistableMasterChildren persistedRules = new PersistableMasterChildren(MigrDatatypeTransformRule.class, "MAP_ID_FK", mapId, pman, null);
        while (persistedRules.hasNext()) {
            MigrDatatypeTransformRule rule = (MigrDatatypeTransformRule)persistedRules.next();
            DataTypeSpecification srcSpec = new DataTypeSpecification(rule.getSourceDataTypeName(), rule.getSourcePrecision(), rule.getSourceScale());
            DataTypeSpecification targetSpec = new DataTypeSpecification(rule.getTargetDataTypeName(), rule.getTargetPrecision(), rule.getTargetScale());
            retMap.addOrReplaceRule(new DataTypeMappingRule(srcSpec, targetSpec));
        }
        try {
            PersistenceUtility pu = PersistenceUtility.getInstance(pman);
            CloseableIterator<MgvAllSchemasRec> schemas = pu.getSchemasForConnectionId(mdconnection.getKey());
            while (schemas.hasNext()) {
                MgvAllSchemasRec schemaRec = (MgvAllSchemasRec)schemas.next();
                DBObjectId schemaId = schemaRec.getSchemaId();
                PersistableMasterChildren udtPersistedRules = new PersistableMasterChildren(MdUserDefinedDataType.class, "SCHEMA_ID_FK", schemaId, pman, null);
                while (udtPersistedRules.hasNext()) {
                    MdUserDefinedDataType udt = (MdUserDefinedDataType)udtPersistedRules.next();
                    DataTypeSpecification udtSrcSpec = new DataTypeSpecification(udt.getDataTypeName(), null, null);
                    DataTypeSpecification srcSpec = ConvertUtils.getUDTSpec(udt.getDefinition());
                    DataTypeSpecification targetSpec = retMap.mapDataType(srcSpec);
                    retMap.addUDTRule(new DataTypeMappingRule(udtSrcSpec, targetSpec));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return retMap;
    }

    private static DataTypeSpecification getUDTSpec(String udt) {
        DataTypeSpecification spec = null;
        if (udt == null || udt.trim().equals("")) {
            return new DataTypeSpecification(udt, null, null);
        }
        try {
            int lbracket = udt.indexOf(40);
            int comma = udt.indexOf(44);
            spec = lbracket == -1 ? new DataTypeSpecification(udt.trim(), null, null) : (comma == -1 ? new DataTypeSpecification(udt.substring(0, lbracket).trim(), new Integer(udt.substring(lbracket, udt.length() - 1).trim()), null) : new DataTypeSpecification(udt.substring(0, lbracket).trim(), new Integer(udt.substring(lbracket + 1, comma).trim()), new Integer(udt.substring(comma + 1, udt.length() - 1).trim())));
        }
        catch (Exception e) {
            spec = new DataTypeSpecification(udt.trim(), null, null);
        }
        return spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MigrDatatypeTransformMap getMapForProjectId(PersistenceManager pman, DBObjectId projectId) throws PersistenceException {
        PersistableMasterChildren ret = new PersistableMasterChildren(MigrDatatypeTransformMap.class, "PROJECT_ID_FK", projectId, pman, null);
        try {
            if (ret.hasNext()) {
                MigrDatatypeTransformMap migrDatatypeTransformMap = (MigrDatatypeTransformMap)ret.next();
                return migrDatatypeTransformMap;
            }
        }
        finally {
            ret.close();
        }
        return null;
    }

    public static String getClobAsString(ClobHelper clobHelper) throws IOException {
        if (clobHelper == null) {
            return null;
        }
        if (clobHelper.getLength() == 0L) {
            return "";
        }
        if (clobHelper.getLength() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Clob too large");
        }
        Reader reader = clobHelper.getReader();
        CharBuffer buffer = CharBuffer.allocate((int)clobHelper.getLength());
        reader.read(buffer);
        reader.close();
        buffer.rewind();
        return buffer.toString();
    }

    public static TranslationDBObject asDBObject(String host, String catalog, String schema, MdView view) throws IOException {
        ClobHelper clobHelper = view.getNativeSql();
        String ddl = ConvertUtils.getClobAsString(clobHelper);
        TranslationDBObjectReference ref = new TranslationDBObjectReference(host, catalog, schema, view.getViewName(), null, TranslationObjectType.VIEW_TYPE, (Object)view);
        TranslationDBObject ret = new TranslationDBObject(ref, ddl);
        return ret;
    }

    public static TranslationDBObject asTranslationDBObject(PersistableObject poObject, PersistenceManager pm) throws IOException {
        if (poObject == null) {
            return null;
        }
        DBObjectHierarchy dbObjectHierarchy = new DBObjectHierarchy(poObject, pm);
        if (poObject.getObjectType().equalsIgnoreCase("MD_STORED_PROGRAMS")) {
            return ConvertUtils.asDBObject(dbObjectHierarchy.getConnection().getHost(), dbObjectHierarchy.getCatalog().getCatalogName(), dbObjectHierarchy.getSchema().getName(), (MdStoredProgram)dbObjectHierarchy.getObject());
        }
        if (poObject.getObjectType().equalsIgnoreCase("MD_TRIGGERS")) {
            return ConvertUtils.asTranslationDBObject(dbObjectHierarchy.getConnection().getHost(), dbObjectHierarchy.getCatalog().getCatalogName(), dbObjectHierarchy.getSchema().getName(), (MdTrigger)dbObjectHierarchy.getObject());
        }
        if (poObject.getObjectType().equalsIgnoreCase("MD_VIEWS")) {
            return ConvertUtils.asDBObject(dbObjectHierarchy.getConnection().getHost(), dbObjectHierarchy.getCatalog().getCatalogName(), dbObjectHierarchy.getSchema().getName(), (MdView)dbObjectHierarchy.getObject());
        }
        return null;
    }

    public static TranslationDBObject asDBObject(String host, String catalog, String schema, MdStoredProgram program) throws IOException {
        ClobHelper clobHelper = program.getNativeSql();
        String ddl = ConvertUtils.getClobAsString(clobHelper);
        TranslationDBObjectReference ref = new TranslationDBObjectReference(host, catalog, schema, program.getName(), null, TranslationObjectType.PROCEDURE_TYPE, (Object)program);
        TranslationDBObject ret = new TranslationDBObject(ref, ddl);
        return ret;
    }

    public static TranslationDBObject asTranslationDBObject(String host, String catalog, String schema, MdTrigger trigger) throws IOException {
        ClobHelper clobHelper = trigger.getNativeSql();
        String ddl = ConvertUtils.getClobAsString(clobHelper);
        TranslationDBObjectReference ref = new TranslationDBObjectReference(host, catalog, schema, trigger.getTriggerName(), null, TranslationObjectType.TRIGGER_TYPE, (Object)trigger);
        TranslationDBObject ret = new TranslationDBObject(ref, ddl);
        return ret;
    }

    public static String getMDType(TranslationObjectType obj) {
        return ConvertUtils.getDBObjectToMDTypeMap().get(obj);
    }

    public static TranslationObjectType getRosettaType(String mdType) {
        return ConvertUtils.getMdTypeToRosettaTypeMap().get(mdType);
    }

    private static HashMap<TranslationObjectType, String> getDBObjectToMDTypeMap() {
        if (s_dbObjectToMDTypeMap == null) {
            ConvertUtils.populateMaps();
        }
        return s_dbObjectToMDTypeMap;
    }

    private static HashMap<String, TranslationObjectType> getMdTypeToRosettaTypeMap() {
        if (s_mdTypeToRosettaTypeMap == null) {
            ConvertUtils.populateMaps();
        }
        return s_mdTypeToRosettaTypeMap;
    }

    private static void populateMaps() {
        ConvertUtils.addToMaps(TranslationObjectType.CONSTRAINT_TYPE, "MD_CONSTRAINTS");
        ConvertUtils.addToMaps(TranslationObjectType.DATABASE_TYPE, "MD_CATALOGS");
        ConvertUtils.addToMaps(TranslationObjectType.FUNCTION_TYPE, "MD_STORED_PROGRAMS");
        ConvertUtils.addToMaps(TranslationObjectType.GROUP_TYPE, "MD_GROUPS");
        ConvertUtils.addToMaps(TranslationObjectType.INDEX_TYPE, "MD_INDEXES");
        ConvertUtils.addToMaps(TranslationObjectType.OTHEROBJECT_TYPE, "MD_OTHER_OBJECTS");
        ConvertUtils.addToMaps(TranslationObjectType.PACKAGE_TYPE, "MD_PACKAGES");
        ConvertUtils.addToMaps(TranslationObjectType.PRIVILEGE_TYPE, "MD_PRIVILEGES");
        ConvertUtils.addToMaps(TranslationObjectType.PROCEDURE_TYPE, "MD_STORED_PROGRAMS");
        ConvertUtils.addToMaps(TranslationObjectType.SCHEMA_TYPE, "MD_SCHEMAS");
        ConvertUtils.addToMaps(TranslationObjectType.SEQUENCE_TYPE, "MD_SEQUENCES");
        ConvertUtils.addToMaps(TranslationObjectType.SYNONYM_TYPE, "MD_SYNONYMS");
        ConvertUtils.addToMaps(TranslationObjectType.TABLE_TYPE, "MD_TABLES");
        ConvertUtils.addToMaps(TranslationObjectType.TABLESPACE_TYPE, "MD_TABLESPACES");
        ConvertUtils.addToMaps(TranslationObjectType.TRIGGER_TYPE, "MD_TRIGGERS");
        ConvertUtils.addToMaps(TranslationObjectType.USER_TYPE, "MD_USERS");
        ConvertUtils.addToMaps(TranslationObjectType.USERDATATYPE_TYPE, "MD_USER_DEFINED_DATA_TYPES");
        ConvertUtils.addToMaps(TranslationObjectType.VIEW_TYPE, "MD_VIEWS");
    }

    private static void addToMaps(TranslationObjectType rosettaType, String mdType) {
        if (s_dbObjectToMDTypeMap == null) {
            s_dbObjectToMDTypeMap = new HashMap();
        }
        if (s_mdTypeToRosettaTypeMap == null) {
            s_mdTypeToRosettaTypeMap = new HashMap();
        }
        s_dbObjectToMDTypeMap.put(rosettaType, mdType);
        s_mdTypeToRosettaTypeMap.put(mdType, rosettaType);
    }

    public static DBObjectId findObjectCopy(PersistenceManager pman, DBObjectId originalId, String type, DBObjectId convertedConnectionId) throws SQLException {
        return ConvertUtils.runFindQuery(pman, originalId, type, convertedConnectionId, QUERY_FIND_OBJECT_COPY);
    }

    public static PersistableObject findPersistableCopy(PersistenceManager pman, PersistableObject sourcePO, DBObjectId convertedConnectionId) throws SQLException, PersistenceException, NoSuchObjectException {
        return ConvertUtils.runPOQuery(pman, sourcePO.getKey(), sourcePO.getObjectType(), convertedConnectionId, QUERY_FIND_PERSISTABLE_OBJECT_COPY);
    }

    public static PersistableObject findPersistableOrigional(PersistenceManager pman, PersistableObject convertedPO, DBObjectId convertedConnectionId) throws SQLException, PersistenceException, NoSuchObjectException {
        return ConvertUtils.runPOQuery(pman, convertedPO.getKey(), convertedPO.getObjectType(), convertedConnectionId, QUERY_FIND_PERSISTABLE_OBJECT_ORIGIONAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PersistableObject runPOQuery(PersistenceManager pman, DBObjectId searchId, String type, DBObjectId convertedConnectionId, String query) throws SQLException, PersistenceException, NoSuchObjectException {
        PersistableObject ret = null;
        CloseableResultSet crs = null;
        try {
            PreparedStatement stmt = pman.getPreparedStatement(query);
            stmt.setLong(1, searchId.getId());
            stmt.setString(2, type);
            stmt.setLong(3, convertedConnectionId.getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            PersistenceUtility pu = PersistenceUtility.getInstance(pman);
            if (rs.next()) {
                DBObjectId foundDBObjectId = new DBObjectId(rs.getLong(1));
                String foundType = rs.getString(2);
                ret = pu.loadPersistableObject(foundDBObjectId, foundType);
            }
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DBObjectId runFindQuery(PersistenceManager pman, DBObjectId searchId, String type, DBObjectId convertedConnectionId, String query) throws SQLException {
        DBObjectId ret = null;
        CloseableResultSet crs = null;
        try {
            PreparedStatement stmt = pman.getPreparedStatement(query);
            stmt.setLong(1, searchId.getId());
            stmt.setString(2, type);
            stmt.setString(3, type);
            stmt.setLong(4, convertedConnectionId.getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            if (rs.next()) {
                ret = new DBObjectId(rs.getLong(1));
            }
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
        return ret;
    }

    private static DBObjectId findOriginalObject(PersistenceManager pman, DBObjectId copyId, String type, DBObjectId convertedConnectionId) throws SQLException {
        return ConvertUtils.runFindQuery(pman, copyId, type, convertedConnectionId, QUERY_FIND_ORIGINAL_OBJECT);
    }

    public static MdView findViewCopy(MdView original, PersistenceManager pman, DBObjectId convertedConnectionId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId copyViewId = ConvertUtils.findObjectCopy(pman, original.getKey(), "MD_VIEWS", convertedConnectionId);
            if (copyViewId == null) {
                throw new NoCopyFoundException("MD_VIEWS", original);
            }
            MdView ret = MdView.retrieveExistingInstance(pman, copyViewId);
            return ret;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    public static MdTable findOriginalTable(MdTable copy, PersistenceManager pman, DBObjectId convertedConnectionId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId originalTableId = ConvertUtils.findOriginalObject(pman, copy.getKey(), "MD_TABLES", convertedConnectionId);
            if (originalTableId == null) {
                throw new NoCopyFoundException("MD_TABLES", copy);
            }
            MdTable ret = MdTable.retrieveExistingInstance(pman, originalTableId);
            return ret;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    public static MdConstraint findConstraintCopy(MdConstraint original, PersistenceManager pman, DBObjectId convertedConnectionId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId copyConstraintId = ConvertUtils.findObjectCopy(pman, original.getKey(), "MD_CONSTRAINTS", convertedConnectionId);
            if (copyConstraintId == null) {
                throw new NoCopyFoundException("MD_CONSTRAINTS", original);
            }
            MdConstraint ret = MdConstraint.retrieveExistingInstance(pman, copyConstraintId);
            return ret;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    public static MdConstraint findOriginalConstraint(MdConstraint copy, PersistenceManager pman, DBObjectId convertedConnectionId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId originalId = ConvertUtils.findOriginalObject(pman, copy.getKey(), "MD_CONSTRAINTS", convertedConnectionId);
            if (originalId == null) {
                throw new NoCopyFoundException("MD_CONSTRAINTS", copy);
            }
            MdConstraint ret = MdConstraint.retrieveExistingInstance(pman, originalId);
            return ret;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    public static MdStoredProgram findProgramCopy(MdStoredProgram original, PersistenceManager pman, DBObjectId convertedConnectionId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId copyProgId = ConvertUtils.findObjectCopy(pman, original.getKey(), "MD_STORED_PROGRAMS", convertedConnectionId);
            if (copyProgId == null) {
                throw new NoCopyFoundException("MD_STORED_PROGRAMS", original);
            }
            MdStoredProgram prog = MdStoredProgram.retrieveExistingInstance(pman, copyProgId);
            return prog;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    public static MdTrigger findTriggerCopy(MdTrigger original, PersistenceManager pman, DBObjectId convertedConnectionId) throws PersistenceException, NoSuchObjectException, NoCopyFoundException {
        try {
            DBObjectId copyTrigId = ConvertUtils.findObjectCopy(pman, original.getKey(), "MD_TRIGGERS", convertedConnectionId);
            if (copyTrigId == null) {
                throw new NoCopyFoundException("MD_TRIGGERS", original);
            }
            MdTrigger trigger = MdTrigger.retrieveExistingInstance(pman, copyTrigId);
            return trigger;
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
    }

    public static String generateName(String sourceName) {
        if (sourceName.length() > 30) {
            StringBuffer sBuf = new StringBuffer(sourceName.substring(0, 12));
            String salt = ConvertUtils.randomChars(6);
            sBuf.append(salt);
            sBuf.append(sourceName.substring(sourceName.length() - 12, sourceName.length()));
            return sBuf.toString();
        }
        return sourceName;
    }

    private static String randomChars(int numChars) {
        StringBuffer sBuf = new StringBuffer();
        for (int i = 0; i < numChars; ++i) {
            boolean useUpper;
            int index = (int)(Math.random() * 26.0);
            boolean bl = useUpper = (int)(Math.random() * 10000.0) % 2 == 0;
            if (useUpper) {
                sBuf.append((char)(65 + index));
                continue;
            }
            sBuf.append((char)(97 + index));
        }
        return sBuf.toString();
    }

    public static CoalescedSchemaInfo[] getCoalascedSchema(PersistenceManager pman, DBObjectId connectionId) throws PersistenceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        long lCurrentId = -1L;
        ArrayList<CoalescedSchemaInfo> ret = new ArrayList<CoalescedSchemaInfo>();
        CoalescedSchemaInfo info = new CoalescedSchemaInfo();
        try {
            stmt = pman.getPreparedStatement(QUERY_COALASCED_CATALOGS);
            stmt.setLong(1, connectionId.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String s;
                long lId = rs.getLong(4);
                if (lCurrentId != -1L) {
                    if (lId != lCurrentId) {
                        ret.add(info);
                        info = new CoalescedSchemaInfo();
                        lCurrentId = lId;
                    }
                } else {
                    lCurrentId = lId;
                }
                if ((s = rs.getString(1)).equals("MD_CATALOGS")) {
                    info.m_originalCatalogName = rs.getString(2);
                    info.m_derivedSchemaName = rs.getString(3);
                    continue;
                }
                info.m_originalSchemaName = rs.getString(2);
            }
            if (lCurrentId != -1L) {
                ret.add(info);
            }
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
        return ret.toArray(new CoalescedSchemaInfo[ret.size()]);
    }

    public static DerivativesIterator getTransformedIdentifiers(PersistenceManager pman, DBObjectId connectionId) {
        String condition = "DERIVED_TYPE != 'MD_CATALOGS' AND DERIVED_TYPE != 'MD_CONNECTIONS' AND DERIVED_TYPE != 'MD_SCHEMAS' AND NEW_IDENTIFIER != ORIGINAL_IDENTIFIER";
        return new DerivativesIterator(pman, connectionId, condition);
    }

    public static String toDataTypeString(String dataType, Integer precision, Integer scale) {
        StringBuilder sb = new StringBuilder();
        sb.append(dataType);
        if (precision != null && precision != 0) {
            sb.append('(');
            sb.append(precision);
            if (scale != null && scale != 0) {
                sb.append(", ");
                sb.append(scale);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static void logDroppedIndexesConstraintClash(PersistenceManager persistenceManager, DBObjectId sourceConnectionId, DBObjectId convertedConnectionId, Logger logger) throws PersistenceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = persistenceManager.getPreparedStatement(QUERY_INDEX_CONSTRAINT_CLASHES);
            stmt.setLong(1, sourceConnectionId.getId());
            stmt.setLong(2, convertedConnectionId.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                String indexName = rs.getString(2);
                logger.log(Level.INFO, "Convert.DROPPEDCONSTRAINTINDEX", new Object[]{tableName, indexName});
            }
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
    }

    public static void logRemovedDuplicateIndexes(PersistenceManager persistenceManager, DBObjectId convertedConnectionId, Logger logger) throws PersistenceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = persistenceManager.getPreparedStatement(QUERY_DROPPED_DUPLICATE_INDEXES);
            stmt.setLong(1, convertedConnectionId.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                String droppedIndexName = rs.getString(2);
                String keptIndexName = rs.getString(3);
                long keptIndexId = rs.getLong(4);
                MdIndexe mdIndex = null;
                try {
                    mdIndex = MdIndexe.retrieveExistingInstance(persistenceManager, new DBObjectId(keptIndexId));
                }
                catch (NoSuchObjectException e) {
                    MigrationLogUtil.logThrowable("Could not retrieve kept index " + keptIndexName, "Convert", (Throwable)e);
                }
                logger.log(Level.INFO, "Convert.DROPPEDDUPLICATEINDEX", new Object[]{droppedIndexName, tableName, keptIndexName, new ClickableLogInfo(mdIndex, "Convert")});
            }
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
    }

    public static void logDroppedNClobIndexes(PersistenceManager persistenceManager, DBObjectId convertedConnectionId, Logger logger) throws PersistenceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = persistenceManager.getPreparedStatement(QUERY_DROPPED_NCLOB_INDEXES);
            stmt.setLong(1, convertedConnectionId.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                String indexName = rs.getString(2);
                logger.log(Level.INFO, "Convert.NCLOBINDEXDROPPED", new Object[]{tableName, indexName});
            }
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
    }

    public static void logAutoChangedDataTypes(PersistenceManager pman, DBObjectId convertedConnectionId, Logger logger) throws PersistenceException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = pman.getPreparedStatement(QUERY_AUTO_DATAYTPE_CHANGES);
            stmt.setLong(1, convertedConnectionId.getId());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                String columnName = rs.getString(2);
                String dataTypeName = rs.getString(3);
                Integer precision = new Integer(rs.getInt(4));
                if (rs.wasNull()) {
                    precision = null;
                }
                Integer scale = new Integer(rs.getInt(5));
                if (rs.wasNull()) {
                    scale = null;
                }
                logger.log(Level.INFO, "Convert.DATATYPECHANGED", new Object[]{tableName, columnName, ConvertUtils.toDataTypeString(dataTypeName, precision, scale)});
            }
        }
        catch (SQLException sqlex) {
            try {
                throw new PersistenceException(sqlex);
            }
            catch (Throwable throwable) {
                CloseableResultSet.close(null, rs);
                throw throwable;
            }
        }
        CloseableResultSet.close(null, rs);
    }

    public static class CoalescedSchemaInfo {
        public String m_originalSchemaName;
        public String m_originalCatalogName;
        public String m_derivedSchemaName;

        public Object[] getDataAsObjectArray() {
            return new Object[]{this.m_originalCatalogName, this.m_originalSchemaName, this.m_derivedSchemaName};
        }
    }
}

