/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.DerivativesIterator;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdDerivative;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdMigrParameter;
import oracle.dbtools.metadata.persistence.MdPackage;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSequence;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllSchemasRec;
import oracle.dbtools.metadata.persistence.MgvAllStoredProgramsRec;
import oracle.dbtools.metadata.persistence.MgvAllTableTriggersRec;
import oracle.dbtools.metadata.persistence.MgvAllViewTriggersRec;
import oracle.dbtools.metadata.persistence.MgvAllViewsRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PropertyBasedPersitableObjectIterator;
import oracle.dbtools.metadata.persistence.TextIndexesIterator;
import oracle.dbtools.migration.convert.ConvertAudience;
import oracle.dbtools.migration.convert.ConvertContext;
import oracle.dbtools.migration.convert.ConvertEvent;
import oracle.dbtools.migration.convert.ConvertEventListener;
import oracle.dbtools.migration.convert.ConvertException;
import oracle.dbtools.migration.convert.ConvertResult;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.convert.NoCopyFoundException;
import oracle.dbtools.migration.convert.TextMappingResult;
import oracle.dbtools.migration.convert.TextMappingRuleSet;
import oracle.dbtools.migration.convert.TransformDefaultWrapper;
import oracle.dbtools.migration.convert.TranslationContext;
import oracle.dbtools.migration.convert.TranslationLogging;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.core.util.MultiLevelLogManager;
import oracle.dbtools.migration.persistence.MigrGenerationOrder;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.ITranslationLogging;
import oracle.dbtools.migration.translation.api.ITranslationManager;
import oracle.dbtools.migration.translation.api.ITranslationMetaData;
import oracle.dbtools.migration.translation.api.ITranslator;
import oracle.dbtools.migration.translation.api.TranslationResult;
import oracle.dbtools.migration.translation.api.TranslationSession;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterWorker
implements Cancelable,
ITranslationManager {
    private static final String QUERY_COLS_WITH_DEFAULTS = "SELECT ID,DEFAULT_VALUE FROM MD_COLUMNS WHERE TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?) AND DEFAULT_VALUE IS NOT NULL";
    private static final String SELECT_COMMENTS_QUERY_RENAMED_TABLES = "SELECT COMMENTS FROM MD_TABLES WHERE ID=?";
    private static final String SELECT_COMMENTS_QUERY_RENAMED_COLS = "SELECT COMMENTS FROM MD_COLUMNS WHERE ID=?";
    private static final String UPDATE_COMMENTS_QUERY_RENAMED_TABLES = "UPDATE MD_TABLES SET COMMENTS=? WHERE ID=?";
    private static final String UPDATE_COMMENTS_QUERY_RENAMED_COLS = "UPDATE MD_COLUMNS SET COMMENTS=? WHERE ID=?";
    private ConvertContext m_context = new ConvertContext();
    private DBObjectId m_sourceConnectionId;
    private DBObjectId m_convertedConnectionId;
    private MdConnection m_convertedConnection;
    private DBObjectId m_mapId;
    private PersistenceManager m_persistenceManager;
    private Converter m_platformConverter;
    private ConvertAudience m_audience;
    private TranslationContext m_transformedNameLocator;
    private TranslationSession m_translationSession;
    private int m_generationOrder;
    private HashSet<DBObjectId> m_translatedTargetObjects;
    private HashSet<DBObjectId> m_translatedSourceObjects;
    private boolean m_targettingMultibyte = true;
    private Stack<Long> m_translatingObjects = new Stack();
    private MigrationObjectFilterList m_filterList;
    private static Logger s_logger = Logger.getLogger("oracle.dbtools.migration");
    private ITranslationLogging m_translationLogging = null;
    private MultiLevelLogManager m_translationLogManager = new MultiLevelLogManager();

    public ConverterWorker(PersistenceManager pman, DBObjectId sourceConnectionId, Converter pluginConverter, DBObjectId mapId, MigrationObjectFilterList filterList) throws PersistenceException {
        this.setPersistenceManager(pman);
        this.setSourceConnectionId(sourceConnectionId);
        this.setPlatformConverter(pluginConverter);
        this.setMapId(mapId);
        this.setFilterList(filterList);
        this.m_audience = new ConvertAudience();
        this.m_generationOrder = 0;
    }

    private void setFilterList(MigrationObjectFilterList filterList) {
        this.m_filterList = filterList;
    }

    public boolean runConvert() throws PersistenceException, ConvertException {
        TranslationContext nameCache;
        ConvertEvent convertEvent = new ConvertEvent(19, "", "");
        this.getAudience().fireListeners(convertEvent);
        if (this.shouldCancel()) {
            ConvertEvent event = new ConvertEvent(-1, "", "");
            this.getAudience().fireListeners(event);
            this.rollbackConvert();
            return false;
        }
        this.m_convertedConnectionId = this.copyModel();
        if (this.shouldCancel()) {
            ConvertEvent event = new ConvertEvent(-1, "COPY", "");
            this.getAudience().fireListeners(event);
            this.rollbackConvert();
            return false;
        }
        try {
            this.reportCoalascedCatalogs();
            this.reportRemovedIndexes();
        }
        catch (Exception e) {
            MigrationLogUtil.logThrowable(e.getLocalizedMessage(), "Convert", (Throwable)e);
        }
        this.transformIdentifiers();
        this.addCommentForTransformedColTabs();
        if (this.shouldCancel()) {
            ConvertEvent event = new ConvertEvent(-1, "IDENTIFIER TRANSFORM", "");
            this.getAudience().fireListeners(event);
            this.rollbackConvert();
            return false;
        }
        try {
            this.reportTransformedIdentifiers();
        }
        catch (Exception e) {
            MigrationLogUtil.logThrowable(e.getLocalizedMessage(), "Convert", (Throwable)e);
        }
        this.transformDataTypes();
        if (this.shouldCancel()) {
            ConvertEvent event = new ConvertEvent(-1, "DATATYPE TRANSFORM", "");
            this.getAudience().fireListeners(event);
            this.rollbackConvert();
            return false;
        }
        this.reportDataTypeTransformResults();
        this.transformDefaults();
        if (this.shouldCancel()) {
            ConvertEvent event = new ConvertEvent(-1, "DEFAULT TRANSFORM", "");
            this.getAudience().fireListeners(event);
            this.rollbackConvert();
            return false;
        }
        this.m_transformedNameLocator = nameCache = new TranslationContext(this.getPersistenceManager(), this.getConvertedConnectionId(), 100, this.m_mapId);
        this.m_translatedTargetObjects = new HashSet();
        this.m_translatedSourceObjects = new HashSet();
        this.transformCodeSegments();
        if (this.shouldCancel()) {
            ConvertEvent event = new ConvertEvent(-1, "CODE TRANSFORM", "");
            this.getAudience().fireListeners(event);
            this.rollbackConvert();
            return false;
        }
        if (this.shouldCancel()) {
            ConvertEvent event = new ConvertEvent(-1, "IDENTITY TRANSFORM", "");
            this.getAudience().fireListeners(event);
            this.rollbackConvert();
            return false;
        }
        this.transformIdentityColumns();
        this.checkPlatformSpecificConversions();
        this.finalClashCheck();
        this.rewriteTriggerText();
        this.updateStatistics();
        convertEvent.setEventId(20);
        this.getAudience().fireListeners(convertEvent);
        return true;
    }

    private void rewriteTriggerText() throws ConvertException {
        OracleCallableStatement stmt = null;
        try {
            stmt = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.TRANSFORM_REWRITE_TRIGGER(?)}");
            stmt.registerOutParameter(1, 4);
            stmt.setLong(2, this.m_convertedConnectionId.getId());
            stmt.execute();
            long lRet = stmt.getLong(1);
        }
        catch (SQLException sqlex) {
            throw new ConvertException(sqlex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void finalClashCheck() throws ConvertException {
        OracleCallableStatement stmt = null;
        ConvertEvent event = new ConvertEvent(3, "", "");
        this.getAudience().fireListeners(event);
        try {
            stmt = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call MIGRATION.TRANSFORM_CLASHES(?)}");
            stmt.setLong(1, this.m_convertedConnectionId.getId());
            stmt.execute();
            event.setEventId(4);
            this.getAudience().fireListeners(event);
        }
        catch (SQLException sqlex) {
            throw new ConvertException(sqlex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void reportRemovedIndexes() {
        this.reportRemovedDuplicateIndexes();
        this.reportRemovedConstraintIndexes();
    }

    private void reportRemovedDuplicateIndexes() {
        try {
            ConvertUtils.logRemovedDuplicateIndexes(this.getPersistenceManager(), this.getConvertedConnectionId(), s_logger);
        }
        catch (PersistenceException pex) {
            MigrationLogUtil.logThrowable(pex.getLocalizedMessage(), "Convert", (Throwable)pex);
            return;
        }
    }

    private void reportRemovedConstraintIndexes() {
        try {
            ConvertUtils.logDroppedIndexesConstraintClash(this.getPersistenceManager(), this.getSourceConnectionId(), this.getConvertedConnectionId(), s_logger);
        }
        catch (PersistenceException pex) {
            MigrationLogUtil.logThrowable(pex.getLocalizedMessage(), "Convert", (Throwable)pex);
            return;
        }
    }

    private void reportCoalascedCatalogs() {
        ConvertUtils.CoalescedSchemaInfo[] info = null;
        try {
            info = ConvertUtils.getCoalascedSchema(this.getPersistenceManager(), this.getConvertedConnectionId());
        }
        catch (PersistenceException pex) {
            MigrationLogUtil.logThrowable(pex.getLocalizedMessage(), "Convert", (Throwable)pex);
            return;
        }
        if (info != null && info.length > 0) {
            for (ConvertUtils.CoalescedSchemaInfo coal : info) {
                if (coal.m_originalCatalogName == null || coal.m_originalCatalogName.trim().length() <= 0) continue;
                s_logger.log(Level.INFO, "Convert.COALESCED", coal.getDataAsObjectArray());
            }
        }
    }

    private void addCommentForTransformedColTabs() {
        DerivativesIterator allTransforms = ConvertUtils.getTransformedIdentifiers(this.getPersistenceManager(), this.getConvertedConnectionId());
        ResourceBundle bundle = s_logger.getResourceBundle();
        if (allTransforms.hasNext()) {
            do {
                MdDerivative derivative;
                String stringType;
                if ((stringType = bundle.getString((derivative = (MdDerivative)allTransforms.next()).getSrcType())).equalsIgnoreCase("Table")) {
                    this.processTableColComment(derivative, true);
                }
                if (!stringType.equalsIgnoreCase("Column")) continue;
                this.processTableColComment(derivative, false);
            } while (allTransforms.hasNext());
        }
    }

    private void processTableColComment(MdDerivative derivative, boolean Flag) {
        long id = derivative.getDerivedId().getId();
        try {
            String Comments;
            PreparedStatement stmt1 = Flag ? this.getPersistenceManager().getConn().prepareStatement(SELECT_COMMENTS_QUERY_RENAMED_TABLES) : this.getPersistenceManager().getConn().prepareStatement(SELECT_COMMENTS_QUERY_RENAMED_COLS);
            stmt1.setLong(1, id);
            ResultSet rs1 = stmt1.executeQuery();
            Comments = rs1.next() ? ((Comments = rs1.getString(1)) == null ? "" : " , " + Comments) : "";
            Comments = "ORIGINAL NAME:" + derivative.getOriginalIdentifier() + Comments;
            PreparedStatement stmt2 = Flag ? this.getPersistenceManager().getConn().prepareStatement(UPDATE_COMMENTS_QUERY_RENAMED_TABLES) : this.getPersistenceManager().getConn().prepareStatement(UPDATE_COMMENTS_QUERY_RENAMED_COLS);
            stmt2.setString(1, Comments);
            stmt2.setLong(2, id);
            stmt2.executeQuery();
            stmt1.close();
            stmt2.close();
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void reportTransformedIdentifiers() {
        DerivativesIterator allTransforms = ConvertUtils.getTransformedIdentifiers(this.getPersistenceManager(), this.getConvertedConnectionId());
        ResourceBundle bundle = s_logger.getResourceBundle();
        if (allTransforms.hasNext()) {
            MultiLevelLogManager manager = new MultiLevelLogManager();
            Object o = new Object();
            do {
                MdDerivative derivative = (MdDerivative)allTransforms.next();
                String printableType = bundle.getString(derivative.getSrcType());
                String reason = derivative.getNewIdentifier().length() > 30 ? bundle.getString("REASON_TOO_LONG") : bundle.getString("REASON_RESERVED");
                Object[] logParams = this.getLogParameters(derivative, printableType, reason);
                manager.logMessage(o, Level.INFO, "Convert.IDENTIFIER_TRANSFORM", logParams);
            } while (allTransforms.hasNext());
            manager.commitLog(Level.INFO, o, "Convert.IDENTIFIER_TRANSFORMED_HEADING", null);
        }
    }

    private Object[] getLogParameters(MdDerivative derivative, String printableType, String reason) {
        Object[] logParams = new Object[]{printableType, derivative.getOriginalIdentifier(), derivative.getNewIdentifier(), reason};
        try {
            if ("MD_VIEWS".equals(derivative.getDerivedType())) {
                MdView view = MdView.retrieveExistingInstance(this.getPersistenceManager(), derivative.getDerivedId());
                logParams = new Object[]{printableType, derivative.getOriginalIdentifier(), derivative.getNewIdentifier(), reason, new ClickableLogInfo(view, "Convert")};
            } else if ("MD_STORED_PROGRAMS".equals(derivative.getDerivedType())) {
                MdStoredProgram stProg = MdStoredProgram.retrieveExistingInstance(this.getPersistenceManager(), derivative.getDerivedId());
                logParams = new Object[]{printableType, derivative.getOriginalIdentifier(), derivative.getNewIdentifier(), reason, new ClickableLogInfo(stProg, "Convert")};
            } else if ("MD_TABLES".equals(derivative.getDerivedType())) {
                MdTable table = MdTable.retrieveExistingInstance(this.getPersistenceManager(), derivative.getDerivedId());
                logParams = new Object[]{printableType, derivative.getOriginalIdentifier(), derivative.getNewIdentifier(), reason, new ClickableLogInfo(table, "Convert")};
            } else if ("MD_CONSTRAINTS".equals(derivative.getDerivedType())) {
                MdConstraint constraint = MdConstraint.retrieveExistingInstance(this.getPersistenceManager(), derivative.getDerivedId());
                logParams = new Object[]{printableType, derivative.getOriginalIdentifier(), derivative.getNewIdentifier(), reason, new ClickableLogInfo(constraint, "Convert")};
            } else if ("MD_INDEXES".equals(derivative.getDerivedType())) {
                MdIndexe index = MdIndexe.retrieveExistingInstance(this.getPersistenceManager(), derivative.getDerivedId());
                logParams = new Object[]{printableType, derivative.getOriginalIdentifier(), derivative.getNewIdentifier(), reason, new ClickableLogInfo(index, "Convert")};
            } else if ("MD_TRIGGERS".equals(derivative.getDerivedType())) {
                MdTrigger trigger = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), derivative.getDerivedId());
                logParams = new Object[]{printableType, derivative.getOriginalIdentifier(), derivative.getNewIdentifier(), reason, new ClickableLogInfo(trigger, "Convert")};
            } else if ("MD_USERS".equals(derivative.getDerivedType())) {
                MdUser user = MdUser.retrieveExistingInstance(this.getPersistenceManager(), derivative.getDerivedId());
                logParams = new Object[]{printableType, derivative.getOriginalIdentifier(), derivative.getNewIdentifier(), reason, new ClickableLogInfo(user, "Convert")};
            } else if ("MD_SEQUENCES".equals(derivative.getDerivedType())) {
                MdSequence sequence = MdSequence.retrieveExistingInstance(this.getPersistenceManager(), derivative.getDerivedId());
                logParams = new Object[]{printableType, derivative.getOriginalIdentifier(), derivative.getNewIdentifier(), reason, new ClickableLogInfo(sequence, "Convert")};
            }
        }
        catch (PersistenceException e) {
        }
        catch (NoSuchObjectException e) {
            // empty catch block
        }
        return logParams;
    }

    private void reportDataTypeTransformResults() {
        this.reportTextIndexes();
        this.reportAutoChangedDataTypes();
        this.reportDroppedIndexes();
    }

    private void reportDroppedIndexes() {
        try {
            ConvertUtils.logDroppedNClobIndexes(this.getPersistenceManager(), this.getConvertedConnectionId(), s_logger);
        }
        catch (PersistenceException pex) {
            MigrationLogUtil.logThrowable(pex.getLocalizedMessage(), "Convert", (Throwable)pex);
        }
    }

    private void reportAutoChangedDataTypes() {
        try {
            ConvertUtils.logAutoChangedDataTypes(this.getPersistenceManager(), this.getConvertedConnectionId(), s_logger);
        }
        catch (PersistenceException pex) {
            MigrationLogUtil.logThrowable(pex.getLocalizedMessage(), "Convert", (Throwable)pex);
        }
    }

    private void reportTextIndexes() {
        TextIndexesIterator allTextIndexes = new TextIndexesIterator(this.getPersistenceManager(), this.getConvertedConnectionId(), "PROP_KEY = 'EXTENDEDINDEXTYPE'");
        if (allTextIndexes.hasNext()) {
            do {
                MdIndexe index = (MdIndexe)allTextIndexes.next();
                s_logger.log(Level.INFO, "Convert.TEXT_INDEX_CREATED", new Object[]{index.getIndexName(), index.getProperty("EXTENDEDINDEXTYPE"), new ClickableLogInfo(index, "Convert")});
            } while (allTextIndexes.hasNext());
        }
    }

    public void checkPlatformSpecificConversions() throws ConvertException {
        String[] platformSpecificPropertyKeys = this.m_platformConverter.getPropertyKeyList();
        String sMatchingKey = null;
        if (platformSpecificPropertyKeys != null && platformSpecificPropertyKeys.length > 0) {
            List<String> keyList = Arrays.asList(platformSpecificPropertyKeys);
            PropertyBasedPersitableObjectIterator iterator = new PropertyBasedPersitableObjectIterator(platformSpecificPropertyKeys, this.getPersistenceManager(), this.m_convertedConnectionId);
            while (iterator.hasNext()) {
                ConvertEvent event;
                if (this.shouldCancel()) {
                    event = new ConvertEvent(-1, "PLATFORM TRANSFORM", "");
                    this.getAudience().fireListeners(event);
                    iterator.close();
                    return;
                }
                Object pobj = iterator.next();
                AdditionalProperty[] props = ((PersistableObject)pobj).getAdditionalProperties();
                for (AdditionalProperty prop : props) {
                    if (!keyList.contains(prop.getKey())) continue;
                    sMatchingKey = prop.getKey();
                    break;
                }
                event = new ConvertEvent(16, ((PersistableObject)pobj).getObjectType(), "");
                this.getAudience().fireListeners(event);
                try {
                    ConvertResult result = this.m_platformConverter.convertObject((PersistableObject)pobj, sMatchingKey, this.getPersistenceManager());
                    event.setEventId(17);
                    this.getAudience().fireListeners(event);
                    if (result == null) continue;
                    if (result.getOriginal().isChanged()) {
                        result.getOriginal().save(this.getPersistenceManager());
                    }
                    if (result.getDerivedObjects() == null) continue;
                    for (PersistableObject derivedObj : result.getDerivedObjects()) {
                        derivedObj.save(this.getPersistenceManager());
                        MdDerivative derivative = new MdDerivative(result.getOriginal().getKey(), derivedObj.getKey(), this.m_convertedConnectionId);
                        derivative.save(this.getPersistenceManager());
                        if (!result.maintainOrder()) continue;
                        this.storeGenerationOrder(derivedObj);
                    }
                }
                catch (ConvertException convex) {
                    event.setEventId(18);
                    this.getAudience().fireListeners(event);
                }
                catch (PersistenceException pex) {
                    throw new ConvertException(pex);
                }
            }
            iterator.close();
        }
    }

    private void updateStatistics() throws PersistenceException {
        PersistenceUtility util = PersistenceUtility.getInstance(this.getPersistenceManager());
        util.updateConnectionStatistics(this.getConvertedConnection());
    }

    protected ConvertAudience getAudience() {
        return this.m_audience;
    }

    protected void setAudience(ConvertAudience audience) {
        this.m_audience = audience;
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    public void addEventListener(ConvertEventListener listener) {
        this.getAudience().addListener(listener);
    }

    @Override
    public void signalCancel() {
        this.m_context.signalCancel();
    }

    protected boolean shouldCancel() {
        return this.m_context.shouldCancel();
    }

    protected DBObjectId getSourceConnectionId() {
        return this.m_sourceConnectionId;
    }

    protected void setSourceConnectionId(DBObjectId sourceConnectionId) {
        this.m_sourceConnectionId = sourceConnectionId;
    }

    protected Converter getPlatformConverter() {
        return this.m_platformConverter;
    }

    protected void setPlatformConverter(Converter platformConverter) {
        this.m_platformConverter = platformConverter;
    }

    protected DBObjectId getConvertedConnectionId() {
        return this.m_convertedConnectionId;
    }

    public MdConnection getConvertedConnection() {
        return this.m_convertedConnection;
    }

    protected void setConvertedConnectionId(DBObjectId convertedConnectionId) throws PersistenceException, NoSuchObjectException {
        this.m_convertedConnectionId = convertedConnectionId;
        this.m_convertedConnection = MdConnection.retrieveExistingInstance(this.getPersistenceManager(), convertedConnectionId);
    }

    protected DBObjectId copyModel() throws ConvertException {
        OracleCallableStatement stmt = null;
        ConvertEvent event = new ConvertEvent(1, "MD_CONNECTIONS", "");
        this.getAudience().fireListeners(event);
        try {
            Object oracleArray;
            stmt = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.COPY_CONNECTION_CASCADE(?, ?)}");
            stmt.registerOutParameter(1, 4);
            stmt.setLong(2, this.m_sourceConnectionId.getId());
            if (this.m_filterList == null) {
                stmt.setNull(3, 2003, "MIGR_FILTER_SET");
            } else {
                oracleArray = MigrationUtils.migrationFilterListAsARRAY(this.m_filterList, this.getPersistenceManager().getConn());
                stmt.setARRAY(3, oracleArray);
            }
            stmt.execute();
            long lRet = stmt.getLong(1);
            this.setConvertedConnectionId(new DBObjectId(lRet));
            event.setEventId(2);
            MigrationLogUtil.startMigrationLogSession(this.getConvertedConnectionId());
            this.getAudience().fireListeners(event);
            oracleArray = new DBObjectId(lRet);
            return oracleArray;
        }
        catch (SQLException sqlex) {
            throw new ConvertException(sqlex);
        }
        catch (PersistenceException pex) {
            throw new ConvertException(pex);
        }
        catch (NoSuchObjectException nsoe) {
            throw new ConvertException(nsoe);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected void transformIdentifiers() throws ConvertException {
        OracleCallableStatement stmt = null;
        ConvertEvent event = new ConvertEvent(3, "", "");
        this.getAudience().fireListeners(event);
        try {
            Datum[] contents;
            stmt = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.TRANSFORM_ALL_IDENTIFIERS(?,?)}");
            stmt.registerOutParameter(1, 2003, "NAME_AND_COUNT_ARRAY");
            stmt.setLong(2, this.getConvertedConnectionId().getId());
            stmt.setString(3, MigrationAddin.getMigrationConfig().getNamePrefix());
            stmt.execute();
            ARRAY ar = stmt.getARRAY(1);
            for (Datum datum : contents = ar.getOracleArray()) {
                STRUCT st = (STRUCT)datum;
                Object[] attrs = st.getAttributes();
                String name = (String)attrs[0];
                BigDecimal count = (BigDecimal)attrs[1];
                event = new ConvertEvent(5, name, "");
                this.getAudience().fireListeners(event);
            }
            event = new ConvertEvent(4, "", "");
            this.getAudience().fireListeners(event);
        }
        catch (SQLException sqlex) {
            throw new ConvertException(sqlex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void transformDataTypes() throws ConvertException {
        OracleCallableStatement stmt = null;
        ConvertEvent event = new ConvertEvent(6, "", "");
        this.getAudience().fireListeners(event);
        try {
            stmt = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.TRANSFORM_DATATYPES(?, ?, ?)}");
            stmt.registerOutParameter(1, 4);
            stmt.setLong(2, this.getConvertedConnectionId().getId());
            stmt.setLong(3, this.getMapId().getId());
            if (this.m_targettingMultibyte) {
                stmt.setInt(4, 2);
            } else {
                stmt.setInt(4, 1);
            }
            stmt.execute();
            long lRet = stmt.getLong(1);
            event = new ConvertEvent(7, "", "");
            this.getAudience().fireListeners(event);
            if (stmt == null) return;
        }
        catch (SQLException sqlex) {
            try {
                throw new ConvertException(sqlex);
            }
            catch (Throwable throwable) {
                if (stmt == null) throw throwable;
                CloseableResultSet.close(stmt, null);
                throw throwable;
            }
        }
        CloseableResultSet.close((Statement)stmt, null);
        return;
    }

    protected void transformDefaults() throws ConvertException {
        String defMsgChange = MigrationAddinArb.getString(301);
        CloseableResultSet crs = null;
        ConvertEvent event = new ConvertEvent(10, "MD_COLUMNS", "");
        this.getAudience().fireListeners(event);
        TextMappingRuleSet defaultMappingRuleSet = this.getPlatformConverter().getDefaultValueMappingRules();
        try {
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement(QUERY_COLS_WITH_DEFAULTS);
            stmt.setLong(1, this.getConvertedConnectionId().getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            HashMap logInformation = new HashMap();
            while (rs.next()) {
                TransformDefaultWrapper helper;
                String defVal = rs.getString(2);
                TextMappingResult textMappingResult = defaultMappingRuleSet.applyRules(defVal);
                MdColumn column = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), new DBObjectId(rs.getLong(1)));
                DBObjectId tableId = column.getTableId();
                MdTable table = MdTable.retrieveExistingInstance(this.getPersistenceManager(), tableId);
                DBObjectId schemaId = table.getSchemaId();
                MdSchema schema = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), schemaId);
                if (textMappingResult == null) continue;
                String replace = textMappingResult.getResultingString();
                String message = MessageFormat.format(defMsgChange, defVal, replace);
                ArrayList<TransformDefaultWrapper> objectInformation = (ArrayList<TransformDefaultWrapper>)logInformation.get(message);
                if (!logInformation.containsKey(message)) {
                    objectInformation = new ArrayList<TransformDefaultWrapper>();
                }
                if (textMappingResult.shouldWarn()) {
                    helper = this.createDefaultWrapper(column, table, schema, Level.WARNING);
                    objectInformation.add(helper);
                    logInformation.put(message, objectInformation);
                } else {
                    helper = this.createDefaultWrapper(column, table, schema, Level.INFO);
                    objectInformation.add(helper);
                    logInformation.put(message, objectInformation);
                }
                this.getAudience().fireListeners(event);
                column.setDefaultValue(replace);
                column.save(this.getPersistenceManager());
            }
            LogInfo firstLevelRec = new LogInfo("");
            Set keySet = logInformation.keySet();
            for (String element : keySet) {
                ArrayList arrayList = (ArrayList)logInformation.get(element);
                LogInfo rootLogInfo = new LogInfo("Convert");
                for (TransformDefaultWrapper helper : arrayList) {
                    LogRecord rec = new LogRecord(helper.getLevel(), helper.getMessage());
                    ClickableLogInfo cl = new ClickableLogInfo(helper.getTable(), "Convert");
                    cl.addSupplementaryInfo(helper.getColumn());
                    rec.setParameters(new Object[]{cl});
                    rootLogInfo.addChild(rec);
                }
                LogRecord messageRecord = new LogRecord(Level.WARNING, element);
                messageRecord.setParameters(new Object[]{rootLogInfo});
                firstLevelRec.addChild(messageRecord);
            }
            if (firstLevelRec.hasChildren()) {
                Logger logger = Logger.getLogger("oracle.dbtools.migration");
                logger.log(Level.WARNING, "Convert.DEFAULT_LOG_HEADER", new Object[]{firstLevelRec});
            }
        }
        catch (SQLException sqlex) {
            throw new ConvertException(sqlex);
        }
        catch (NoSuchObjectException nsoe) {
            throw new ConvertException(nsoe);
        }
        catch (PersistenceException pex) {
            throw new ConvertException(pex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
        event = new ConvertEvent(12, "MD_COLUMNS", "");
        this.getAudience().fireListeners(event);
    }

    private TransformDefaultWrapper createDefaultWrapper(MdColumn column, MdTable table, MdSchema schema, Level level) {
        TransformDefaultWrapper wrapper = new TransformDefaultWrapper();
        wrapper.setSchema(schema);
        wrapper.setTable(table);
        wrapper.setColumn(column);
        wrapper.setLevel(level);
        wrapper.setMessage(schema.getName() + "." + table.getTableName() + "." + column.getColumnName());
        return wrapper;
    }

    protected void transformCodeSegments() throws ConvertException {
        TranslationContext nameCache;
        ITranslator translator = this.getPlatformConverter().getPlaformTranslator();
        this.m_translationLogging = new TranslationLogging(this.getPersistenceManager(), this.m_translationLogManager);
        if (translator == null) {
            return;
        }
        try {
            nameCache = new TranslationContext(this.getPersistenceManager(), this.getConvertedConnectionId(), 100, this.m_mapId);
        }
        catch (PersistenceException pex) {
            throw new ConvertException(pex);
        }
        this.setTranslationSession(translator.startTranslationSession());
        PersistenceUtility util = PersistenceUtility.getInstance(this.getPersistenceManager());
        this.translateCheckConstraints(translator, util, nameCache);
        if (this.shouldCancel()) {
            ConvertEvent event = new ConvertEvent(-1, "TRANSLATE", "");
            this.getAudience().fireListeners(event);
            return;
        }
        this.translateViewDefinitions(translator, util, nameCache);
        if (this.shouldCancel()) {
            ConvertEvent event = new ConvertEvent(-1, "TRANSLATE", "");
            this.getAudience().fireListeners(event);
            return;
        }
        this.translateStoredPrograms(translator, util, nameCache);
        if (this.shouldCancel()) {
            ConvertEvent event = new ConvertEvent(-1, "TRANSLATE", "");
            this.getAudience().fireListeners(event);
            return;
        }
        this.translateTriggers(translator, util, nameCache);
        try {
            this.getEmulationPackages(translator, nameCache);
        }
        catch (PersistenceException pex) {
            throw new ConvertException(pex);
        }
    }

    private void storeGenerationOrder(PersistableObject po) throws PersistenceException {
        MigrGenerationOrder newOrder = new MigrGenerationOrder(this.m_convertedConnectionId, po.getKey(), po.getObjectType(), this.m_generationOrder++);
        this.m_translatedTargetObjects.add(po.getKey());
        newOrder.save(this.getPersistenceManager());
    }

    protected void translateCheckConstraints(ITranslator translator, PersistenceUtility util, ITranslationContext context) throws ConvertException {
        CloseableIterator checkConstraints = null;
        MdConstraint constraint = null;
        try {
            checkConstraints = util.getCheckConstraintsForConectionId(this.getSourceConnectionId(), this.m_filterList);
            while (checkConstraints.hasNext()) {
                constraint = (MdConstraint)checkConstraints.next();
                if (this.isTranslating(constraint.getKey().getId()) || this.isTranslated(constraint.getKey().getId())) continue;
                this.translateIndividualCheckConstraint(translator, constraint, context);
            }
        }
        catch (PersistenceException pex) {
            throw new ConvertException(pex);
        }
        finally {
            if (checkConstraints != null) {
                checkConstraints.close();
            }
        }
    }

    protected void translateIndividualCheckConstraint(ITranslator translator, MdConstraint constraint, ITranslationContext context) throws ConvertException {
        this.m_translatingObjects.push(constraint.getKey().getId());
        try {
            String condition = MigrationUtils.findCheckConstraintCondition(constraint, this.getPersistenceManager());
            PersistenceUtility util = PersistenceUtility.getInstance(this.getPersistenceManager());
            String host = util.getHostForConnection(this.getSourceConnectionId());
            String tableName = null;
            String columnName = null;
            try {
                MdConstraintDetail detail;
                MdTable table = MdTable.retrieveExistingInstance(this.getPersistenceManager(), constraint.getTableId());
                tableName = table.getTableName();
                CloseableIterator details = util.getConstraintDetails(constraint.getKey());
                if (details != null && details.hasNext() && (detail = (MdConstraintDetail)details.next()) != null) {
                    MdColumn column = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), detail.getColumnId());
                    columnName = column.getColumnName();
                    context.addInfoKeyValue("CONSTRAINT_COLUMN", columnName);
                    details.close();
                }
            }
            catch (NoSuchObjectException nsoe) {
                Logger.getLogger("oracle.dbtools.migration").logp(Level.SEVERE, "Class", "Convert", nsoe.getMessage(), nsoe);
                s_logger.warning(nsoe.getLocalizedMessage());
            }
            TranslationDBObjectReference sourceRef = new TranslationDBObjectReference(host, "NA", "NA", tableName, constraint.getName(), TranslationObjectType.CONSTRAINT_TYPE, (Object)constraint);
            TranslationDBObject sourceObj = new TranslationDBObject(sourceRef, condition);
            ConvertEvent event = new ConvertEvent(8, "CONSTRAINT", constraint.getName());
            this.getAudience().fireListeners(event);
            TranslationResult translationResult = translator.translate(sourceObj, context, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
            context.clearInfoKey();
            if (translationResult != null) {
                MdConstraint translatedConstraint;
                if (translationResult.getTargetObject().getType().equals(TranslationObjectType.CONSTRAINT_TYPE)) {
                    translatedConstraint = ConvertUtils.findConstraintCopy(constraint, this.getPersistenceManager(), this.getConvertedConnectionId());
                    translatedConstraint.setConstraintText(translationResult.getTargetObject().getDdl());
                    translatedConstraint.setLanguage("OracleSQL");
                    translatedConstraint.save(this.getPersistenceManager());
                    this.m_translationLogManager.commitLog(Level.INFO, constraint, ConverterWorker.multiLogHeader("MD_CONSTRAINTS", constraint.getName()), translatedConstraint);
                    this.storeGenerationOrder(translatedConstraint);
                } else if (translationResult.getTargetObject().getType().equals(TranslationObjectType.TRIGGER_TYPE)) {
                    translatedConstraint = ConvertUtils.findConstraintCopy(constraint, this.getPersistenceManager(), this.getConvertedConnectionId());
                    MdTrigger translatedTrigger = new MdTrigger(translatedConstraint.getTableId(), "T", "OracleSQL");
                    ConvertUtils.removeDerivedConstraint(this.getPersistenceManager(), translatedConstraint, this.m_convertedConnectionId);
                    translatedTrigger.setTriggerName(translationResult.getTargetObject().getObjName());
                    translatedTrigger.setNativeSql(new ClobHelper(translationResult.getTargetObject().getDdl()));
                    translatedTrigger.save(this.getPersistenceManager());
                    MdDerivative derivative = new MdDerivative(constraint.getKey(), translatedTrigger.getKey(), this.m_convertedConnectionId);
                    derivative.save(this.getPersistenceManager());
                    this.m_translationLogManager.commitLog(Level.INFO, constraint, ConverterWorker.multiLogHeader("MD_CONSTRAINTS", constraint.getName()), translatedTrigger);
                    this.storeGenerationOrder(translatedTrigger);
                }
            }
            event.setEventId(9);
            this.getAudience().fireListeners(event);
        }
        catch (NoCopyFoundException ncfe) {
            throw new ConvertException(ncfe);
        }
        catch (TranslationException tex) {
            s_logger.log(Level.SEVERE, MigrationAddinArb.getString(302) + " " + MigrationAddinArb.getString(139) + " " + constraint.getName() + " " + tex.getLocalizedMessage(), new Object[]{new ClickableLogInfo(constraint, "Convert")});
        }
        catch (PersistenceException pex) {
            throw new ConvertException(pex);
        }
        catch (NoSuchObjectException nsoe) {
            throw new ConvertException(nsoe);
        }
        finally {
            this.setSourceTranslated(constraint);
            this.m_translatingObjects.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getEmulationPackages(ITranslator translator, ITranslationContext nameCache) throws PersistenceException {
        boolean forEachSchema = true;
        PersistenceUtility util = PersistenceUtility.getInstance(this.getPersistenceManager());
        CloseableIterator<MgvAllSchemasRec> allSchemas = util.getSchemasForConnectionId(this.m_convertedConnectionId);
        try {
            int schemaCounter = 0;
            MdPackage masterPackage = null;
            while (allSchemas.hasNext()) {
                MdSchema schema;
                ++schemaCounter;
                MgvAllSchemasRec rec = (MgvAllSchemasRec)allSchemas.next();
                try {
                    schema = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), rec.getSchemaId());
                }
                catch (NoSuchObjectException nsoe) {
                    throw new PersistenceException(nsoe);
                }
                if (forEachSchema) {
                    this.addPackageForSchema(schema, translator, nameCache);
                    continue;
                }
                if (schemaCounter == 1) {
                    masterPackage = this.addPackageForSchema(schema, translator, this.m_convertedConnectionId, nameCache);
                    continue;
                }
                this.addSynonymForPackage(schema, masterPackage);
            }
        }
        finally {
            allSchemas.close();
        }
    }

    private void addSynonymForPackage(MdSchema schema, MdPackage masterPackage) {
    }

    private MdPackage addPackageForSchema(MdSchema schema, ITranslator translator, ITranslationContext context) {
        TranslationDBObjectReference targetPackageRef = new TranslationDBObjectReference("N/A", "N/A", schema.getName(), "migration_util", null, TranslationObjectType.PACKAGE_TYPE);
        TranslationResult result = null;
        try {
            result = translator.getEmulationPackageForSchema((Object)schema.getKey(), targetPackageRef, context);
        }
        catch (TranslationException e) {
            s_logger.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        if (result != null) {
            return this.saveResultAsPackage(result, schema);
        }
        return null;
    }

    private MdPackage addPackageForSchema(MdSchema schema, ITranslator translator, DBObjectId connectionId, ITranslationContext context) {
        TranslationDBObjectReference targetPackageRef = new TranslationDBObjectReference("N/A", "N/A", schema.getName(), "migration_util", null, TranslationObjectType.PACKAGE_TYPE);
        TranslationResult result = null;
        try {
            result = translator.getEmulationPackageForConnection((Object)connectionId, targetPackageRef, context);
        }
        catch (TranslationException e) {
            s_logger.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        if (result != null) {
            return this.saveResultAsPackage(result, schema);
        }
        return null;
    }

    private MdPackage saveResultAsPackage(TranslationResult result, MdSchema targetSchema) {
        if (result == null) {
            return null;
        }
        TranslationDBObject emulationPkgHeader = null;
        TranslationDBObject emulationPkgBody = null;
        MdPackage mdpackage = null;
        emulationPkgHeader = result.getTargetObject();
        if (result.getExtraObjects() != null) {
            emulationPkgBody = (TranslationDBObject)result.getExtraObjects().get(0);
        }
        mdpackage = new MdPackage(targetSchema.getKey(), emulationPkgHeader.getObjName(), "OracleSQL");
        mdpackage.setPackageHeader(emulationPkgHeader.getDdl());
        if (emulationPkgBody != null) {
            mdpackage.setNativeSql(emulationPkgBody.getDdl());
        }
        mdpackage.addProperty("MIGRATIONEMULATION", "Y", this.m_convertedConnectionId);
        try {
            mdpackage.save(this.getPersistenceManager());
        }
        catch (PersistenceException e) {
            MigrationLogUtil.logThrowable(e.getLocalizedMessage(), "Convert", (Throwable)e);
        }
        return mdpackage;
    }

    protected void translateViewTriggers(ITranslator translator, PersistenceUtility util, TranslationContext context) throws ConvertException {
        CloseableIterator<MgvAllViewTriggersRec> it = null;
        try {
            it = util.getViewTriggersForConnectionId(this.getSourceConnectionId());
            while (it.hasNext()) {
                MgvAllViewTriggersRec rec = (MgvAllViewTriggersRec)it.next();
                if (this.isTranslated(rec.getTriggerId().getId()) || this.isTranslating(rec.getTriggerId().getId())) continue;
                MdTrigger trigger = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), rec.getTriggerId());
                TranslationDBObject srcObj = null;
                try {
                    String host = util.getHostForConnection(rec.getConnectionId());
                    srcObj = ConvertUtils.asTranslationDBObject(host, rec.getCatalogName(), rec.getSchemaName(), trigger);
                }
                catch (IOException ioe) {
                    MigrationLogUtil.logThrowable(ioe.getLocalizedMessage(), "Convert", (Throwable)ioe);
                }
                this.translateIndividualViewTrigger(translator, context, srcObj, trigger);
            }
        }
        catch (PersistenceException pex) {
            throw new ConvertException(pex);
        }
        catch (NoSuchObjectException nsoe) {
            throw new ConvertException(nsoe);
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateIndividualViewTrigger(ITranslator translator, TranslationContext context, TranslationDBObject srcObj, MdTrigger trigger) throws PersistenceException, NoSuchObjectException {
        this.m_translatingObjects.push(trigger.getKey().getId());
        try {
            ConvertEvent event = new ConvertEvent(8, "MD_TRIGGERS", trigger.getTriggerName());
            this.getAudience().fireListeners(event);
            TranslationResult retObj = translator.translate(srcObj, (ITranslationContext)context, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
            MdTrigger derivedTrigger = ConvertUtils.findTriggerCopy(trigger, this.getPersistenceManager(), this.getConvertedConnectionId());
            derivedTrigger.setNativeSql(retObj.getFullDdlScript());
            derivedTrigger.setLanguage("OracleSQL");
            derivedTrigger.save(this.getPersistenceManager());
            this.m_translationLogManager.commitLog(Level.INFO, trigger, ConverterWorker.multiLogHeader("MD_TRIGGERS", trigger.getTriggerName()), derivedTrigger);
            this.storeGenerationOrder(derivedTrigger);
            event.setEventId(9);
            this.getAudience().fireListeners(event);
        }
        catch (NoCopyFoundException ncfe) {
            MigrationLogUtil.logThrowable(ncfe.getLocalizedMessage(), "Convert", (Throwable)ncfe);
        }
        catch (TranslationException tex) {
            s_logger.log(Level.SEVERE, MigrationAddinArb.getString(302) + " " + MigrationAddinArb.getString(135) + " " + trigger.getTriggerName() + " " + tex.getLocalizedMessage(), new Object[]{new ClickableLogInfo(trigger, "Convert")});
        }
        finally {
            this.setSourceTranslated(trigger);
            this.m_translatingObjects.pop();
        }
    }

    private void translateTableTriggers(ITranslator translator, PersistenceUtility util, TranslationContext context) throws ConvertException {
        CloseableIterator<MgvAllTableTriggersRec> it = null;
        try {
            it = util.getTableTriggersForConnectionId(this.getSourceConnectionId());
            while (it.hasNext()) {
                MdTrigger trigger;
                MgvAllTableTriggersRec rec = (MgvAllTableTriggersRec)it.next();
                if (this.isTranslated(rec.getTriggerId().getId()) || this.isTranslating(rec.getTriggerId().getId()) || (trigger = MdTrigger.retrieveExistingInstance(this.getPersistenceManager(), rec.getTriggerId())).getLanguage().equals("OracleSQL")) continue;
                try {
                    String host = util.getHostForConnection(rec.getConnectionId());
                    TranslationDBObject srcObj = ConvertUtils.asTranslationDBObject(host, rec.getCatalogName(), rec.getSchemaName(), trigger);
                    this.translateIndividualTableTrigger(translator, context, srcObj, trigger);
                }
                catch (IOException ioe) {
                    MigrationLogUtil.logThrowable(ioe.getLocalizedMessage(), "Convert", (Throwable)ioe);
                }
            }
        }
        catch (PersistenceException pex) {
            throw new ConvertException(pex);
        }
        catch (NoSuchObjectException nsoe) {
            throw new ConvertException(nsoe);
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateIndividualTableTrigger(ITranslator translator, TranslationContext context, TranslationDBObject srcObj, MdTrigger trigger) throws PersistenceException, NoSuchObjectException {
        this.m_translatingObjects.push(trigger.getKey().getId());
        try {
            ConvertEvent event = new ConvertEvent(8, "MD_TRIGGERS", trigger.getTriggerName());
            this.getAudience().fireListeners(event);
            TranslationResult retObj = translator.translate(srcObj, (ITranslationContext)context, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
            MdTrigger derivedTrigger = ConvertUtils.findTriggerCopy(trigger, this.getPersistenceManager(), this.getConvertedConnectionId());
            derivedTrigger.setNativeSql(retObj.getFullDdlScript());
            derivedTrigger.setLanguage("OracleSQL");
            derivedTrigger.save(this.getPersistenceManager());
            this.m_translationLogManager.commitLog(Level.INFO, trigger, ConverterWorker.multiLogHeader("MD_TRIGGERS", trigger.getTriggerName()), derivedTrigger);
            this.storeGenerationOrder(derivedTrigger);
            event.setEventId(9);
            this.getAudience().fireListeners(event);
        }
        catch (TranslationException tex) {
            s_logger.log(Level.SEVERE, MigrationAddinArb.getString(302) + " " + MigrationAddinArb.getString(135) + " " + trigger.getTriggerName() + " " + tex.getLocalizedMessage(), new Object[]{new ClickableLogInfo(trigger, "Convert")});
        }
        catch (NoCopyFoundException ncfe) {
            MigrationLogUtil.logThrowable(ncfe.getLocalizedMessage(), "", (Throwable)ncfe);
        }
        finally {
            this.setSourceTranslated(trigger);
            this.m_translatingObjects.pop();
        }
    }

    private void translateTriggers(ITranslator translator, PersistenceUtility util, TranslationContext context) throws ConvertException {
        this.translateViewTriggers(translator, util, context);
        this.translateTableTriggers(translator, util, context);
    }

    private void translateStoredPrograms(ITranslator translator, PersistenceUtility util, TranslationContext context) throws ConvertException {
        CloseableIterator<MgvAllStoredProgramsRec> it = null;
        try {
            it = util.getStoredProgramsForConnectionId(this.getSourceConnectionId());
            while (it.hasNext()) {
                MgvAllStoredProgramsRec rec = (MgvAllStoredProgramsRec)it.next();
                if (this.isTranslated(rec.getStoredProgramId().getId()) || this.isTranslating(rec.getStoredProgramId().getId())) continue;
                MdStoredProgram program = MdStoredProgram.retrieveExistingInstance(this.getPersistenceManager(), rec.getStoredProgramId());
                try {
                    String host = util.getHostForConnection(rec.getConnectionId());
                    TranslationDBObject srcObj = ConvertUtils.asDBObject(host, rec.getCatalogName(), rec.getSchemaName(), program);
                    this.translateIndividualStoredProgram(translator, context, srcObj, program);
                }
                catch (IOException e) {
                    Logger.getLogger("oracle.dbtools.migration").logp(Level.SEVERE, "Class", "Convert", e.getMessage(), e);
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
        catch (PersistenceException pex) {
            throw new ConvertException(pex);
        }
        catch (NoSuchObjectException nsoe) {
            throw new ConvertException(nsoe);
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateIndividualStoredProgram(ITranslator translator, TranslationContext context, TranslationDBObject srcObj, MdStoredProgram program) throws PersistenceException, NoSuchObjectException {
        ConvertEvent event = null;
        this.m_translatingObjects.push(program.getKey().getId());
        try {
            event = new ConvertEvent(8, "MD_STORED_PROGRAMS", program.getName());
            this.getAudience().fireListeners(event);
            TranslationResult retObj = translator.translate(srcObj, (ITranslationContext)context, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
            MdStoredProgram convertedProg = ConvertUtils.findProgramCopy(program, this.getPersistenceManager(), this.getConvertedConnectionId());
            convertedProg.setNativeSql(retObj.getFullDdlScript());
            convertedProg.setLanguage("OracleSQL");
            convertedProg.save(this.getPersistenceManager());
            this.m_translationLogManager.commitLog(Level.INFO, program, ConverterWorker.multiLogHeader("MD_STORED_PROGRAMS", program.getName()), convertedProg);
            this.storeGenerationOrder(convertedProg);
            this.persistMetaData(retObj, srcObj.getDBObjectReference());
            event.setEventId(9);
            this.getAudience().fireListeners(event);
        }
        catch (TranslationException tex) {
            try {
                MdStoredProgram convertedProg = ConvertUtils.findProgramCopy(program, this.getPersistenceManager(), this.getConvertedConnectionId());
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString(302) + " " + MigrationAddinArb.getString(136) + " " + convertedProg.getName() + " " + tex.getLocalizedMessage(), new Object[]{new ClickableLogInfo(convertedProg, "Convert")});
            }
            catch (Exception e) {
                s_logger.log(Level.SEVERE, MigrationAddinArb.getString(302) + " " + MigrationAddinArb.getString(136) + " " + program.getName() + " " + tex.getLocalizedMessage(), new Object[]{new ClickableLogInfo(program, "Convert")});
            }
        }
        catch (NoCopyFoundException ncfe) {
            MigrationLogUtil.logThrowable(ncfe.getLocalizedMessage(), "Convert", (Throwable)ncfe);
        }
        finally {
            this.setSourceTranslated(program);
            this.m_translatingObjects.pop();
        }
    }

    private void persistMetaData(TranslationResult retObj, TranslationDBObjectReference sourceObjRef) {
        ITranslationMetaData metadata = retObj.getTranslationMetaData();
        if (metadata == null) {
            return;
        }
        DBObjectId sourceConnectionID = this.getSourceConnectionId();
        DBObjectId targetConnectionID = this.getConvertedConnectionId();
        DBObjectId targetObjectId = ((PersistableObject)retObj.getTargetObject().getOMWBObj()).getKey();
        DBObjectId sourceObjectId = ((PersistableObject)sourceObjRef.getOMWBObj()).getKey();
        String targetObjectType = ((PersistableObject)retObj.getTargetObject().getOMWBObj()).getObjectType();
        String sourceObjectType = ((PersistableObject)sourceObjRef.getOMWBObj()).getObjectType();
        this.persistSourceParameters(metadata.getSourceParameters(), sourceConnectionID, sourceObjectId, sourceObjectType);
        this.persistTargetParameters(metadata.getTargetParameters(), targetConnectionID, targetObjectId, targetObjectType);
    }

    private void persistTargetParameters(ArrayList<TranslationParameter> targetParameters, DBObjectId targetConnectionID, DBObjectId targetObjectID, String targetObjectType) {
        for (TranslationParameter param : targetParameters) {
            int paramExisting = param.isExtra() ? 1 : 0;
            int paramOrder = param.getParamPosition();
            String paramName = param.getName();
            String paramType = param.getParamType();
            if (param.getDataType() == null) {
                return;
            }
            String paramDataType = param.getDataType().getDataType();
            String nullable = "Y";
            MdMigrParameter migrParameter = new MdMigrParameter(targetConnectionID, targetObjectID, targetObjectType, paramExisting, paramOrder, paramName, paramType, paramDataType, nullable);
            try {
                migrParameter.save(this.getPersistenceManager());
            }
            catch (PersistenceException e) {
                Logger.getLogger("oracle.dbtools.migration").logp(Level.SEVERE, "Class", "Convert", e.getMessage(), e);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    private void persistSourceParameters(ArrayList<TranslationParameter> sourceParameters, DBObjectId sourceConnectionID, DBObjectId sourceObjectID, String sourceObjectType) {
        for (TranslationParameter param : sourceParameters) {
            int paramExisting = 0;
            int paramOrder = param.getParamPosition();
            String paramName = param.getName();
            String paramType = param.getParamType();
            String paramDataType = param.getDataType().getDataType();
            String nullable = "Y";
            MdMigrParameter migrParameter = new MdMigrParameter(sourceConnectionID, sourceObjectID, sourceObjectType, paramExisting, paramOrder, paramName, paramType, paramDataType, nullable);
            try {
                migrParameter.save(this.getPersistenceManager());
            }
            catch (PersistenceException e) {
                Logger.getLogger("oracle.dbtools.migration").logp(Level.SEVERE, "Class", "Convert", e.getMessage(), e);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    private void translateViewDefinitions(ITranslator translator, PersistenceUtility util, ITranslationContext context) throws ConvertException {
        CloseableIterator<MgvAllViewsRec> it = null;
        try {
            it = util.getViewsForConnectionId(this.getSourceConnectionId());
            while (it.hasNext()) {
                MgvAllViewsRec rec = (MgvAllViewsRec)it.next();
                if (this.isTranslated(rec.getViewId().getId()) || this.isTranslating(rec.getViewId().getId())) continue;
                MdView view = MdView.retrieveExistingInstance(this.getPersistenceManager(), rec.getViewId());
                String host = util.getHostForConnection(rec.getConnectionId());
                TranslationDBObject srcObj = ConvertUtils.asDBObject(host, rec.getCatalogName(), rec.getSchemaName(), view);
                this.translateIndividualViewDefinition(translator, context, srcObj, view);
            }
        }
        catch (PersistenceException pex) {
            throw new ConvertException(pex);
        }
        catch (NoSuchObjectException nsoe) {
            throw new ConvertException(nsoe);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            throw new ConvertException(e);
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void translateIndividualViewDefinition(ITranslator translator, ITranslationContext context, TranslationDBObject srcObj, MdView view) throws PersistenceException, NoSuchObjectException {
        this.m_translatingObjects.push(view.getKey().getId());
        try {
            if (ConvertUtils.findObjectCopy(this.getPersistenceManager(), view.getKey(), "MD_VIEWS", this.getConvertedConnectionId()) == null && this.m_filterList != null) {
                return;
            }
            ConvertEvent event = new ConvertEvent(8, "MD_VIEWS", view.getViewName());
            this.getAudience().fireListeners(event);
            TranslationResult retObj = translator.translate(srcObj, context, this.m_translationLogging, (ITranslationManager)this, this.getTranslationSession());
            MdView convertedView = ConvertUtils.findViewCopy(view, this.getPersistenceManager(), this.getConvertedConnectionId());
            convertedView.setNativeSql(retObj.getFullDdlScript());
            convertedView.setLanguage("OracleSQL");
            convertedView.save(this.getPersistenceManager());
            this.m_translationLogManager.commitLog(Level.INFO, view, ConverterWorker.multiLogHeader("MD_VIEWS", view.getViewName()), convertedView);
            this.storeGenerationOrder(convertedView);
            event.setEventId(9);
            this.getAudience().fireListeners(event);
        }
        catch (TranslationException tex) {
            try {
                MdView convertedView = ConvertUtils.findViewCopy(view, this.getPersistenceManager(), this.getConvertedConnectionId());
                MigrationLogUtil.logThrowable(MigrationAddinArb.getString(302) + " " + MigrationAddinArb.getString(137) + " " + convertedView.getViewName() + " " + tex.getLocalizedMessage(), new Object[]{new ClickableLogInfo(convertedView, "Convert")}, (Throwable)tex);
            }
            catch (Exception e) {
                MigrationLogUtil.logThrowable(MigrationAddinArb.getString(302) + " " + MigrationAddinArb.getString(137) + " " + view.getViewName() + " " + tex.getLocalizedMessage(), new Object[]{new ClickableLogInfo(view, "Convert")}, (Throwable)tex);
            }
        }
        catch (NoCopyFoundException ncfe) {
            MigrationLogUtil.logThrowable(ncfe.getLocalizedMessage(), "Convert", (Throwable)ncfe);
        }
        catch (Exception e) {
        }
        finally {
            this.setSourceTranslated(view);
            this.m_translatingObjects.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transformIdentityColumns() throws ConvertException {
        OracleCallableStatement stmt = null;
        ConvertEvent event = new ConvertEvent(13, "MD_COLUMNS", "");
        this.getAudience().fireListeners(event);
        try {
            stmt = (OracleCallableStatement)this.getPersistenceManager().getConn().prepareCall("{call ? := MIGRATION.TRANSFORM_IDENTITY_COLUMNS(?)}");
            stmt.registerOutParameter(1, 4);
            stmt.setLong(2, this.getConvertedConnectionId().getId());
            stmt.execute();
            long lRet = stmt.getLong(1);
            event.setEventId(14);
            this.getAudience().fireListeners(event);
        }
        catch (SQLException sqlex) {
            MigrationLogUtil.logThrowable(sqlex.getLocalizedMessage(), "Convert", (Throwable)sqlex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlex) {}
            }
        }
    }

    protected void setMapId(DBObjectId mapId) {
        this.m_mapId = mapId;
    }

    protected DBObjectId getMapId() {
        return this.m_mapId;
    }

    protected TranslationSession getTranslationSession() {
        return this.m_translationSession;
    }

    protected void setTranslationSession(TranslationSession translationSession) {
        this.m_translationSession = translationSession;
    }

    public boolean isTranslated(Object omwbObj) {
        if (omwbObj instanceof PersistableObject) {
            return this.m_translatedSourceObjects.contains(((PersistableObject)omwbObj).getKey());
        }
        if (omwbObj instanceof Long) {
            return this.m_translatedSourceObjects.contains(new DBObjectId((Long)omwbObj));
        }
        return false;
    }

    public boolean isTranslating(Object omwbObj) {
        return omwbObj instanceof PersistableObject ? this.m_translatingObjects.contains(((PersistableObject)omwbObj).getKey().getId()) : omwbObj instanceof Long && this.m_translatingObjects.contains(omwbObj);
    }

    public void translate(Object omwbObj) {
        PersistableObject poObject = (PersistableObject)omwbObj;
        ITranslator translator = this.getPlatformConverter().getPlaformTranslator();
        TranslationContext context = null;
        try {
            context = new TranslationContext(this.getPersistenceManager(), this.getConvertedConnectionId(), 100, this.m_mapId);
        }
        catch (PersistenceException e) {
            Logger.getLogger("oracle.dbtools.migration").logp(Level.SEVERE, "Class", "Convert", e.getMessage(), e);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        try {
            TranslationDBObject srcObj = ConvertUtils.asTranslationDBObject(poObject, this.getPersistenceManager());
            if (srcObj == null) {
                return;
            }
            if (poObject.getObjectType().equalsIgnoreCase("MD_STORED_PROGRAMS")) {
                this.translateIndividualStoredProgram(translator, context, srcObj, (MdStoredProgram)poObject);
            } else if (poObject.getObjectType().equalsIgnoreCase("MD_VIEWS")) {
                this.translateIndividualViewDefinition(translator, context, srcObj, (MdView)poObject);
            } else if (poObject.getObjectType().equalsIgnoreCase("MD_TRIGGERS")) {
                if (((MdTrigger)poObject).getTriggerOnFlag().equalsIgnoreCase("V")) {
                    this.translateIndividualViewTrigger(translator, context, srcObj, (MdTrigger)poObject);
                } else if (((MdTrigger)poObject).getTriggerOnFlag().equalsIgnoreCase("T")) {
                    this.translateIndividualTableTrigger(translator, context, srcObj, (MdTrigger)poObject);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger("oracle.dbtools.migration").logp(Level.SEVERE, "Class", "Convert", e.getMessage(), e);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private static String multiLogHeader(String type, String name) {
        String format = MigrationAddinArb.getString(303);
        String i18nType = s_logger.getResourceBundle().getString(type);
        return MessageFormat.format(format, i18nType, name);
    }

    private void setSourceTranslated(PersistableObject sourcePO) {
        this.m_translatedSourceObjects.add(sourcePO.getKey());
    }

    private void rollbackConvert() {
        if (this.m_convertedConnection != null) {
            try {
                this.m_convertedConnection.delete(this.getPersistenceManager());
                this.m_convertedConnection = null;
                this.m_convertedConnectionId = null;
            }
            catch (PersistenceException pex) {
                s_logger.log(Level.WARNING, "Convert.ERROR_ROLLING_BACK", new Object[]{pex.getLocalizedMessage()});
            }
        }
    }
}

