/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.util.Collection;
import java.util.HashMap;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeConversionMap {
    private HashMap<DataTypeSpecification, DataTypeMappingRule> m_map = new HashMap();
    private HashMap<DataTypeSpecification, DataTypeMappingRule> m_udtMap = new HashMap();

    public void addRule(DataTypeMappingRule rule) {
        if (this.m_map.containsKey(rule.getSourceDataType())) {
            throw new IllegalStateException("Map already has a rule for " + rule.getSourceDataType().toString());
        }
        this.m_map.put(rule.getSourceDataType(), rule);
    }

    public void addOrReplaceRule(DataTypeMappingRule rule) {
        if (this.m_map.containsKey(rule.getSourceDataType())) {
            this.m_map.remove(rule.getSourceDataType());
        }
        this.addRule(rule);
    }

    public void addUDTRule(DataTypeMappingRule rule) {
        if (this.m_udtMap.containsKey(rule.getSourceDataType())) {
            throw new IllegalStateException("Map already has a rule for " + rule.getSourceDataType().toString());
        }
        this.m_udtMap.put(rule.getSourceDataType(), rule);
    }

    public DataTypeSpecification mapDataType(DataTypeSpecification source) {
        Integer scale;
        Integer precision;
        DataTypeMappingRule rule = null;
        int hiScore = 0;
        if (this.m_map.containsKey(source)) {
            rule = this.m_map.get(source);
            return rule.getTargetDataType();
        }
        if (this.m_udtMap != null && this.m_udtMap.containsKey(source)) {
            rule = this.m_udtMap.get(source);
            return rule.getTargetDataType();
        }
        Collection<DataTypeMappingRule> allRules = this.m_map.values();
        for (DataTypeMappingRule currentRule : allRules) {
            int thisScore = currentRule.getRuleMatchScore(source);
            if (thisScore <= hiScore) continue;
            rule = currentRule;
            hiScore = thisScore;
        }
        if (hiScore == 0) {
            return source;
        }
        String name = rule.getTargetDataType().getName();
        if (rule.getSourceDataType().hasPrecision()) {
            precision = rule.getTargetDataType().getPrecision();
            scale = rule.getSourceDataType().hasScale() ? rule.getTargetDataType().getScale() : source.getScale();
        } else {
            precision = source.getPrecision();
            scale = source.getScale();
        }
        return new DataTypeSpecification(name, precision, scale);
    }

    public Collection<DataTypeMappingRule> values() {
        return this.m_map.values();
    }
}

