/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import oracle.dbtools.migration.convert.DataTypeSpecification;

public class DataTypeMappingRule {
    private DataTypeSpecification m_sourceDataType;
    private DataTypeSpecification m_targetDataType;

    public DataTypeMappingRule(DataTypeSpecification source, DataTypeSpecification target) {
        this.setSourceDataType(source);
        this.setTargetDataType(target);
    }

    public DataTypeSpecification getSourceDataType() {
        return this.m_sourceDataType;
    }

    private void setSourceDataType(DataTypeSpecification sourceDataType) {
        if (sourceDataType == null) {
            throw new IllegalArgumentException("source data type cannot be null");
        }
        this.m_sourceDataType = sourceDataType;
    }

    public DataTypeSpecification getTargetDataType() {
        return this.m_targetDataType;
    }

    private void setTargetDataType(DataTypeSpecification targetDataType) {
        if (targetDataType == null) {
            throw new IllegalArgumentException("target data type cannot be null");
        }
        this.m_targetDataType = targetDataType;
    }

    public String toString() {
        return this.m_sourceDataType.toString() + " => " + this.m_targetDataType.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRuleMatchScore(DataTypeSpecification test) {
        DataTypeSpecification source = this.getSourceDataType();
        int score = 0;
        if (!source.getName().equals(test.getName())) return 0;
        ++score;
        if (source.hasPrecision()) {
            if (!source.getPrecision().equals(test.getPrecision())) return 0;
            ++score;
            if (source.hasScale()) {
                if (!source.getScale().equals(test.getScale())) return 0;
                ++score;
                return score;
            } else {
                if (test.hasScale()) return score;
                ++score;
            }
            return score;
        } else {
            if (test.hasPrecision()) return score;
            ++score;
            ++score;
        }
        return score;
    }
}

