/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import oracle.dbtools.migration.workbench.core.MigrationAddinArb;

public class DataTypeSpecification {
    protected String m_name;
    protected Integer m_precision;
    protected Integer m_scale;

    public String getName() {
        return this.m_name;
    }

    protected void setName(String name) {
        this.m_name = name;
    }

    public Integer getPrecision() {
        return this.m_precision;
    }

    public void setPrecision(Integer precision) {
        this.m_precision = precision;
    }

    public Integer getScale() {
        return this.m_scale;
    }

    public void setScale(Integer scale) {
        this.m_scale = scale;
    }

    public DataTypeSpecification(String name) {
        this(name, null, null);
    }

    public DataTypeSpecification(String name, int precision) {
        this(name, (Integer)precision, null);
    }

    public DataTypeSpecification(String name, int precision, int scale) {
        this(name, (Integer)precision, (Integer)scale);
    }

    public DataTypeSpecification(String name, Integer precision, Integer scale) {
        if (precision == null && scale != null) {
            throw new IllegalArgumentException("Scale cannot have a value if precision is null");
        }
        this.setName(name);
        this.setPrecision(precision);
        this.setScale(scale);
    }

    public boolean hasPrecision() {
        return this.m_precision != null;
    }

    public boolean hasScale() {
        return this.m_scale != null;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.toUpperCase().hashCode());
        result = 31 * result + (this.m_precision == null ? 0 : this.m_precision.hashCode());
        result = 31 * result + (this.m_scale == null ? 0 : this.m_scale.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataTypeSpecification other = (DataTypeSpecification)obj;
        if (this.m_name == null ? other.m_name != null : !this.m_name.equalsIgnoreCase(other.m_name)) {
            return false;
        }
        if (this.m_precision == null ? other.m_precision != null : !this.m_precision.equals(other.m_precision)) {
            return false;
        }
        return !(this.m_scale == null ? other.m_scale != null : !this.m_scale.equals(other.m_scale));
    }

    public String toString() {
        StringBuffer sBuf = new StringBuffer();
        sBuf.append(this.getName());
        if (this.hasPrecision()) {
            sBuf.append('[');
            Integer precision = this.getPrecision();
            if (precision == -999) {
                sBuf.append(MigrationAddinArb.getString(273));
            } else {
                sBuf.append(this.getPrecision().toString());
            }
            if (this.hasScale()) {
                sBuf.append(',');
                sBuf.append(this.getScale().toString());
            }
            sBuf.append(']');
        }
        return sBuf.toString();
    }
}

