/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.migration.convert.TextMappingResult;
import oracle.dbtools.migration.convert.TextMappingRule;
import oracle.dbtools.migration.convert.TextMappingRuleSet;

public class TextMappingRuleSetImpl
implements TextMappingRuleSet {
    private ArrayList<TextMappingRule> m_rules = new ArrayList();

    public TextMappingRuleSetImpl() {
    }

    public TextMappingRuleSetImpl(TextMappingRule[] rules) {
        this();
        for (TextMappingRule rule : rules) {
            this.addRule(rule);
        }
    }

    public void addRule(TextMappingRule rule) {
        this.m_rules.add(rule);
    }

    public TextMappingResult applyRules(String source) {
        for (TextMappingRule rule : this.m_rules) {
            Pattern pattern = Pattern.compile(rule.getPattern());
            Matcher matcher = pattern.matcher(source);
            if (!matcher.find()) continue;
            return new TextMappingResult(source, matcher.replaceFirst(rule.getReplacement()), rule.shouldWarn());
        }
        return null;
    }
}

