/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectHierarchy;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdMigrParameter;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.ParameterIterator;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.exceptions.TranslationObjectNotFoundException;
import oracle.dbtools.migration.translation.api.objects.TranslationColumn;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationDatabase;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;
import oracle.dbtools.migration.workbench.core.preferences.ConfigurationData;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationContext
implements ITranslationContext {
    public static final int DEFAULT_MAX_ENTRIES = 500;
    private static final String QUERY_TRANSFORMED_OBJECTS = "SELECT src_type, original_identifier, new_identifier FROM md_derivatives WHERE transformed IS NOT NULL AND src_type = derived_type AND derived_connection_id_fk = ? ORDER BY src_type";
    private static final String QUERY_FIND_DERIVED_OBJECT = "SELECT new_identifier FROM md_derivatives WHERE transformed IS NOT NULL AND src_type = derived_type AND derived_connection_id_fk = ? AND src_type = ? AND original_identifier = ?";
    private static final String QUERY_REVERSE_FIND_DERIVED_OBJECT = "SELECT original_identifier FROM md_derivatives WHERE transformed IS NOT NULL AND src_type = derived_type AND derived_connection_id_fk = ? AND src_type = ? AND new_identifier = ?";
    private DBObjectId m_connectionId;
    private int m_maxEntries;
    private int m_numEntries;
    private PersistenceManager m_persistenceManager;
    private HashMap<String, HashMap<String, String>> m_cache;
    private DataTypeConversionMap m_conversionMap;
    private HashMap<String, String> m_infoKeyValue = new HashMap();

    public TranslationContext(PersistenceManager pman, DBObjectId connectionId, int maxEntries, DBObjectId mapId) throws PersistenceException {
        this.setConnectionId(connectionId);
        this.setPersistenceManager(pman);
        this.setMaxEntries(maxEntries);
        this.m_conversionMap = ConvertUtils.getPersistedMap(this.getPersistenceManager(), this.getConnectionId());
        this.cacheTransformations();
    }

    protected void setConnectionId(DBObjectId connectionId) {
        this.m_connectionId = connectionId;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    private boolean addToCache(String type, String orig, String transformed) {
        HashMap<Object, Object> innerMap;
        boolean newMap = false;
        if (this.m_numEntries == this.m_maxEntries) {
            return false;
        }
        if (this.m_cache == null) {
            this.m_cache = new HashMap();
        }
        if (this.m_cache.containsKey(type)) {
            innerMap = this.m_cache.get(type);
        } else {
            innerMap = new HashMap();
            newMap = true;
        }
        if (!innerMap.containsKey(orig)) {
            innerMap.put(orig, transformed);
            ++this.m_numEntries;
        }
        if (newMap) {
            this.m_cache.put(type, innerMap);
        }
        return true;
    }

    private void cacheTransformations() throws PersistenceException {
        CloseableResultSet crs = null;
        try {
            String sTrans;
            String sOrig;
            String sType;
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement(QUERY_TRANSFORMED_OBJECTS);
            stmt.setLong(1, this.getConnectionId().getId());
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            while (rs.next() && this.addToCache(sType = rs.getString("SRC_TYPE"), sOrig = rs.getString("ORIGINAL_IDENTIFIER"), sTrans = rs.getString("NEW_IDENTIFIER"))) {
            }
            crs.close();
        }
        catch (SQLException sqlex) {
            if (crs != null) {
                crs.close();
            }
            throw new PersistenceException(sqlex);
        }
    }

    public DBObjectId getConnectionId() {
        return this.m_connectionId;
    }

    public PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected int getMaxEntries() {
        return this.m_maxEntries;
    }

    protected void setMaxEntries(int maxEntries) {
        this.m_maxEntries = maxEntries;
    }

    public boolean cacheFull() {
        return this.m_numEntries == this.m_maxEntries;
    }

    protected String findDerivedName(String name, String type) throws PersistenceException {
        return this.mdQuery(name, type, QUERY_FIND_DERIVED_OBJECT);
    }

    protected String reverseLookup(String name, String type) throws PersistenceException {
        return this.mdQuery(name, type, QUERY_REVERSE_FIND_DERIVED_OBJECT);
    }

    protected String mdQuery(String name, String type, String query) throws PersistenceException {
        CloseableResultSet crs = null;
        String transformedName = null;
        try {
            PreparedStatement stmt = this.getPersistenceManager().getPreparedStatement(query);
            stmt.setLong(1, this.getConnectionId().getId());
            stmt.setString(2, type);
            stmt.setString(3, name);
            ResultSet rs = stmt.executeQuery();
            crs = new CloseableResultSet(null, rs);
            if (rs.next()) {
                transformedName = rs.getString(1);
            }
        }
        catch (SQLException sqlex) {
            throw new PersistenceException(sqlex);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
        return transformedName;
    }

    public void completeSourceObject(TranslationDBObjectReference dbref, Object omwbObjOfCaller) throws TranslationObjectNotFoundException {
        DBObjectHierarchy callerHierarchy = new DBObjectHierarchy((PersistableObject)omwbObjOfCaller, this.getPersistenceManager());
        PersistableObject poDBRef = null;
        this.syncObjectWithCallerHierarchy(dbref, callerHierarchy);
        try {
            poDBRef = (dbref.getDatabaseName() == null || callerHierarchy.getCatalog().getCatalogName().equalsIgnoreCase(dbref.getDatabaseName())) && (dbref.getOwnerName() == null || callerHierarchy.getSchema().getName().equalsIgnoreCase(dbref.getOwnerName())) ? this.getPersistableObject(callerHierarchy.getSchema(), dbref) : (callerHierarchy.getCatalog().getCatalogName().equalsIgnoreCase(dbref.getDatabaseName()) ? this.getPeristableObject(callerHierarchy.getCatalog(), dbref) : this.getPeristableObject(callerHierarchy.getConnection(), dbref));
        }
        catch (Exception e) {
            throw new TranslationObjectNotFoundException();
        }
        dbref.setOMWBObj((Object)poDBRef);
        dbref.setType(TranslationContext.getRosettaObjectType(poDBRef));
    }

    private void syncObjectWithCallerHierarchy(TranslationDBObjectReference dbref, DBObjectHierarchy callerHierarchy) {
        try {
            if (dbref.getServerName() == null) {
                dbref.setServerName(callerHierarchy.getConnection().getHost());
            }
            if (dbref.getDatabaseName() == null) {
                dbref.setDatabaseName(callerHierarchy.getCatalog().getCatalogName());
            }
            if (dbref.getOwnerName() == null) {
                dbref.setOwnerName(callerHierarchy.getSchema().getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private PersistableObject getPeristableObject(MdConnection connection, TranslationDBObjectReference dbref) throws PersistenceException, NoSuchObjectException {
        MdCatalog poCatalog = null;
        PersistenceUtility pu = PersistenceUtility.getInstance(this.getPersistenceManager());
        DBObjectId catalogId = pu.getIdForCatalog(connection.getKey(), dbref.getDatabaseName());
        poCatalog = (MdCatalog)pu.loadPersistableObject(catalogId, "MD_CATALOGS");
        return this.getPeristableObject(poCatalog, dbref);
    }

    private PersistableObject getPeristableObject(MdCatalog catalog, TranslationDBObjectReference dbref) throws PersistenceException, NoSuchObjectException {
        MdSchema poSchema = null;
        PersistenceUtility pu = PersistenceUtility.getInstance(this.getPersistenceManager());
        DBObjectId schemaId = pu.getIdForSchema(catalog.getKey(), dbref.getOwnerName());
        if (schemaId == null) {
            return null;
        }
        poSchema = (MdSchema)pu.loadPersistableObject(schemaId, "MD_SCHEMAS");
        return this.getPersistableObject(poSchema, dbref);
    }

    private PersistableObject getPersistableObject(MdSchema schema, TranslationDBObjectReference dbref) throws PersistenceException, NoSuchObjectException {
        PersistableObject poDBRef = null;
        DBObjectId dbRefId = null;
        PersistenceUtility pu = PersistenceUtility.getInstance(this.getPersistenceManager());
        if (dbref.getType() == null) {
            return null;
        }
        if (dbref.getType().equals(TranslationObjectType.PROCEDURE_OR_FUNCTION_TYPE) || dbref.getType().equals(TranslationObjectType.PROCEDURE_TYPE) || dbref.getType().equals(TranslationObjectType.FUNCTION_TYPE)) {
            dbRefId = pu.getIdForStoredProgram(schema.getKey(), dbref.getObjName());
            poDBRef = pu.loadPersistableObject(dbRefId, "MD_STORED_PROGRAMS");
        } else if (dbref.getType().equals(TranslationObjectType.TABLE_OR_VIEW_TYPE) || dbref.getType().equals(TranslationObjectType.TABLE_TYPE) || dbref.getType().equals(TranslationObjectType.VIEW_TYPE)) {
            try {
                dbRefId = pu.getIdForTable(schema.getKey(), dbref.getObjName());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (dbRefId != null) {
                dbRefId = pu.getIdForTable(schema.getKey(), dbref.getObjName());
                poDBRef = pu.loadPersistableObject(dbRefId, "MD_TABLES");
            } else {
                dbRefId = pu.getIdForView(schema.getKey(), dbref.getObjName());
                poDBRef = pu.loadPersistableObject(dbRefId, "MD_VIEWS");
            }
        } else if (dbref.getType().equals(TranslationObjectType.TRIGGER_TYPE)) {
            dbRefId = pu.getIdForTrigger(schema.getKey(), dbref.getObjName());
            poDBRef = pu.loadPersistableObject(dbRefId, "MD_TRIGGERS");
        } else if (dbref.getType().equals(TranslationObjectType.COLUMN_TYPE)) {
            DBObjectId tableOrViewDBRefId = null;
            try {
                tableOrViewDBRefId = pu.getIdForTable(schema.getKey(), dbref.getObjName());
                dbRefId = pu.getIdForColumn(tableOrViewDBRefId, dbref.getPartName());
                poDBRef = pu.loadPersistableObject(dbRefId, "MD_COLUMNS");
            }
            catch (PersistenceException pe) {
                if (dbref.getObjName() == null) {
                    throw pe;
                }
                try {
                    tableOrViewDBRefId = pu.getIdForView(schema.getKey(), dbref.getObjName());
                    poDBRef = pu.loadPersistableObject(tableOrViewDBRefId, "MD_VIEWS");
                    return poDBRef;
                }
                catch (Exception e) {
                    throw pe;
                }
            }
        } else {
            poDBRef = null;
        }
        return poDBRef;
    }

    public TranslationDBObjectReference getTargetDBObjectReference(TranslationDBObjectReference srcObj, Object omwbObjOfCaller) throws TranslationObjectNotFoundException {
        if (srcObj.getType().equals(TranslationObjectType.COLUMN_TYPE) && srcObj.getObjName() == null) {
            return null;
        }
        if (srcObj.getType().equals(TranslationObjectType.COLUMN_TYPE) && srcObj.getPartName().equals("*")) {
            srcObj.setType(TranslationObjectType.TABLE_OR_VIEW_TYPE);
        }
        if (srcObj.getOMWBObj() == null) {
            this.completeSourceObject(srcObj, omwbObjOfCaller);
        }
        PersistableObject targetPO = null;
        PersistableObject sourcePO = (PersistableObject)srcObj.getOMWBObj();
        try {
            targetPO = ConvertUtils.findPersistableCopy(this.getPersistenceManager(), sourcePO, this.getConnectionId());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (targetPO == null) {
            return null;
        }
        DBObjectHierarchy targetHierarchy = new DBObjectHierarchy(targetPO, this.getPersistenceManager());
        return targetHierarchy.getTranslationDBObjectReference();
    }

    public static TranslationObjectType getRosettaObjectType(PersistableObject poObject) {
        if (poObject == null) {
            return null;
        }
        String omwbObjectType = poObject.getObjectType();
        TranslationObjectType translationObjectType = null;
        if (omwbObjectType.equalsIgnoreCase("MD_TABLES")) {
            translationObjectType = TranslationObjectType.TABLE_TYPE;
        } else if (omwbObjectType.equalsIgnoreCase("MD_VIEWS")) {
            translationObjectType = TranslationObjectType.VIEW_TYPE;
        } else if (omwbObjectType.equalsIgnoreCase("MD_TRIGGERS")) {
            translationObjectType = TranslationObjectType.TRIGGER_TYPE;
        } else if (omwbObjectType.equalsIgnoreCase("MD_INDEXES")) {
            translationObjectType = TranslationObjectType.INDEX_TYPE;
        } else if (omwbObjectType.equalsIgnoreCase("MD_SEQUENCES")) {
            translationObjectType = TranslationObjectType.SEQUENCE_TYPE;
        } else if (omwbObjectType.equalsIgnoreCase("MD_STORED_PROGRAMS")) {
            translationObjectType = ((MdStoredProgram)poObject).getProgramtype() == null ? TranslationObjectType.PROCEDURE_TYPE : (((MdStoredProgram)poObject).getProgramtype().equalsIgnoreCase("FN") || ((MdStoredProgram)poObject).getProgramtype().equalsIgnoreCase("IF") || ((MdStoredProgram)poObject).getProgramtype().equalsIgnoreCase("TF") ? TranslationObjectType.FUNCTION_TYPE : (((MdStoredProgram)poObject).getProgramtype().startsWith("P") ? TranslationObjectType.PROCEDURE_TYPE : TranslationObjectType.PROCEDURE_TYPE));
        } else if (omwbObjectType.equalsIgnoreCase("MD_CONSTRAINTS")) {
            translationObjectType = TranslationObjectType.CONSTRAINT_TYPE;
        } else if (omwbObjectType.equalsIgnoreCase("MD_COLUMNS")) {
            translationObjectType = TranslationObjectType.COLUMN_TYPE;
        }
        return translationObjectType;
    }

    public void completeSourceColumn(TranslationColumn arg0, Object arg1) throws TranslationObjectNotFoundException {
    }

    public TranslationDatabase getExpectedTargetDatabase(Object arg0) {
        return null;
    }

    public ArrayList<TranslationDBObjectReference> getObjectsDependentOnThisSource(TranslationDBObjectReference arg0) throws TranslationObjectNotFoundException {
        return null;
    }

    public ArrayList<TranslationDBObjectReference> getObjectsDependentOnThisTarget(TranslationDBObjectReference arg0) throws TranslationObjectNotFoundException {
        return null;
    }

    public ArrayList<TranslationColumn> getSourceColumns(TranslationDBObjectReference arg0) {
        return null;
    }

    public TranslationDatabase getSourceDatabase(Object arg0) throws TranslationObjectNotFoundException {
        return null;
    }

    public ArrayList<TranslationDBObjectReference> getSourceObjectsThisDependsOn(TranslationDBObjectReference arg0) throws TranslationObjectNotFoundException {
        return null;
    }

    public ArrayList<TranslationParameter> getSourceParameters(TranslationDBObjectReference sourceParentObjRef) throws TranslationObjectNotFoundException {
        return this.getParameters(sourceParentObjRef);
    }

    public ArrayList<TranslationParameter> getTargetParameters(TranslationDBObjectReference targetParentObjRef) throws TranslationObjectNotFoundException {
        return this.getParameters(targetParentObjRef);
    }

    public ArrayList<TranslationParameter> getParameters(TranslationDBObjectReference parentObjRef) throws TranslationObjectNotFoundException {
        ArrayList<TranslationParameter> translationParameters = new ArrayList<TranslationParameter>();
        ParameterIterator paramIt = null;
        try {
            paramIt = new ParameterIterator(this.getPersistenceManager(), ((PersistableObject)parentObjRef.getOMWBObj()).getKey());
        }
        catch (PersistenceException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        if (paramIt == null) {
            return null;
        }
        TranslationParameter translationParam = null;
        while (paramIt.hasNext()) {
            MdMigrParameter param = (MdMigrParameter)paramIt.next();
            translationParam = new TranslationParameter();
            translationParam.setExtra(param.getParamExisting() == 1);
            translationParam.setName(param.getParamName());
            translationParam.setParamPosition(param.getParamOrder().intValue());
            translationParam.setParamType(param.getParamType());
            translationParam.setDataType(new TranslationDataType(param.getParamDataType()));
            translationParam.setDefaultValueStr(param.getDefaultValue());
            translationParameters.add(translationParam);
        }
        return translationParameters;
    }

    public ArrayList<TranslationColumn> getTargetColumns(TranslationDBObjectReference arg0) throws TranslationObjectNotFoundException {
        if (arg0.getType().equals(TranslationObjectType.COLUMN_TYPE) && arg0.getObjName() == null) {
            return null;
        }
        this.completeSourceObject(arg0, arg0.getOMWBObj());
        PersistableObject targetPO = null;
        try {
            targetPO = ConvertUtils.findPersistableCopy(this.getPersistenceManager(), (PersistableObject)arg0.getOMWBObj(), this.getConnectionId());
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        if (targetPO == null) {
            return null;
        }
        ArrayList<TranslationColumn> columns = new ArrayList<TranslationColumn>();
        try {
            CloseableIterator cols = PersistenceUtility.getInstance(this.getPersistenceManager()).getColumnsForTableId(targetPO.getKey());
            while (cols.hasNext()) {
                MdColumn col = (MdColumn)cols.next();
                columns.add(new TranslationColumn(new TranslationDBObjectReference(null, null, null, col.getColumnName(), null, TranslationObjectType.COLUMN_TYPE, null), new TranslationDataType(col.getColumnType())));
            }
        }
        catch (PersistenceException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return null;
        }
        return columns;
    }

    public TranslationDataType getTargetDataType(TranslationDataType sourceDataType, Object arg1) {
        Integer sourceScale;
        Integer sourcePrecision;
        String sourceName = sourceDataType.getDataType();
        try {
            sourcePrecision = Integer.valueOf(sourceDataType.getPrecision());
        }
        catch (Exception e) {
            sourcePrecision = null;
        }
        try {
            sourceScale = Integer.valueOf(sourceDataType.getScale());
        }
        catch (Exception e2) {
            sourceScale = null;
        }
        DataTypeSpecification mappedDataType = this.m_conversionMap.mapDataType(new DataTypeSpecification(sourceName, sourcePrecision, sourceScale));
        if (mappedDataType == null) {
            return null;
        }
        TranslationDataType ret = new TranslationDataType(mappedDataType.getName());
        if (mappedDataType.getPrecision() != null) {
            ret.setPrecision(mappedDataType.getPrecision().toString());
        }
        if (mappedDataType.getScale() != null) {
            ret.setScale(mappedDataType.getScale().toString());
        }
        ret.setSchema(sourceDataType.getSchema());
        return ret;
    }

    public ArrayList<TranslationDBObjectReference> getTargetObjectsThisDependsOn(TranslationDBObjectReference arg0) throws TranslationObjectNotFoundException {
        return null;
    }

    public TranslationPreferences getTranslationPreferences(Object arg0) {
        TranslationPreferences tp = new TranslationPreferences();
        tp.setFormatMask(this.getFormatMaskPreference());
        tp.setQueryAssignmentPreference(this.getQueryAssignmentPreference());
        tp.setGenerateEntireEmulationPkg(this.getGenerateEntireEmulationPkg());
        tp.setIsQuotedIdentifierOn(this.getIsQuotedIdentifierOn());
        return tp;
    }

    private boolean getIsQuotedIdentifierOn() {
        Preferences prefs = null;
        try {
            prefs = Preferences.getPreferences();
        }
        catch (Exception e) {
            return true;
        }
        MigrationConfig data = MigrationConfig.getInstance((PropertyStorage)prefs);
        return data.isQuotedIdentifierOn();
    }

    private String getFormatMaskPreference() {
        Preferences prefs = null;
        try {
            prefs = Preferences.getPreferences();
        }
        catch (Exception e) {
            return null;
        }
        ConfigurationData data = ConfigurationData.getInstance((PropertyStorage)prefs);
        return data.getDateFormat();
    }

    private String getQueryAssignmentPreference() {
        Preferences prefs = null;
        try {
            prefs = Preferences.getPreferences();
        }
        catch (Exception e) {
            return null;
        }
        ConfigurationData data = ConfigurationData.getInstance((PropertyStorage)prefs);
        return data.getQueryAssignment();
    }

    private boolean getGenerateEntireEmulationPkg() {
        Preferences prefs = null;
        try {
            prefs = Preferences.getPreferences();
        }
        catch (Exception e) {
            return false;
        }
        ConfigurationData data = ConfigurationData.getInstance((PropertyStorage)prefs);
        return data.getGenerateEntireEmulationPkg();
    }

    public ArrayList<String> getEmulationFuncsForSchema(Object id) {
        DBObjectId schemaId = (DBObjectId)id;
        PersistenceUtility pu = PersistenceUtility.getInstance(this.getPersistenceManager());
        try {
            return pu.getEmulationFuncsForSchema(schemaId);
        }
        catch (PersistenceException e) {
            return null;
        }
    }

    public ArrayList<String> getEmulationFuncsForConnection(Object id) {
        DBObjectId connectionId = (DBObjectId)id;
        PersistenceUtility pu = PersistenceUtility.getInstance(this.getPersistenceManager());
        try {
            return pu.getEmulationFuncsForConnection(connectionId);
        }
        catch (PersistenceException e) {
            return null;
        }
    }

    public String getInfoKeyValue(String key) {
        return this.m_infoKeyValue.get(key);
    }

    public void addInfoKeyValue(String key, String value) {
        this.m_infoKeyValue.put(key, value);
    }

    public void clearInfoKey() {
        this.m_infoKeyValue.clear();
    }

    public void setPreferences(TranslationPreferences prefs) {
    }
}

