/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectHierarchy;
import oracle.dbtools.metadata.persistence.MdMigrDependency;
import oracle.dbtools.metadata.persistence.MdMigrWeakdep;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MultiLevelLogManager;
import oracle.dbtools.migration.translation.api.ITranslationLogging;
import oracle.dbtools.migration.translation.api.TranslationLimitation;
import oracle.dbtools.migration.translation.api.TranslationProgress;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.components.TranslationStatement;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationLogging
implements ITranslationLogging {
    private PersistenceManager m_pm = null;
    private MultiLevelLogManager m_translationLogManager;
    private static ResourceBundle s_bundle = Logger.getLogger("oracle.dbtools.migration").getResourceBundle();

    public TranslationLogging(PersistenceManager pm, MultiLevelLogManager translationLogManager) {
        this.m_pm = pm;
        this.m_translationLogManager = translationLogManager;
    }

    public void saveSourceDependency(TranslationDBObjectReference parentObject, TranslationDBObjectReference childObject) {
        if (childObject.getOMWBObj() == null) {
            this.saveWeakDependency(parentObject, childObject);
        } else {
            this.saveDependency(parentObject, childObject);
        }
    }

    public void saveTargetDependency(TranslationDBObjectReference parentObject, TranslationDBObjectReference childObject) {
        if (childObject.getOMWBObj() == null) {
            this.saveWeakDependency(parentObject, childObject);
        } else {
            this.saveDependency(parentObject, childObject);
        }
    }

    public void saveSourceParameters(TranslationDBObjectReference dbObject, ArrayList<TranslationParameter> parameters) {
    }

    public void saveTargetParameters(TranslationDBObjectReference dbObject, ArrayList<TranslationParameter> parameters) {
    }

    public void saveSourceStatementUsage(TranslationDBObjectReference dbObject, TranslationStatement statement) {
    }

    public void saveTargetStatementUsage(TranslationDBObjectReference dbObject, TranslationStatement statement) {
    }

    public void reportLimitation(TranslationLimitation limitation) {
        try {
            String type = s_bundle.getString(((PersistableObject)limitation.getSourceDBObject().getOMWBObj()).getObjectType());
            this.m_translationLogManager.logMessage((PersistableObject)limitation.getSourceDBObject().getOMWBObj(), Level.WARNING, "Convert.TRANSLATION_LIMITATION", new Object[]{limitation.getLabel(), type, limitation.getSourceDBObject().getFullName(), limitation.getStartLine(), limitation.getStartColumn()});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reportTranslationProgress(TranslationProgress progress) {
    }

    private void saveDependency(TranslationDBObjectReference parentObject, TranslationDBObjectReference childObject) {
        if (parentObject == null || childObject == null || parentObject.getOMWBObj() == null || childObject.getOMWBObj() == null) {
            return;
        }
        PersistableObject parentPO = (PersistableObject)parentObject.getOMWBObj();
        PersistableObject childPO = (PersistableObject)childObject.getOMWBObj();
        DBObjectHierarchy parentHierarchy = new DBObjectHierarchy(parentPO, this.m_pm);
        MdMigrDependency dep = new MdMigrDependency(parentHierarchy.getConnection().getKey(), parentPO.getKey(), childPO.getKey(), parentPO.getObjectType(), childPO.getObjectType());
        try {
            dep.save(this.m_pm);
        }
        catch (PersistenceException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void saveWeakDependency(TranslationDBObjectReference parentObject, TranslationDBObjectReference childObject) {
        if (parentObject == null || childObject == null || childObject.getType() != TranslationObjectType.EMULATION_TYPE) {
            return;
        }
        PersistableObject parentPO = (PersistableObject)parentObject.getOMWBObj();
        if (parentPO == null) {
            return;
        }
        DBObjectHierarchy parentHierarchy = new DBObjectHierarchy(parentPO, this.m_pm);
        MdMigrWeakdep dep = null;
        dep = new MdMigrWeakdep(parentHierarchy.getConnection().getKey(), parentHierarchy.getSchema().getKey(), parentPO.getKey(), childObject.getObjName(), parentPO.getObjectType(), childObject.getType().getSimpleTypeName());
        try {
            dep.save(this.m_pm);
        }
        catch (PersistenceException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }
}

