/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.convert.ValidDataTypeSpecification;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSupportedDataTypesMap
implements SupportedDataTypesMap {
    private HashMap<DataTypeSpecification, ArrayList<DataTypeSpecification>> m_theMap;
    private List<ValidDataTypeSpecification> m_validDataTypes;

    public XMLSupportedDataTypesMap(InputStream xml) throws SAXException, IOException {
        DOMParser parser = new DOMParser();
        parser.setPreserveWhitespace(true);
        parser.parse(xml);
        this.m_theMap = new HashMap();
        this.m_validDataTypes = new ArrayList<ValidDataTypeSpecification>();
        XMLDocument doc = parser.getDocument();
        Node rootNode = doc.getChildNodes().item(0);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            XMLNode[] allTargets;
            Node node = nodes.item(i);
            if (!node.getNodeName().equals("DataTypeMapping")) continue;
            Node sourceDataTypeNode = XMLHelper.getChildNode((Node)node, (String)"sourceDataType");
            ArrayList<DataTypeSpecification> listOfTargets = new ArrayList<DataTypeSpecification>();
            DataTypeSpecification sourceSpec = XMLSupportedDataTypesMap.parseDataTypeNode(sourceDataTypeNode);
            ValidDataTypeSpecification validSourceSpec = this.parseValidityDataNode(sourceDataTypeNode);
            this.m_validDataTypes.add(validSourceSpec);
            Node targetTypeCollection = XMLHelper.getChildNode((Node)node, (String)"targetTypeCollection");
            for (XMLNode n : allTargets = XMLHelper.getChildNodes((Node)targetTypeCollection, (String)"targetType")) {
                DataTypeSpecification targetSpec = XMLSupportedDataTypesMap.parseDataTypeNode((Node)n);
                listOfTargets.add(targetSpec);
            }
            this.m_theMap.put(sourceSpec, listOfTargets);
        }
    }

    private ValidDataTypeSpecification parseValidityDataNode(Node sourceDataTypeNode) {
        Node scaleRange;
        Integer maxPrecision = null;
        Integer minPrecision = null;
        Integer maxScale = null;
        Integer minScale = null;
        boolean isPrecisionMandatory = false;
        boolean isScaleMandatory = false;
        String name = XMLHelper.getAttributeNode((Node)sourceDataTypeNode, (String)"name");
        Node precisionRange = XMLHelper.getChildNode((Node)sourceDataTypeNode, (String)"precisionRange");
        if (precisionRange != null) {
            String max = XMLHelper.getAttributeNode((Node)precisionRange, (String)"max");
            String min = XMLHelper.getAttributeNode((Node)precisionRange, (String)"min");
            String nullable = XMLHelper.getAttributeNode((Node)precisionRange, (String)"nullable");
            if (max != null && max.trim().length() > 0) {
                maxPrecision = new Integer(max);
            }
            if (min != null && min.trim().length() > 0) {
                minPrecision = new Integer(min);
            }
            if (nullable != null && nullable.trim().length() > 0) {
                isPrecisionMandatory = Boolean.parseBoolean(nullable);
            }
        }
        if ((scaleRange = XMLHelper.getChildNode((Node)sourceDataTypeNode, (String)"scaleRange")) != null) {
            String max = XMLHelper.getAttributeNode((Node)scaleRange, (String)"max");
            String min = XMLHelper.getAttributeNode((Node)scaleRange, (String)"min");
            String nullable = XMLHelper.getAttributeNode((Node)scaleRange, (String)"nullable");
            if (max != null && max.trim().length() > 0) {
                maxScale = new Integer(max);
            }
            if (min != null && min.trim().length() > 0) {
                minScale = new Integer(min);
            }
            if (nullable != null && nullable.trim().length() > 0) {
                isScaleMandatory = Boolean.parseBoolean(nullable);
            }
        }
        ValidDataTypeSpecification spec = new ValidDataTypeSpecification(name);
        spec.setMaxPrecision(maxPrecision);
        spec.setMaxScale(maxScale);
        spec.setMinPrecision(minPrecision);
        spec.setMinScale(minScale);
        spec.setPrecisionMandatory(isPrecisionMandatory);
        spec.setScaleMandatory(isScaleMandatory);
        return spec;
    }

    public DataTypeMappingRule[] getRulesForDataType(DataTypeSpecification datatype) {
        DataTypeMappingRule[] rules;
        if (this.m_theMap.containsKey(datatype)) {
            ArrayList<DataTypeSpecification> targetSpecs = this.m_theMap.get(datatype);
            rules = new DataTypeMappingRule[targetSpecs.size()];
            int i = 0;
            for (DataTypeSpecification spec : targetSpecs) {
                rules[i++] = new DataTypeMappingRule(datatype, spec);
            }
        } else {
            rules = new DataTypeMappingRule[]{new DataTypeMappingRule(datatype, datatype)};
        }
        return rules;
    }

    public DataTypeSpecification[] getSourceDataTypes() {
        Set<DataTypeSpecification> sources = this.m_theMap.keySet();
        return sources.toArray(new DataTypeSpecification[sources.size()]);
    }

    private static DataTypeSpecification parseDataTypeNode(Node node) {
        String name = XMLHelper.getAttributeNode((Node)node, (String)"name");
        String s = XMLHelper.getAttributeNode((Node)node, (String)"precision");
        Integer precision = s != null && s.trim().length() > 0 ? new Integer(s) : null;
        s = XMLHelper.getAttributeNode((Node)node, (String)"scale");
        Integer scale = s != null && s.trim().length() > 0 ? new Integer(s) : null;
        DataTypeSpecification spec = new DataTypeSpecification(name, precision, scale);
        return spec;
    }

    public ValidDataTypeSpecification[] getValidDataTypes() {
        return this.m_validDataTypes.toArray(new ValidDataTypeSpecification[0]);
    }
}

