/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.migration.core.Cancelable;

public abstract class MigrationContext
implements Cancelable {
    private boolean m_shouldCancel = false;
    private static final String FIELD_REGEX = "\\$\\{.+?\\}";
    protected Map<String, Object> m_vars = Collections.synchronizedMap(new HashMap());

    public void setContextVariable(String variableName, Object value) {
        this.m_vars.put(variableName.toUpperCase(), value);
    }

    public void resetContextVariable(String variableName) {
        String sSearch = variableName.toUpperCase();
        if (this.m_vars.containsKey(sSearch)) {
            this.m_vars.remove(sSearch);
        }
    }

    public Object getContextVariable(String variableName) {
        String sSearch = variableName.toUpperCase();
        if (this.m_vars.containsKey(sSearch)) {
            return this.m_vars.get(sSearch);
        }
        return null;
    }

    public String applyToSQLString(String sql) {
        Pattern pattern = Pattern.compile(FIELD_REGEX);
        Matcher matcher = pattern.matcher(sql);
        StringBuffer sbuf = new StringBuffer();
        String replacement = "";
        while (matcher.find()) {
            Object contextVar;
            String token = matcher.group();
            if ((token = ((Object)token.subSequence(2, token.length() - 1)).toString().toUpperCase()).indexOf(46) != -1) {
                String varname = token.substring(0, token.indexOf(46));
                String propname = token.substring(token.indexOf(46) + 1);
                contextVar = this.getContextVariable(varname);
                if (!(contextVar instanceof PersistableObject)) {
                    throw new IllegalStateException("Invalid syntax on variable name " + token);
                }
                PersistableObject po = (PersistableObject)contextVar;
                replacement = po.getProperty(propname);
                if (replacement == null) {
                    throw new IllegalStateException("No such variable in the context: " + token);
                }
            } else {
                contextVar = this.getContextVariable(token);
                if (contextVar == null) {
                    throw new IllegalStateException("No such variable in the context: " + token);
                }
                replacement = contextVar.toString();
            }
            matcher.appendReplacement(sbuf, replacement);
        }
        matcher.appendTail(sbuf);
        return sbuf.toString();
    }

    public void signalCancel() {
        this.m_shouldCancel = true;
    }

    public boolean shouldCancel() {
        return this.m_shouldCancel;
    }
}

